/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptorSupport;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptorSupport;
import org.axonframework.queryhandling.MonoWrapper;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public interface QueryBus
extends MessageHandlerInterceptorSupport<QueryMessage<?, ?>>,
MessageDispatchInterceptorSupport<QueryMessage<?, ?>> {
    public <R> Registration subscribe(String var1, Type var2, MessageHandler<? super QueryMessage<?, R>> var3);

    public <Q, R> CompletableFuture<QueryResponseMessage<R>> query(QueryMessage<Q, R> var1);

    public <Q, R> Stream<QueryResponseMessage<R>> scatterGather(QueryMessage<Q, R> var1, long var2, TimeUnit var4);

    default public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(SubscriptionQueryMessage<Q, I, U> query) {
        return this.subscriptionQuery(query, Queues.SMALL_BUFFER_SIZE);
    }

    @Deprecated
    default public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(SubscriptionQueryMessage<Q, I, U> query, SubscriptionQueryBackpressure backpressure, int updateBufferSize) {
        return this.subscriptionQuery(query, updateBufferSize);
    }

    default public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(final SubscriptionQueryMessage<Q, I, U> query, int updateBufferSize) {
        return new SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>>(){

            @Override
            public Mono<QueryResponseMessage<I>> initialResult() {
                return MonoWrapper.create(monoSinkWrapper -> ((CompletableFuture)QueryBus.this.query(query).thenAccept(monoSinkWrapper::success)).exceptionally(t -> {
                    monoSinkWrapper.error((Throwable)t);
                    return null;
                })).getMono();
            }

            @Override
            public Flux<SubscriptionQueryUpdateMessage<U>> updates() {
                return Flux.empty();
            }

            @Override
            public boolean cancel() {
                return true;
            }
        };
    }

    public QueryUpdateEmitter queryUpdateEmitter();
}

