/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.messaging.StreamableMessageSource;

public interface StreamingEventProcessor
extends EventProcessor {
    public String getTokenStoreIdentifier();

    public void releaseSegment(int var1);

    public void releaseSegment(int var1, long var2, TimeUnit var4);

    public CompletableFuture<Boolean> splitSegment(int var1);

    public CompletableFuture<Boolean> mergeSegment(int var1);

    public boolean supportsReset();

    public void resetTokens();

    public <R> void resetTokens(R var1);

    public void resetTokens(Function<StreamableMessageSource<TrackedEventMessage<?>>, TrackingToken> var1);

    public <R> void resetTokens(Function<StreamableMessageSource<TrackedEventMessage<?>>, TrackingToken> var1, R var2);

    default public void resetTokens(TrackingToken startPosition) {
        this.resetTokens(startPosition, null);
    }

    public <R> void resetTokens(TrackingToken var1, R var2);

    public int maxCapacity();

    public Map<Integer, EventTrackerStatus> processingStatus();

    default public boolean isReplaying() {
        return this.processingStatus().values().stream().anyMatch(trackerStatus -> !trackerStatus.isCaughtUp() && trackerStatus.isReplaying());
    }
}

