/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.util.Objects;
import org.axonframework.common.Assert;
import org.axonframework.serialization.SerializedType;

public class SimpleSerializedType
implements SerializedType {
    private static final SerializedType EMPTY_TYPE = new SimpleSerializedType("empty", null);
    private final String type;
    private final String revisionId;

    public static SerializedType emptyType() {
        return EMPTY_TYPE;
    }

    public SimpleSerializedType(String objectType, String revisionNumber) {
        Assert.notNull(objectType, () -> "objectType cannot be null");
        this.type = objectType;
        this.revisionId = revisionNumber;
    }

    @Override
    public String getName() {
        return this.type;
    }

    @Override
    public String getRevision() {
        return this.revisionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSerializedType that = (SimpleSerializedType)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.revisionId, that.revisionId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.revisionId);
    }

    public String toString() {
        return String.format("SimpleSerializedType[%s] (revision %s)", this.type, this.revisionId);
    }
}

