/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.digest;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.axonframework.common.AxonConfigurationException;

public final class Digester {
    private final MessageDigest messageDigest;

    public static Digester newInstance(String algorithm) {
        try {
            return new Digester(MessageDigest.getInstance(algorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AxonConfigurationException("This environment doesn't support the MD5 hashing algorithm", e);
        }
    }

    public static Digester newMD5Instance() {
        return Digester.newInstance("MD5");
    }

    public static String md5Hex(String input) {
        try {
            return Digester.newMD5Instance().update(input.getBytes("UTF-8")).digestHex();
        }
        catch (UnsupportedEncodingException e) {
            throw new AxonConfigurationException("The UTF-8 encoding is not available on this environment", e);
        }
    }

    private Digester(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    public Digester update(byte[] additionalData) {
        this.messageDigest.update(additionalData);
        return this;
    }

    public String digestHex() {
        return Digester.hex(this.messageDigest.digest());
    }

    private static String hex(byte[] hash) {
        return Digester.pad(new BigInteger(1, hash).toString(16));
    }

    private static String pad(String md5) {
        if (md5.length() == 32) {
            return md5;
        }
        StringBuilder sb = new StringBuilder(32);
        for (int t = 0; t < 32 - md5.length(); ++t) {
            sb.append("0");
        }
        sb.append(md5);
        return sb.toString();
    }
}

