/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.callbacks;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.callbacks.FutureCallback;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FutureCallbackTest {
    private static final CommandMessage<Object> COMMAND_MESSAGE = GenericCommandMessage.asCommandMessage((Object)"Test");
    private static final CommandResultMessage<String> COMMAND_RESPONSE_MESSAGE = GenericCommandResultMessage.asCommandResultMessage((Object)"Hello world");
    private static final int THREAD_JOIN_TIMEOUT = 1000;
    private volatile FutureCallback<Object, Object> testSubject;
    private volatile Object resultFromParallelThread;

    FutureCallbackTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new FutureCallback();
    }

    @Test
    void onSuccess() throws InterruptedException {
        Thread t = new Thread(() -> {
            try {
                this.resultFromParallelThread = this.testSubject.get();
            }
            catch (Exception e) {
                this.resultFromParallelThread = e;
            }
        });
        t.start();
        Assertions.assertTrue((boolean)t.isAlive());
        this.testSubject.onResult(COMMAND_MESSAGE, COMMAND_RESPONSE_MESSAGE);
        t.join(1000L);
        Assertions.assertEquals(COMMAND_RESPONSE_MESSAGE, (Object)this.resultFromParallelThread);
    }

    @Test
    void onFailure() throws InterruptedException {
        Thread t = new Thread(() -> {
            try {
                this.resultFromParallelThread = this.testSubject.get();
            }
            catch (Exception e) {
                this.resultFromParallelThread = e;
            }
        });
        t.start();
        Assertions.assertTrue((boolean)t.isAlive());
        MockException exception = new MockException();
        this.testSubject.onResult(COMMAND_MESSAGE, GenericCommandResultMessage.asCommandResultMessage((Throwable)exception));
        t.join(1000L);
        Assertions.assertTrue((boolean)(this.resultFromParallelThread instanceof CommandResultMessage));
        Assertions.assertEquals((Object)exception, (Object)((CommandResultMessage)this.resultFromParallelThread).exceptionResult());
    }

    @Test
    void onSuccessForLimitedTime_Timeout() throws InterruptedException {
        Thread t = new Thread(() -> {
            try {
                this.resultFromParallelThread = this.testSubject.get(1L, TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                this.resultFromParallelThread = e;
            }
        });
        t.start();
        t.join(1000L);
        this.testSubject.onResult(COMMAND_MESSAGE, COMMAND_RESPONSE_MESSAGE);
        Assertions.assertTrue((boolean)(this.resultFromParallelThread instanceof TimeoutException));
    }

    @Test
    void onResultReturnsMessageWithTimeoutExceptionOnTimeout() throws InterruptedException {
        Thread t = new Thread(() -> {
            this.resultFromParallelThread = this.testSubject.getResult(1L, TimeUnit.NANOSECONDS);
        });
        t.start();
        t.join(1000L);
        this.testSubject.onResult(COMMAND_MESSAGE, COMMAND_RESPONSE_MESSAGE);
        Assertions.assertTrue((boolean)(this.resultFromParallelThread instanceof ResultMessage));
        Assertions.assertTrue((boolean)(((ResultMessage)this.resultFromParallelThread).exceptionResult() instanceof TimeoutException));
    }

    @Test
    void onResultUnwrapsExecutionResult() throws InterruptedException {
        Thread t = new Thread(() -> {
            this.resultFromParallelThread = this.testSubject.getResult();
        });
        t.start();
        this.testSubject.completeExceptionally((Throwable)new MockException("Mocking an exception"));
        t.join();
        Assertions.assertTrue((boolean)(this.resultFromParallelThread instanceof ResultMessage));
        Assertions.assertTrue((boolean)(((ResultMessage)this.resultFromParallelThread).exceptionResult() instanceof MockException));
    }

    @Test
    void getThrowsExecutionException() throws InterruptedException {
        Thread t = new Thread(() -> {
            try {
                this.testSubject.get();
            }
            catch (Exception e) {
                this.resultFromParallelThread = e;
            }
        });
        t.start();
        this.testSubject.completeExceptionally((Throwable)new MockException("Mocking an exception"));
        t.join();
        Assertions.assertTrue((boolean)(this.resultFromParallelThread instanceof ExecutionException));
    }

    @Test
    void onSuccessForLimitedTime_InTime() throws InterruptedException {
        Thread t = new Thread(() -> {
            try {
                this.resultFromParallelThread = this.testSubject.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.resultFromParallelThread = e;
            }
        });
        t.start();
        Assertions.assertTrue((boolean)t.isAlive());
        Assertions.assertFalse((boolean)this.testSubject.isDone());
        this.testSubject.onResult(COMMAND_MESSAGE, COMMAND_RESPONSE_MESSAGE);
        Assertions.assertTrue((boolean)this.testSubject.isDone());
        t.join(1000L);
        Assertions.assertEquals(COMMAND_RESPONSE_MESSAGE, (Object)this.resultFromParallelThread);
    }
}

