/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.distributed.CommandDispatchException;
import org.axonframework.commandhandling.distributed.UnresolvedRoutingKeyPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UnresolvedRoutingKeyPolicyTest {
    private final CommandMessage<String> testCommand = new GenericCommandMessage((Object)"some-payload");

    UnresolvedRoutingKeyPolicyTest() {
    }

    @Test
    void errorStrategy() {
        Assertions.assertThrows(CommandDispatchException.class, () -> UnresolvedRoutingKeyPolicy.ERROR.getRoutingKey(this.testCommand));
    }

    @Test
    void randomStrategy() {
        String firstResult = UnresolvedRoutingKeyPolicy.RANDOM_KEY.getRoutingKey(this.testCommand);
        String secondResult = UnresolvedRoutingKeyPolicy.RANDOM_KEY.getRoutingKey(this.testCommand);
        Assertions.assertNotEquals((Object)firstResult, (Object)secondResult);
    }

    @Test
    void staticStrategy() {
        String firstResult = UnresolvedRoutingKeyPolicy.STATIC_KEY.getRoutingKey(this.testCommand);
        String secondResult = UnresolvedRoutingKeyPolicy.STATIC_KEY.getRoutingKey(this.testCommand);
        Assertions.assertEquals((Object)firstResult, (Object)secondResult);
    }
}

