/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.Random;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BuilderUtilsTest {
    private static final int NUMBER_OF_RANDOM_NUMBERS = 256;

    BuilderUtilsTest() {
    }

    private static void testAssertFails(Runnable r, String failureMsg) {
        try {
            r.run();
            Assertions.fail((String)failureMsg);
        }
        catch (AxonConfigurationException axonConfigurationException) {
            // empty catch block
        }
    }

    @Test
    void assertThatTest() {
        BuilderUtils.assertThat((Object)0, n -> n == 0, (String)"Zero must be zero");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertThat((Object)0, n -> n != 0, (String)"Zero must be zero"), "BuilderUtils.assertThat() should have failed!");
    }

    @Test
    void assertNonNullTest() {
        BuilderUtils.assertNonNull((Object)this, (String)"This is not null");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertNonNull(null, (String)"Null should be null"), "BuilderUtils.assertNonNull() should have failed on value null.");
    }

    @Test
    void assertPositiveInteger() {
        BuilderUtils.assertPositive((int)0, (String)"Zero is positive");
        BuilderUtils.assertPositive((int)1, (String)"One is also positive");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertPositive((int)-1, (String)"Minus one is not positive"), "BuilderUtils.assertPositive() should have failed on value -1.");
        Random random = new Random();
        for (int i = 0; i < 256; ++i) {
            int value = random.nextInt();
            if (value >= 0) {
                BuilderUtils.assertPositive((int)value, (String)("Value " + value + " is positive."));
                continue;
            }
            BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertPositive((int)value, (String)"fail"), "Value " + value + " is negative.");
        }
    }

    @Test
    void assertPositiveLong() {
        BuilderUtils.assertPositive((long)0L, (String)"Zero is positive");
        BuilderUtils.assertPositive((long)1L, (String)"One is also positive");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertPositive((long)-1L, (String)"Minus one is not positive"), "BuilderUtils.assertPositive() should have failed on value -1.");
        Random random = new Random();
        for (int i = 0; i < 256; ++i) {
            long value = random.nextLong();
            if (value >= 0L) {
                BuilderUtils.assertPositive((long)value, (String)("Value " + value + " is positive."));
                continue;
            }
            BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertPositive((long)value, (String)"fail"), "Value " + value + " is negative.");
        }
    }

    @Test
    void assertStrictPositiveInteger() {
        BuilderUtils.assertStrictPositive((int)1, (String)"One is positive");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertStrictPositive((int)0, (String)"Zero is not strict positive"), "BuilderUtils.assertPositive() should have failed on value -1.");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertStrictPositive((int)-1, (String)"Minus one is not positive"), "BuilderUtils.assertPositive() should have failed on value -1.");
        Random random = new Random();
        for (int i = 0; i < 256; ++i) {
            int value = random.nextInt();
            if (value > 0) {
                BuilderUtils.assertStrictPositive((int)value, (String)("Value " + value + " is positive."));
                continue;
            }
            BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertStrictPositive((int)value, (String)"fail"), "Value " + value + " is negative.");
        }
    }

    @Test
    void assertStrictPositiveLong() {
        BuilderUtils.assertStrictPositive((long)1L, (String)"One is also positive");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertStrictPositive((long)0L, (String)"Zero is not strict positive"), "BuilderUtils.assertPositive() should have failed on value -1.");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertStrictPositive((long)-1L, (String)"Minus one is not positive"), "BuilderUtils.assertPositive() should have failed on value -1.");
        Random random = new Random();
        for (int i = 0; i < 256; ++i) {
            long value = random.nextLong();
            if (value > 0L) {
                BuilderUtils.assertStrictPositive((long)value, (String)("Value " + value + " is positive."));
                continue;
            }
            BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertStrictPositive((long)value, (String)"fail"), "Value " + value + " is negative.");
        }
    }

    @Test
    void assertNonEmptyTest() {
        BuilderUtils.assertNonEmpty((String)"some-text", (String)"Reacts fine on some text");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertNonEmpty(null, (String)"Should fail on null"), "BuilderUtils.assertNonEmpty() should have failed on value null.");
        BuilderUtilsTest.testAssertFails(() -> BuilderUtils.assertNonEmpty((String)"", (String)"Should fail on an empty string"), "BuilderUtils.assertNonEmpty() should have failed on an empty string.");
    }
}

