/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.common.ObjectUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ObjectUtilsTest {
    private static final String NULL_INSTANCE = null;
    private static final String INSTANCE = "instance";
    private static final String DEFAULT_VALUE = "default";

    ObjectUtilsTest() {
    }

    @Test
    void getOrDefaultUsingValueProvider() {
        Function<String, String> valueProvider = o -> o;
        Assertions.assertEquals((Object)DEFAULT_VALUE, (Object)ObjectUtils.getOrDefault((Object)NULL_INSTANCE, valueProvider, (Object)DEFAULT_VALUE));
        Assertions.assertEquals((Object)INSTANCE, (Object)ObjectUtils.getOrDefault((Object)INSTANCE, valueProvider, (Object)DEFAULT_VALUE));
    }

    @Test
    void supplySameInstance() {
        Supplier testSubject = ObjectUtils.sameInstanceSupplier(Object::new);
        Assertions.assertSame(testSubject.get(), testSubject.get());
    }
}

