/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.PriorityAnnotationComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PriorityAnnotationComparatorTest {
    private PriorityAnnotationComparator<Object> testSubject;

    PriorityAnnotationComparatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = PriorityAnnotationComparator.getInstance();
    }

    @Test
    void compareDifferentPriorities() {
        Assertions.assertTrue((this.testSubject.compare((Object)new LowPrio(), (Object)new HighPrio()) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new LowPrio(), (Object)new NeutralPrio()) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new NeutralPrio(), (Object)new HighPrio()) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new HighPrio(), (Object)new LowPrio()) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new NeutralPrio(), (Object)new LowPrio()) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new HighPrio(), (Object)new NeutralPrio()) < 0 ? 1 : 0) != 0);
    }

    @Test
    void compareSamePriorities() {
        Assertions.assertEquals((int)0, (int)this.testSubject.compare((Object)new LowPrio(), (Object)new LowPrio()));
        Assertions.assertEquals((int)0, (int)this.testSubject.compare((Object)new NeutralPrio(), (Object)new NeutralPrio()));
        Assertions.assertEquals((int)0, (int)this.testSubject.compare((Object)new HighPrio(), (Object)new HighPrio()));
    }

    @Test
    void undefinedConsideredNeutralPriority() {
        Assertions.assertTrue((this.testSubject.compare((Object)new UndefinedPrio(), (Object)new HighPrio()) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new UndefinedPrio(), (Object)new LowPrio()) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new UndefinedPrio(), (Object)new NeutralPrio()) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new HighPrio(), (Object)new UndefinedPrio()) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new LowPrio(), (Object)new UndefinedPrio()) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.testSubject.compare((Object)new NeutralPrio(), (Object)new UndefinedPrio()) == 0 ? 1 : 0) != 0);
    }

    @Test
    void sortComparisonResultsInCorrectSortOrder() {
        HighPrio highPrio = new HighPrio();
        LowPrio lowPrio = new LowPrio();
        List<Object> result = Arrays.asList(new NeutralPrio(), new UndefinedPrio(), highPrio, lowPrio);
        for (int i = 0; i < 100; ++i) {
            Collections.shuffle(result);
            result.sort((Comparator<Object>)this.testSubject);
            Assertions.assertEquals((Object)highPrio, (Object)result.get(0));
            Assertions.assertEquals((Object)lowPrio, (Object)result.get(3));
        }
    }

    private static class UndefinedPrio {
        private UndefinedPrio() {
        }
    }

    @Priority(value=0)
    private static class NeutralPrio {
        private NeutralPrio() {
        }
    }

    @Priority(value=0x7FFFFFFF)
    private static class HighPrio {
        private HighPrio() {
        }
    }

    @Priority(value=-2147483648)
    private static class LowPrio {
        private LowPrio() {
        }
    }
}

