/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.caching;

import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.axonframework.common.caching.EhCacheAdapter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class EhCacheAdapterTest {
    private EhCacheAdapter testSubject;
    private CacheManager cacheManager;

    EhCacheAdapterTest() {
    }

    @BeforeEach
    void setUp() {
        Cache cache = new Cache("test", 100, false, false, 10L, 10L);
        this.cacheManager = CacheManager.create();
        this.cacheManager.addCache(cache);
        this.testSubject = new EhCacheAdapter((Ehcache)cache);
    }

    @AfterEach
    void tearDown() {
        this.cacheManager.shutdown();
    }

    @Test
    void removeAllRemovesAllEntries() {
        this.testSubject.put((Object)"one", new Object());
        this.testSubject.put((Object)"two", new Object());
        this.testSubject.put((Object)"three", new Object());
        this.testSubject.put((Object)"four", new Object());
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"one"));
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"two"));
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"three"));
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"four"));
        this.testSubject.removeAll();
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"one"));
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"two"));
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"three"));
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"four"));
    }

    @Test
    void computeIfPresentDoesNotUpdateNonExistingEntry() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.testSubject.computeIfPresent((Object)"some-key", v -> {
            invoked.set(true);
            return v;
        });
        Assertions.assertFalse((boolean)invoked.get());
    }

    @Test
    void computeIfPresentUpdatesExistingEntry() {
        String testKey = "some-key";
        this.testSubject.put((Object)testKey, new Object());
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.testSubject.computeIfPresent((Object)testKey, v -> {
            invoked.set(true);
            return v;
        });
        Assertions.assertTrue((boolean)invoked.get());
    }
}

