/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.quartz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.deadline.quartz.DeadlineJob;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.JavaSerializer;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.TestSerializer;
import org.axonframework.serialization.json.JacksonSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.quartz.JobDataMap;

class DeadlineJobDataBinderTest {
    private static final String TEST_DEADLINE_NAME = "deadline-name";
    private static final String TEST_DEADLINE_PAYLOAD = "deadline-payload";
    private final DeadlineMessage<String> testDeadlineMessage;
    private final MetaData testMetaData;
    private final ScopeDescriptor testDeadlineScope;

    public DeadlineJobDataBinderTest() {
        DeadlineMessage testDeadlineMessage = GenericDeadlineMessage.asDeadlineMessage((String)TEST_DEADLINE_NAME, (Object)TEST_DEADLINE_PAYLOAD, (Instant)Instant.now());
        this.testMetaData = MetaData.with((String)"some-key", (Object)"some-value");
        this.testDeadlineMessage = testDeadlineMessage.withMetaData((Map)this.testMetaData);
        this.testDeadlineScope = new TestScopeDescriptor("aggregate-type", "aggregate-identifier");
    }

    public static Stream<Arguments> serializerImplementationAndAssertionSpecifics() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{Mockito.spy((Object)JavaSerializer.builder().build()), Class::getName, Objects::nonNull}), Arguments.arguments((Object[])new Object[]{Mockito.spy((Object)TestSerializer.XSTREAM.getSerializer()), clazz -> clazz.getSimpleName().toLowerCase(), Objects::isNull}), Arguments.arguments((Object[])new Object[]{Mockito.spy((Object)JacksonSerializer.builder().build()), Class::getName, Objects::isNull}));
    }

    @MethodSource(value={"serializerImplementationAndAssertionSpecifics"})
    @ParameterizedTest
    void toJobDataTest(Serializer serializer, Function<Class, String> expectedSerializedClassType, Predicate<Object> revisionMatcher) {
        JobDataMap result = DeadlineJob.DeadlineJobDataBinder.toJobData((Serializer)serializer, this.testDeadlineMessage, (ScopeDescriptor)this.testDeadlineScope);
        Assertions.assertEquals((Object)TEST_DEADLINE_NAME, (Object)result.get((Object)"axon-deadline-name"));
        Assertions.assertEquals((Object)this.testDeadlineMessage.getIdentifier(), (Object)result.get((Object)"axon-message-id"));
        Assertions.assertEquals((Object)this.testDeadlineMessage.getTimestamp().toString(), (Object)result.get((Object)"axon-message-timestamp"));
        String expectedPayloadType = expectedSerializedClassType.apply(this.testDeadlineMessage.getPayloadType());
        Assertions.assertEquals((Object)expectedPayloadType, (Object)result.get((Object)"axon-message-type"));
        Object resultRevision = result.get((Object)"axon-message-revision");
        Assertions.assertTrue((boolean)revisionMatcher.test(resultRevision));
        Assertions.assertNotNull((Object)result.get((Object)"axon-serialized-message-payload"));
        Assertions.assertNotNull((Object)result.get((Object)"axon-metadata"));
        Assertions.assertNotNull((Object)result.get((Object)"serializedDeadlineScope"));
        Assertions.assertEquals((Object)this.testDeadlineScope.getClass().getName(), (Object)result.get((Object)"serializedDeadlineScopeClassName"));
        ((Serializer)Mockito.verify((Object)serializer)).serialize((Object)TEST_DEADLINE_PAYLOAD, byte[].class);
        ((Serializer)Mockito.verify((Object)serializer)).serialize((Object)this.testMetaData, byte[].class);
        ((Serializer)Mockito.verify((Object)serializer)).serialize((Object)this.testDeadlineScope, byte[].class);
    }

    @MethodSource(value={"serializerImplementationAndAssertionSpecifics"})
    @ParameterizedTest
    void retrievingDeadlineMessage(Serializer serializer, Function<Class, String> expectedSerializedClassType, Predicate<Object> revisionMatcher) {
        JobDataMap testJobDataMap = DeadlineJob.DeadlineJobDataBinder.toJobData((Serializer)serializer, this.testDeadlineMessage, (ScopeDescriptor)this.testDeadlineScope);
        DeadlineMessage result = DeadlineJob.DeadlineJobDataBinder.deadlineMessage((Serializer)serializer, (JobDataMap)testJobDataMap);
        Assertions.assertEquals((Object)this.testDeadlineMessage.getDeadlineName(), (Object)result.getDeadlineName());
        Assertions.assertEquals((Object)this.testDeadlineMessage.getIdentifier(), (Object)result.getIdentifier());
        Assertions.assertEquals((Object)this.testDeadlineMessage.getTimestamp(), (Object)result.getTimestamp());
        Assertions.assertEquals((Object)this.testDeadlineMessage.getPayload(), (Object)result.getPayload());
        Assertions.assertEquals((Object)this.testDeadlineMessage.getPayloadType(), (Object)result.getPayloadType());
        Assertions.assertEquals((Object)this.testDeadlineMessage.getMetaData(), (Object)result.getMetaData());
        ((Serializer)Mockito.verify((Object)serializer, (VerificationMode)Mockito.times((int)2))).deserialize((SerializedObject)Mockito.argThat((ArgumentMatcher)new DeadlineMessageSerializedObjectMatcher(expectedSerializedClassType, revisionMatcher)));
    }

    @MethodSource(value={"serializerImplementationAndAssertionSpecifics"})
    @ParameterizedTest
    void retrievingDeadlineScope(Serializer serializer) {
        JobDataMap testJobDataMap = DeadlineJob.DeadlineJobDataBinder.toJobData((Serializer)serializer, this.testDeadlineMessage, (ScopeDescriptor)this.testDeadlineScope);
        ScopeDescriptor result = DeadlineJob.DeadlineJobDataBinder.deadlineScope((Serializer)serializer, (JobDataMap)testJobDataMap);
        Assertions.assertEquals((Object)this.testDeadlineScope, (Object)result);
        ((Serializer)Mockito.verify((Object)serializer)).deserialize((SerializedObject)((SimpleSerializedObject)Mockito.argThat(this::assertDeadlineScopeSerializedObject)));
    }

    private boolean assertDeadlineScopeSerializedObject(SimpleSerializedObject<?> serializedObject) {
        SerializedType type = serializedObject.getType();
        return serializedObject.getData() != null && serializedObject.getContentType().equals(byte[].class) && type.getName().equals(this.testDeadlineScope.getClass().getName()) && type.getRevision() == null;
    }

    private static class TestScopeDescriptor
    implements ScopeDescriptor {
        private static final long serialVersionUID = 3584695571254668002L;
        private final String type;
        private Object identifier;

        @JsonCreator
        public TestScopeDescriptor(@JsonProperty(value="type") String type, @JsonProperty(value="identifier") Object identifier) {
            this.type = type;
            this.identifier = identifier;
        }

        public String getType() {
            return this.type;
        }

        public Object getIdentifier() {
            return this.identifier;
        }

        public String scopeDescription() {
            return String.format("TestScopeDescriptor for type [%s] and identifier [%s]", this.type, this.identifier);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.identifier);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TestScopeDescriptor other = (TestScopeDescriptor)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.identifier, other.identifier);
        }

        public String toString() {
            return "TestScopeDescriptor{type=" + this.type + ", identifier='" + this.identifier + '\'' + '}';
        }
    }

    private static class DeadlineMessageSerializedObjectMatcher
    implements ArgumentMatcher<SimpleSerializedObject<?>> {
        private final Function<Class, String> expectedSerializedClassType;
        private final Predicate<Object> revisionMatcher;

        DeadlineMessageSerializedObjectMatcher(Function<Class, String> expectedSerializedClassType, Predicate<Object> revisionMatcher) {
            this.expectedSerializedClassType = expectedSerializedClassType;
            this.revisionMatcher = revisionMatcher;
        }

        public boolean matches(SimpleSerializedObject<?> serializedObject) {
            String expectedSerializedPayloadType = this.expectedSerializedClassType.apply(DeadlineJobDataBinderTest.TEST_DEADLINE_PAYLOAD.getClass());
            SerializedType type = serializedObject.getType();
            String serializedTypeName = type.getName();
            boolean isSerializedMetaData = serializedTypeName.equals(MetaData.class.getName());
            return !(serializedObject.getData() == null || !serializedObject.getContentType().equals(byte[].class) || !serializedTypeName.equals(expectedSerializedPayloadType) && !isSerializedMetaData || !isSerializedMetaData && !this.revisionMatcher.test(type.getRevision()));
        }
    }
}

