/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.time.Instant;
import org.axonframework.eventhandling.SequenceNumber;
import org.axonframework.eventhandling.SequenceNumberParameterResolverFactory;
import org.axonframework.eventhandling.Timestamp;
import org.axonframework.eventhandling.TimestampParameterResolverFactory;
import org.axonframework.messaging.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AnnotatedParameterResolverFactoryTest {
    AnnotatedParameterResolverFactoryTest() {
    }

    @Test
    void timestampParameterResolverIsReturnedOnlyWhenAppropriate() throws NoSuchMethodException {
        Method method = TestClass.class.getMethod("methodWithTimestampParameter", Instant.class, Long.class, Instant.class);
        AnnotatedParameterResolverFactoryTest.testMethod(new TimestampParameterResolverFactory(), method, new Class[]{TimestampParameterResolverFactory.TimestampParameterResolver.class, null, null});
    }

    @Test
    void sequenceNumberParameterResolverIsReturnedOnlyWhenAppropriate() throws NoSuchMethodException {
        Method method = TestClass.class.getMethod("methodWithSequenceNumberParameter", Long.class, Instant.class);
        AnnotatedParameterResolverFactoryTest.testMethod(new SequenceNumberParameterResolverFactory(), method, new Class[]{SequenceNumberParameterResolverFactory.SequenceNumberParameterResolver.class, null});
    }

    @Test
    void sequenceNumberParameterResolverHandlesPrimitive() throws NoSuchMethodException {
        Method method = TestClass.class.getMethod("methodWithPrimitiveParameter", Long.TYPE);
        AnnotatedParameterResolverFactoryTest.testMethod(new SequenceNumberParameterResolverFactory(), method, new Class[]{SequenceNumberParameterResolverFactory.SequenceNumberParameterResolver.class});
    }

    private static void testMethod(AbstractAnnotatedParameterResolverFactory<?, ?> factory, Method method, Class<?>[] expectedResolvers) {
        for (int param = 0; param < method.getParameterCount(); ++param) {
            ParameterResolver resolver = factory.createInstance((Executable)method, method.getParameters(), param);
            Assertions.assertEquals(expectedResolvers[param], resolver != null ? resolver.getClass() : null, (String)("Result incorrect for param: " + param));
        }
    }

    private static class TestClass {
        private TestClass() {
        }

        public void methodWithTimestampParameter(@Timestamp Instant timestamp, @Timestamp Long wrongType, Instant unannotated) {
        }

        public void methodWithSequenceNumberParameter(@SequenceNumber Long sequenceNumber, @Timestamp Instant different) {
        }

        public void methodWithPrimitiveParameter(@SequenceNumber long primitiveSequenceNumber) {
        }
    }
}

