/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Arrays;
import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.TrackingToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GapAwareTrackingTokenTest {
    GapAwareTrackingTokenTest() {
    }

    @Test
    void gapAwareTokenConcurrency() throws InterruptedException {
        AtomicLong counter = new AtomicLong();
        AtomicReference<GapAwareTrackingToken> currentToken = new AtomicReference<GapAwareTrackingToken>(GapAwareTrackingToken.newInstance((long)-1L, Collections.emptySortedSet()));
        ExecutorService executorService = Executors.newCachedThreadPool();
        int threadCount = Runtime.getRuntime().availableProcessors() + 1;
        for (int i = 0; i < threadCount; ++i) {
            executorService.submit(() -> {
                long deadline = System.currentTimeMillis() + 1000L;
                while (System.currentTimeMillis() < deadline) {
                    long next = counter.getAndIncrement();
                    currentToken.getAndUpdate(t -> t.advanceTo(next, Integer.MAX_VALUE));
                }
            });
        }
        executorService.shutdown();
        Assertions.assertTrue((boolean)executorService.awaitTermination(5L, TimeUnit.SECONDS), (String)"ExecutorService not stopped within expected reasonable time frame");
        Assertions.assertTrue((counter.get() > 0L ? 1 : 0) != 0, (String)"The test did not seem to have generated any tokens");
        Assertions.assertEquals((long)(counter.get() - 1L), (long)currentToken.get().getIndex());
        Assertions.assertEquals(Collections.emptySortedSet(), (Object)currentToken.get().getGaps());
    }

    @Test
    void initializationWithNullGaps() {
        GapAwareTrackingToken token = new GapAwareTrackingToken(10L, null);
        Assertions.assertNotNull((Object)token.getGaps());
        Assertions.assertEquals((int)0, (int)token.getGaps().size());
    }

    @Test
    void advanceToWithoutGaps() {
        GapAwareTrackingToken subject = GapAwareTrackingToken.newInstance((long)0L, Collections.emptyList());
        subject = subject.advanceTo(1L, 10);
        Assertions.assertEquals((long)1L, (long)subject.getIndex());
        Assertions.assertEquals(Collections.emptySortedSet(), (Object)subject.getGaps());
    }

    @Test
    void advanceToWithInitialGaps() {
        GapAwareTrackingToken subject = GapAwareTrackingToken.newInstance((long)10L, Arrays.asList(1L, 5L, 6L));
        subject = subject.advanceTo(5L, 10);
        Assertions.assertEquals((long)10L, (long)subject.getIndex());
        Assertions.assertEquals((Object)Stream.of(1L, 6L).collect(Collectors.toCollection(TreeSet::new)), (Object)subject.getGaps());
    }

    @Test
    void advanceToWithNewGaps() {
        GapAwareTrackingToken subject = GapAwareTrackingToken.newInstance((long)10L, Collections.emptyList());
        subject = subject.advanceTo(13L, 10);
        Assertions.assertEquals((long)13L, (long)subject.getIndex());
        Assertions.assertEquals((Object)Stream.of(11L, 12L).collect(Collectors.toCollection(TreeSet::new)), (Object)subject.getGaps());
    }

    @Test
    void advanceToGapClearsOldGaps() {
        GapAwareTrackingToken subject = GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(1L, 5L, 12L));
        subject = subject.advanceTo(12L, 10);
        Assertions.assertEquals((long)15L, (long)subject.getIndex());
        Assertions.assertEquals((Object)Stream.of(Long.valueOf(5L)).collect(Collectors.toCollection(TreeSet::new)), (Object)subject.getGaps());
    }

    @Test
    void advanceToHigherSequenceClearsOldGaps() {
        GapAwareTrackingToken subject = GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(1L, 5L, 12L));
        subject = subject.advanceTo(16L, 10);
        Assertions.assertEquals((long)16L, (long)subject.getIndex());
        Assertions.assertEquals((Object)Stream.of(Long.valueOf(12L)).collect(Collectors.toCollection(TreeSet::new)), (Object)subject.getGaps());
    }

    @Test
    void advanceToLowerSequenceThatIsNotAGapNotAllowed() {
        GapAwareTrackingToken subject = GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(1L, 5L, 12L));
        Assertions.assertThrows(Exception.class, () -> subject.advanceTo(4L, 10));
    }

    @Test
    void newInstanceWithGapHigherThanSequenceNotAllowed() {
        Assertions.assertThrows(Exception.class, () -> GapAwareTrackingToken.newInstance((long)9L, Arrays.asList(1L, 5L, 12L)));
    }

    @Test
    void tokenCoversOther() {
        GapAwareTrackingToken token1 = GapAwareTrackingToken.newInstance((long)3L, Collections.singleton(1L));
        GapAwareTrackingToken token2 = GapAwareTrackingToken.newInstance((long)4L, Collections.singleton(2L));
        GapAwareTrackingToken token3 = GapAwareTrackingToken.newInstance((long)2L, Arrays.asList(0L, 1L));
        GapAwareTrackingToken token4 = GapAwareTrackingToken.newInstance((long)3L, Collections.emptySortedSet());
        GapAwareTrackingToken token5 = GapAwareTrackingToken.newInstance((long)3L, Collections.singleton(2L));
        GapAwareTrackingToken token6 = GapAwareTrackingToken.newInstance((long)1L, Collections.emptySortedSet());
        GapAwareTrackingToken token7 = GapAwareTrackingToken.newInstance((long)2L, Collections.singleton(1L));
        Assertions.assertFalse((boolean)token1.covers((TrackingToken)token2));
        Assertions.assertFalse((boolean)token2.covers((TrackingToken)token1));
        Assertions.assertTrue((boolean)token1.covers((TrackingToken)token3));
        Assertions.assertFalse((boolean)token3.covers((TrackingToken)token1));
        Assertions.assertTrue((boolean)token4.covers((TrackingToken)token1));
        Assertions.assertFalse((boolean)token1.covers((TrackingToken)token4));
        Assertions.assertFalse((boolean)token2.covers((TrackingToken)token4));
        Assertions.assertFalse((boolean)token4.covers((TrackingToken)token2));
        Assertions.assertTrue((boolean)token4.covers((TrackingToken)token5));
        Assertions.assertFalse((boolean)token5.covers((TrackingToken)token4));
        Assertions.assertFalse((boolean)token1.covers((TrackingToken)token5));
        Assertions.assertFalse((boolean)token5.covers((TrackingToken)token1));
        Assertions.assertFalse((boolean)token1.covers((TrackingToken)token6));
        Assertions.assertFalse((boolean)token6.covers((TrackingToken)token1));
        Assertions.assertFalse((boolean)token3.covers((TrackingToken)token7));
    }

    @Test
    void occurrenceOfInconsistentRangeException() {
        GapAwareTrackingToken.newInstance((long)10L, Arrays.asList(0L, 1L, 2L, 8L, 9L)).advanceTo(0L, 5).covers((TrackingToken)GapAwareTrackingToken.newInstance((long)0L, Collections.emptySet()));
    }

    @Test
    void lowerBound() {
        GapAwareTrackingToken token1 = GapAwareTrackingToken.newInstance((long)3L, Collections.singleton(1L));
        GapAwareTrackingToken token2 = GapAwareTrackingToken.newInstance((long)4L, Collections.singleton(2L));
        GapAwareTrackingToken token3 = GapAwareTrackingToken.newInstance((long)2L, Arrays.asList(0L, 1L));
        GapAwareTrackingToken token4 = GapAwareTrackingToken.newInstance((long)3L, Collections.emptySortedSet());
        GapAwareTrackingToken token5 = GapAwareTrackingToken.newInstance((long)3L, Collections.singleton(2L));
        GapAwareTrackingToken token6 = GapAwareTrackingToken.newInstance((long)1L, Collections.emptySortedSet());
        Assertions.assertEquals((Object)token1.lowerBound((TrackingToken)token2), (Object)GapAwareTrackingToken.newInstance((long)3L, Arrays.asList(1L, 2L)));
        Assertions.assertEquals((Object)token1.lowerBound((TrackingToken)token3), (Object)token3);
        Assertions.assertEquals((Object)token1.lowerBound((TrackingToken)token4), (Object)token1);
        Assertions.assertEquals((Object)token1.lowerBound((TrackingToken)token5), (Object)GapAwareTrackingToken.newInstance((long)3L, Arrays.asList(1L, 2L)));
        Assertions.assertEquals((Object)token1.lowerBound((TrackingToken)token6), (Object)GapAwareTrackingToken.newInstance((long)0L, Collections.emptySortedSet()));
        Assertions.assertEquals((Object)token2.lowerBound((TrackingToken)token3), (Object)GapAwareTrackingToken.newInstance((long)-1L, Collections.emptySortedSet()));
    }

    @Test
    void upperBound() {
        GapAwareTrackingToken token0 = GapAwareTrackingToken.newInstance((long)9L, Collections.emptyList());
        GapAwareTrackingToken token1 = GapAwareTrackingToken.newInstance((long)10L, Collections.singleton(9L));
        GapAwareTrackingToken token2 = GapAwareTrackingToken.newInstance((long)10L, Arrays.asList(9L, 8L));
        GapAwareTrackingToken token3 = GapAwareTrackingToken.newInstance((long)15L, Collections.singletonList(14L));
        GapAwareTrackingToken token4 = GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(14L, 9L, 8L));
        GapAwareTrackingToken token5 = GapAwareTrackingToken.newInstance((long)14L, Collections.emptyList());
        Assertions.assertEquals((Object)GapAwareTrackingToken.newInstance((long)10L, Collections.emptyList()), (Object)token0.upperBound((TrackingToken)token1));
        Assertions.assertEquals((Object)token1, (Object)token1.upperBound((TrackingToken)token2));
        Assertions.assertEquals((Object)token3, (Object)token1.upperBound((TrackingToken)token3));
        Assertions.assertEquals((Object)GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(14L, 9L)), (Object)token1.upperBound((TrackingToken)token4));
        Assertions.assertEquals((Object)GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(14L, 9L, 8L)), (Object)token2.upperBound((TrackingToken)token4));
        Assertions.assertEquals((Object)GapAwareTrackingToken.newInstance((long)15L, Collections.emptyList()), (Object)token5.upperBound((TrackingToken)token3));
    }

    @Test
    void gapTruncationRetainsEquality() {
        GapAwareTrackingToken token1 = GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(14L, 9L, 8L));
        Assertions.assertEquals((Object)token1, (Object)token1.withGapsTruncatedAt(8L));
        Assertions.assertEquals((Object)token1.withGapsTruncatedAt(9L), (Object)token1);
        Assertions.assertEquals((Object)token1.withGapsTruncatedAt(9L), (Object)token1.withGapsTruncatedAt(8L));
        Assertions.assertEquals((Object)token1.withGapsTruncatedAt(16L), (Object)token1.withGapsTruncatedAt(16L));
    }

    @Test
    void truncateGaps() {
        GapAwareTrackingToken token1 = GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(14L, 9L, 8L));
        Assertions.assertSame((Object)token1, (Object)token1.withGapsTruncatedAt(7L));
        Assertions.assertEquals(this.asTreeSet(9L, 14L), (Object)token1.withGapsTruncatedAt(9L).getGaps());
        Assertions.assertEquals(this.asTreeSet(14L), (Object)token1.withGapsTruncatedAt(10L).getGaps());
        Assertions.assertEquals(Collections.emptySet(), (Object)token1.withGapsTruncatedAt(15L).getGaps());
    }

    @Test
    void gapTruncatedTokenCoveredByOriginal() {
        GapAwareTrackingToken token1 = GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(14L, 9L, 8L));
        Assertions.assertTrue((boolean)token1.covers((TrackingToken)token1.withGapsTruncatedAt(10L)));
        Assertions.assertTrue((boolean)token1.withGapsTruncatedAt(10L).covers((TrackingToken)token1));
    }

    @Test
    void position() {
        GapAwareTrackingToken token = GapAwareTrackingToken.newInstance((long)15L, Arrays.asList(14L, 9L, 8L));
        Assertions.assertEquals((long)15L, (long)token.position().getAsLong());
    }

    private TreeSet<Long> asTreeSet(Long ... elements) {
        return new TreeSet<Long>(Arrays.asList(elements));
    }
}

