/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericDomainEventMessageTest {
    GenericDomainEventMessageTest() {
    }

    @Test
    void constructor() {
        Object payload = new Object();
        long seqNo = 0L;
        String id = UUID.randomUUID().toString();
        GenericDomainEventMessage message1 = new GenericDomainEventMessage("type", id, seqNo, payload);
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        GenericDomainEventMessage message2 = new GenericDomainEventMessage("type", id, seqNo, payload, (Map)metaData);
        GenericDomainEventMessage message3 = new GenericDomainEventMessage("type", id, seqNo, payload, metaDataMap);
        Assertions.assertSame((Object)id, (Object)message1.getAggregateIdentifier());
        Assertions.assertEquals((long)seqNo, (long)message1.getSequenceNumber());
        Assertions.assertSame((Object)MetaData.emptyInstance(), (Object)message1.getMetaData());
        Assertions.assertEquals(Object.class, message1.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)message1.getPayloadType());
        Assertions.assertSame((Object)id, (Object)message2.getAggregateIdentifier());
        Assertions.assertEquals((long)seqNo, (long)message2.getSequenceNumber());
        Assertions.assertSame((Object)metaData, (Object)message2.getMetaData());
        Assertions.assertEquals(Object.class, message2.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)message2.getPayloadType());
        Assertions.assertSame((Object)id, (Object)message3.getAggregateIdentifier());
        Assertions.assertEquals((long)seqNo, (long)message3.getSequenceNumber());
        Assertions.assertNotSame(metaDataMap, (Object)message3.getMetaData());
        Assertions.assertEquals(metaDataMap, (Object)message3.getMetaData());
        Assertions.assertEquals(Object.class, message3.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)message3.getPayloadType());
        Assertions.assertNotEquals((Object)message1.getIdentifier(), (Object)message2.getIdentifier());
        Assertions.assertNotEquals((Object)message1.getIdentifier(), (Object)message3.getIdentifier());
        Assertions.assertNotEquals((Object)message2.getIdentifier(), (Object)message3.getIdentifier());
    }

    @Test
    void withMetaData() {
        Object payload = new Object();
        long seqNo = 0L;
        String id = UUID.randomUUID().toString();
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        GenericDomainEventMessage message = new GenericDomainEventMessage("type", id, seqNo, payload, (Map)metaData);
        GenericDomainEventMessage message1 = message.withMetaData((Map)MetaData.emptyInstance());
        GenericDomainEventMessage message2 = message.withMetaData((Map)MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)0, (int)message1.getMetaData().size());
        Assertions.assertEquals((int)1, (int)message2.getMetaData().size());
    }

    @Test
    void andMetaData() {
        Object payload = new Object();
        long seqNo = 0L;
        String id = UUID.randomUUID().toString();
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        GenericDomainEventMessage message = new GenericDomainEventMessage("type", id, seqNo, payload, (Map)metaData);
        GenericDomainEventMessage message1 = message.andMetaData((Map)MetaData.emptyInstance());
        GenericDomainEventMessage message2 = message.andMetaData((Map)MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)1, (int)message1.getMetaData().size());
        Assertions.assertEquals((Object)"value", (Object)message1.getMetaData().get((Object)"key"));
        Assertions.assertEquals((int)1, (int)message2.getMetaData().size());
        Assertions.assertEquals((Object)"otherValue", (Object)message2.getMetaData().get((Object)"key"));
    }

    @Test
    void testToString() {
        String actual = new GenericDomainEventMessage("AggregateType", "id1", 1L, (Object)"MyPayload").andMetaData((Map)MetaData.with((String)"key", (Object)"value").and("key2", (Object)13)).toString();
        Assertions.assertTrue((boolean)actual.startsWith("GenericDomainEventMessage{payload={MyPayload}, metadata={"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("'key'->'value'"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("'key2'->'13'"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("', timestamp='"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("', aggregateIdentifier='id1'"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("', aggregateType='AggregateType'"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("', sequenceNumber=1"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.endsWith("}"), (String)("Wrong output: " + actual));
    }
}

