/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericEventMessageTest {
    GenericEventMessageTest() {
    }

    @Test
    void constructor() {
        Object payload = new Object();
        GenericEventMessage message1 = new GenericEventMessage(payload);
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        GenericEventMessage message2 = new GenericEventMessage(payload, (Map)metaData);
        GenericEventMessage message3 = new GenericEventMessage(payload, metaDataMap);
        Assertions.assertSame((Object)MetaData.emptyInstance(), (Object)message1.getMetaData());
        Assertions.assertEquals(Object.class, message1.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)message1.getPayloadType());
        Assertions.assertEquals((Object)metaData, (Object)message2.getMetaData());
        Assertions.assertEquals(Object.class, message2.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)message2.getPayloadType());
        Assertions.assertNotSame(metaDataMap, (Object)message3.getMetaData());
        Assertions.assertEquals(metaDataMap, (Object)message3.getMetaData());
        Assertions.assertEquals(Object.class, message3.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)message3.getPayloadType());
        Assertions.assertFalse((boolean)message1.getIdentifier().equals(message2.getIdentifier()));
        Assertions.assertFalse((boolean)message1.getIdentifier().equals(message3.getIdentifier()));
        Assertions.assertFalse((boolean)message2.getIdentifier().equals(message3.getIdentifier()));
    }

    @Test
    void withMetaData() {
        Object payload = new Object();
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        GenericEventMessage message = new GenericEventMessage(payload, (Map)metaData);
        GenericEventMessage message1 = message.withMetaData((Map)MetaData.emptyInstance());
        GenericEventMessage message2 = message.withMetaData((Map)MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)0, (int)message1.getMetaData().size());
        Assertions.assertEquals((int)1, (int)message2.getMetaData().size());
    }

    @Test
    void andMetaData() {
        Object payload = new Object();
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        GenericEventMessage message = new GenericEventMessage(payload, (Map)metaData);
        GenericEventMessage message1 = message.andMetaData((Map)MetaData.emptyInstance());
        GenericEventMessage message2 = message.andMetaData((Map)MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)1, (int)message1.getMetaData().size());
        Assertions.assertEquals((Object)"value", (Object)message1.getMetaData().get((Object)"key"));
        Assertions.assertEquals((int)1, (int)message2.getMetaData().size());
        Assertions.assertEquals((Object)"otherValue", (Object)message2.getMetaData().get((Object)"key"));
    }

    @Test
    void timestampInEventMessageIsAlwaysSerialized() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        GenericEventMessage testSubject = new GenericEventMessage((Message)new GenericMessage((Object)"payload", Collections.singletonMap("key", "value")), Instant::now);
        oos.writeObject(testSubject);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        Object read = ois.readObject();
        Assertions.assertEquals(GenericEventMessage.class, read.getClass());
        Assertions.assertNotNull((Object)((GenericEventMessage)read).getTimestamp());
    }

    @Test
    void testToString() {
        String actual = GenericEventMessage.asEventMessage((Object)"MyPayload").andMetaData((Map)MetaData.with((String)"key", (Object)"value").and("key2", (Object)13)).toString();
        Assertions.assertTrue((boolean)actual.startsWith("GenericEventMessage{payload={MyPayload}, metadata={"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("'key'->'value'"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("'key2'->'13'"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("', timestamp='"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.endsWith("}"), (String)("Wrong output: " + actual));
    }
}

