/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.Segment;
import org.axonframework.messaging.MetaData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentTest.class);
    private List<DomainEventMessage> domainEventMessages;

    SegmentTest() {
    }

    @BeforeEach
    void before() {
        this.domainEventMessages = this.produceEvents();
    }

    @Test
    void segmentSplitAddsUp() {
        List identifiers = this.domainEventMessages.stream().map(de -> {
            String aggregateIdentifier = de.getAggregateIdentifier();
            return UUID.fromString(aggregateIdentifier).getLeastSignificantBits();
        }).collect(Collectors.toList());
        long count = identifiers.stream().filter(arg_0 -> ((Segment)Segment.ROOT_SEGMENT).matches(arg_0)).count();
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)identifiers.size()));
        Segment[] splitSegment = Segment.ROOT_SEGMENT.split();
        long splitCount1 = identifiers.stream().filter(arg_0 -> ((Segment)splitSegment[0]).matches(arg_0)).count();
        long splitCount2 = identifiers.stream().filter(arg_0 -> ((Segment)splitSegment[1]).matches(arg_0)).count();
        MatcherAssert.assertThat((Object)(splitCount1 + splitCount2), (Matcher)CoreMatchers.is((Object)identifiers.size()));
    }

    @Test
    void segmentSplit() {
        Segment[] splitSegment0 = Segment.ROOT_SEGMENT.split();
        MatcherAssert.assertThat((Object)Segment.ROOT_SEGMENT.splitSegmentId(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)splitSegment0[0].getSegmentId(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)splitSegment0[0].getMask(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)splitSegment0[1].getSegmentId(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)splitSegment0[1].getMask(), (Matcher)CoreMatchers.is((Object)1));
        Segment[] splitSegment0_1 = splitSegment0[0].split();
        MatcherAssert.assertThat((Object)splitSegment0[0].splitSegmentId(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)splitSegment0_1[0].getSegmentId(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)splitSegment0_1[0].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)splitSegment0_1[1].getSegmentId(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)splitSegment0_1[1].getMask(), (Matcher)CoreMatchers.is((Object)3));
        Segment[] splitSegment0_2 = splitSegment0_1[0].split();
        MatcherAssert.assertThat((Object)splitSegment0_1[0].splitSegmentId(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)splitSegment0_2[0].getSegmentId(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)splitSegment0_2[0].getMask(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)splitSegment0_2[1].getSegmentId(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)splitSegment0_2[1].getMask(), (Matcher)CoreMatchers.is((Object)7));
        Segment[] splitSegment0_3 = splitSegment0_2[0].split();
        MatcherAssert.assertThat((Object)splitSegment0_2[0].splitSegmentId(), (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)splitSegment0_3[0].getSegmentId(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)splitSegment0_3[0].getMask(), (Matcher)CoreMatchers.is((Object)15));
        MatcherAssert.assertThat((Object)splitSegment0_3[1].getSegmentId(), (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)splitSegment0_3[1].getMask(), (Matcher)CoreMatchers.is((Object)15));
        Segment[] splitSegment1 = splitSegment0[1].split();
        MatcherAssert.assertThat((Object)splitSegment0[1].splitSegmentId(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)splitSegment1[0].getSegmentId(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)splitSegment1[0].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)splitSegment1[1].getSegmentId(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)splitSegment1[1].getMask(), (Matcher)CoreMatchers.is((Object)3));
        Segment[] splitSegment3 = splitSegment1[1].split();
        MatcherAssert.assertThat((Object)splitSegment1[1].splitSegmentId(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)splitSegment3[0].getSegmentId(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)splitSegment3[0].getMask(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)splitSegment3[1].getSegmentId(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)splitSegment3[1].getMask(), (Matcher)CoreMatchers.is((Object)7));
    }

    @Test
    void segmentSplitNTimes() {
        List segmentMasks = Segment.splitBalanced((Segment)Segment.ROOT_SEGMENT, (int)5);
        MatcherAssert.assertThat((Object)segmentMasks.size(), (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat(segmentMasks.get(5), (Matcher)CoreMatchers.equalTo((Object)new Segment(5, 7)));
        MatcherAssert.assertThat(segmentMasks.get(0), (Matcher)CoreMatchers.equalTo((Object)new Segment(0, 7)));
        MatcherAssert.assertThat(segmentMasks.get(1), (Matcher)CoreMatchers.equalTo((Object)new Segment(1, 7)));
        MatcherAssert.assertThat(segmentMasks.get(2), (Matcher)CoreMatchers.equalTo((Object)new Segment(2, 3)));
        MatcherAssert.assertThat(segmentMasks.get(3), (Matcher)CoreMatchers.equalTo((Object)new Segment(3, 3)));
        MatcherAssert.assertThat(segmentMasks.get(4), (Matcher)CoreMatchers.equalTo((Object)new Segment(4, 7)));
    }

    @Test
    void splitFromRootSegmentAlwaysYieldsSequentialSegmentIds() {
        for (int i = 0; i < 500; ++i) {
            List segments = Segment.splitBalanced((Segment)Segment.ROOT_SEGMENT, (int)i);
            Assertions.assertEquals((int)(i + 1), (int)segments.size());
            for (int j = 0; j < i; ++j) {
                Assertions.assertEquals((int)j, (int)((Segment)segments.get(j)).getSegmentId());
            }
        }
    }

    @Test
    void mergeable() {
        Segment[] segments = Segment.ROOT_SEGMENT.split();
        Assertions.assertFalse((boolean)segments[0].isMergeableWith(segments[0]));
        Assertions.assertFalse((boolean)segments[1].isMergeableWith(segments[1]));
        Assertions.assertTrue((boolean)segments[0].isMergeableWith(segments[1]));
        Assertions.assertTrue((boolean)segments[1].isMergeableWith(segments[0]));
        Segment[] segments2 = segments[0].split();
        Assertions.assertFalse((boolean)segments[0].isMergeableWith(segments2[0]));
        Assertions.assertFalse((boolean)segments[0].isMergeableWith(segments2[1]));
        Assertions.assertFalse((boolean)segments[1].isMergeableWith(segments2[0]));
        Assertions.assertTrue((boolean)segments2[0].isMergeableWith(segments2[1]));
    }

    @Test
    void mergeableSegment() {
        Segment[] segments = Segment.ROOT_SEGMENT.split();
        Assertions.assertEquals((int)segments[1].getSegmentId(), (int)segments[0].mergeableSegmentId());
        Assertions.assertEquals((int)segments[0].getSegmentId(), (int)segments[1].mergeableSegmentId());
        Assertions.assertEquals((int)0, (int)Segment.ROOT_SEGMENT.mergeableSegmentId());
    }

    @Test
    void mergeSegments() {
        Segment[] segments = Segment.ROOT_SEGMENT.split();
        Segment[] segments2 = segments[0].split();
        Assertions.assertEquals((Object)segments[0], (Object)segments2[0].mergedWith(segments2[1]));
        Assertions.assertEquals((Object)segments[0], (Object)segments2[1].mergedWith(segments2[0]));
        Assertions.assertEquals((Object)Segment.ROOT_SEGMENT, (Object)segments[1].mergedWith(segments[0]));
        Assertions.assertEquals((Object)Segment.ROOT_SEGMENT, (Object)Segment.ROOT_SEGMENT.mergedWith(Segment.ROOT_SEGMENT));
    }

    @Test
    void segmentResolve() {
        int[] segments = new int[]{};
        Segment[] segmentMasks = Segment.computeSegments((int[])segments);
        MatcherAssert.assertThat((Object)segmentMasks.length, (Matcher)CoreMatchers.is((Object)0));
        segments = new int[]{0};
        segmentMasks = Segment.computeSegments((int[])segments);
        MatcherAssert.assertThat((Object)segmentMasks.length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)segmentMasks[0].getMask(), (Matcher)CoreMatchers.is((Object)Segment.ROOT_SEGMENT.getMask()));
        segments = new int[]{0, 1};
        segmentMasks = Segment.computeSegments((int[])segments);
        MatcherAssert.assertThat((Object)segmentMasks.length, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)segmentMasks[0].getMask(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)segmentMasks[1].getMask(), (Matcher)CoreMatchers.is((Object)1));
        segments = new int[]{0, 1, 2};
        segmentMasks = Segment.computeSegments((int[])segments);
        MatcherAssert.assertThat((Object)segmentMasks.length, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[0].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[1].getMask(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)segmentMasks[2].getMask(), (Matcher)CoreMatchers.is((Object)3));
        segments = new int[]{0, 1, 3};
        segmentMasks = Segment.computeSegments((int[])segments);
        MatcherAssert.assertThat((Object)segmentMasks.length, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[0].getMask(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)segmentMasks[1].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[2].getMask(), (Matcher)CoreMatchers.is((Object)3));
        segments = new int[]{0, 1, 2, 3};
        segmentMasks = Segment.computeSegments((int[])segments);
        MatcherAssert.assertThat((Object)segmentMasks.length, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)segmentMasks[0].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[1].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[2].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[3].getMask(), (Matcher)CoreMatchers.is((Object)3));
        segments = new int[]{0, 1, 3, 7};
        segmentMasks = Segment.computeSegments((int[])segments);
        MatcherAssert.assertThat((Object)segmentMasks.length, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)segmentMasks[0].getMask(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)segmentMasks[1].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[2].getMask(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)segmentMasks[3].getMask(), (Matcher)CoreMatchers.is((Object)7));
        segments = new int[]{0, 1, 2, 3, 7};
        segmentMasks = Segment.computeSegments((int[])segments);
        MatcherAssert.assertThat((Object)segmentMasks.length, (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)segmentMasks[0].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[1].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[2].getMask(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)segmentMasks[3].getMask(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)segmentMasks[4].getMask(), (Matcher)CoreMatchers.is((Object)7));
        segments = new int[]{0, 1, 2, 3, 4, 5};
        segmentMasks = Segment.computeSegments((int[])segments);
        MatcherAssert.assertThat((Object)segmentMasks.length, (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat((Object)segmentMasks[0], (Matcher)CoreMatchers.equalTo((Object)new Segment(0, 7)));
        MatcherAssert.assertThat((Object)segmentMasks[1], (Matcher)CoreMatchers.equalTo((Object)new Segment(1, 7)));
        MatcherAssert.assertThat((Object)segmentMasks[2], (Matcher)CoreMatchers.equalTo((Object)new Segment(2, 3)));
        MatcherAssert.assertThat((Object)segmentMasks[3], (Matcher)CoreMatchers.equalTo((Object)new Segment(3, 3)));
        MatcherAssert.assertThat((Object)segmentMasks[4], (Matcher)CoreMatchers.equalTo((Object)new Segment(4, 7)));
        MatcherAssert.assertThat((Object)segmentMasks[5], (Matcher)CoreMatchers.equalTo((Object)new Segment(5, 7)));
    }

    @Test
    void computeSegment() {
        for (int segmentCount = 0; segmentCount < 256; ++segmentCount) {
            List segments = Segment.splitBalanced((Segment)Segment.ROOT_SEGMENT, (int)segmentCount);
            int[] segmentIds = new int[segments.size()];
            for (int i = 0; i < segmentIds.length; ++i) {
                segmentIds[i] = ((Segment)segments.get(i)).getSegmentId();
            }
            for (Segment segment : segments) {
                Assertions.assertEquals((Object)segment, (Object)Segment.computeSegment((int)segment.getSegmentId(), (int[])segmentIds), (String)("Got wrong segment for " + segmentCount + " number of segments"));
            }
        }
    }

    @Test
    void computeSegment_Imbalanced() {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        Segment initialSegment = Segment.ROOT_SEGMENT;
        for (int i = 0; i < 8; ++i) {
            Segment[] split = initialSegment.split();
            initialSegment = split[0];
            segments.add(split[1]);
        }
        segments.add(initialSegment);
        int[] segmentIds = new int[segments.size()];
        for (int i = 0; i < segmentIds.length; ++i) {
            segmentIds[i] = ((Segment)segments.get(i)).getSegmentId();
        }
        for (Segment segment : segments) {
            Assertions.assertEquals((Object)segment, (Object)Segment.computeSegment((int)segment.getSegmentId(), (int[])segmentIds));
        }
    }

    @Test
    void segmentSplitBeyondBoundary() {
        Segment segment = new Segment(0, Integer.MAX_VALUE);
        Assertions.assertThrows(IllegalStateException.class, () -> ((Segment)segment).split());
    }

    @Test
    void segmentSplitOnBoundary() {
        Segment segment = new Segment(0, 0x3FFFFFFF);
        Segment[] splitSegment = segment.split();
        MatcherAssert.assertThat((Object)splitSegment[0].getSegmentId(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)splitSegment[0].getMask(), (Matcher)CoreMatchers.is((Object)Integer.MAX_VALUE));
        MatcherAssert.assertThat((Object)splitSegment[1].getSegmentId(), (Matcher)CoreMatchers.is((Object)0x40000000));
        MatcherAssert.assertThat((Object)splitSegment[1].getMask(), (Matcher)CoreMatchers.is((Object)Integer.MAX_VALUE));
    }

    @Test
    void itemsAssignedToOnlyOneSegment() {
        for (int j = 0; j < 10; ++j) {
            List segments = Segment.splitBalanced((Segment)Segment.ROOT_SEGMENT, (int)(ThreadLocalRandom.current().nextInt(50) + 1));
            for (int i = 0; i < 100000; ++i) {
                String value = UUID.randomUUID().toString();
                Assertions.assertEquals((long)1L, (long)segments.stream().filter(s -> s.matches((Object)value)).count());
            }
        }
    }

    private List<DomainEventMessage> produceEvents() {
        ArrayList<DomainEventMessage> events = new ArrayList<DomainEventMessage>();
        for (int i = 0; i < 10000; ++i) {
            String aggregateIdentifier = UUID.randomUUID().toString();
            DomainEventMessage domainEventMessage = this.newStubDomainEvent(aggregateIdentifier);
            events.add(domainEventMessage);
        }
        return events;
    }

    private DomainEventMessage newStubDomainEvent(String aggregateIdentifier) {
        return new GenericDomainEventMessage("type", aggregateIdentifier, 0L, new Object(), (Map)MetaData.emptyInstance());
    }
}

