/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Collections;
import java.util.List;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.SimpleEventHandlerInvoker;
import org.axonframework.utils.EventTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

class SimpleEventHandlerInvokerTest {
    private static final Object NO_RESET_PAYLOAD = null;
    private EventMessageHandler mockHandler1;
    private EventMessageHandler mockHandler2;
    private SimpleEventHandlerInvoker testSubject;

    SimpleEventHandlerInvokerTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockHandler1 = (EventMessageHandler)Mockito.mock(EventMessageHandler.class);
        this.mockHandler2 = (EventMessageHandler)Mockito.mock(EventMessageHandler.class);
        this.testSubject = SimpleEventHandlerInvoker.builder().eventHandlers(new Object[]{"test", this.mockHandler1, this.mockHandler2}).build();
    }

    @Test
    void singleEventPublication() throws Exception {
        DomainEventMessage<String> event = EventTestUtils.createEvent();
        this.testSubject.handle(event, Segment.ROOT_SEGMENT);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockHandler1, this.mockHandler2});
        ((EventMessageHandler)inOrder.verify((Object)this.mockHandler1)).handle(event);
        ((EventMessageHandler)inOrder.verify((Object)this.mockHandler2)).handle(event);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void repeatedEventPublication() throws Exception {
        List<DomainEventMessage<?>> events = EventTestUtils.createEvents(2);
        for (EventMessage eventMessage : events) {
            this.testSubject.handle(eventMessage, Segment.ROOT_SEGMENT);
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockHandler1, this.mockHandler2});
        ((EventMessageHandler)inOrder.verify((Object)this.mockHandler1)).handle((EventMessage)events.get(0));
        ((EventMessageHandler)inOrder.verify((Object)this.mockHandler2)).handle((EventMessage)events.get(0));
        ((EventMessageHandler)inOrder.verify((Object)this.mockHandler1)).handle((EventMessage)events.get(1));
        ((EventMessageHandler)inOrder.verify((Object)this.mockHandler2)).handle((EventMessage)events.get(1));
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void performReset() {
        this.testSubject.performReset();
        ((EventMessageHandler)Mockito.verify((Object)this.mockHandler1)).prepareReset(NO_RESET_PAYLOAD);
        ((EventMessageHandler)Mockito.verify((Object)this.mockHandler2)).prepareReset(NO_RESET_PAYLOAD);
    }

    @Test
    void performResetWithResetContext() {
        String resetContext = "reset-context";
        this.testSubject.performReset((Object)resetContext);
        ((EventMessageHandler)Mockito.verify((Object)this.mockHandler1)).prepareReset(Mockito.eq((Object)resetContext));
        ((EventMessageHandler)Mockito.verify((Object)this.mockHandler2)).prepareReset(Mockito.eq((Object)resetContext));
    }

    @Test
    void buildWithNullEventHandlersListThrowsAxonConfigurationException() {
        SimpleEventHandlerInvoker.Builder builderTestSubject = SimpleEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.eventHandlers((List)null));
    }

    @Test
    void buildWithEmptyEventHandlersListThrowsAxonConfigurationException() {
        SimpleEventHandlerInvoker.Builder builderTestSubject = SimpleEventHandlerInvoker.builder();
        List testEventHandlers = Collections.emptyList();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.eventHandlers(testEventHandlers));
    }

    @Test
    void buildWithoutEventHandlersListThrowsAxonConfigurationException() {
        SimpleEventHandlerInvoker.Builder builderTestSubject = SimpleEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((SimpleEventHandlerInvoker.Builder)builderTestSubject).build());
    }

    @Test
    void buildWithNullParameterResolverFactoryThrowsAxonConfigurationException() {
        SimpleEventHandlerInvoker.Builder builderTestSubject = SimpleEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.parameterResolverFactory(null));
    }

    @Test
    void buildWithNullHandlerDefinitionThrowsAxonConfigurationException() {
        SimpleEventHandlerInvoker.Builder builderTestSubject = SimpleEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.handlerDefinition(null));
    }

    @Test
    void buildWithNullListenerInvocationErrorHandlerThrowsAxonConfigurationException() {
        SimpleEventHandlerInvoker.Builder builderTestSubject = SimpleEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.listenerInvocationErrorHandler(null));
    }

    @Test
    void buildWithNullSequencingPolicyThrowsAxonConfigurationException() {
        SimpleEventHandlerInvoker.Builder builderTestSubject = SimpleEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.sequencingPolicy(null));
    }
}

