/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.quartz;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.SchedulingException;
import org.axonframework.eventhandling.scheduling.quartz.QuartzEventScheduler;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.serialization.TestSerializer;
import org.axonframework.utils.AssertUtils;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

class QuartzEventSchedulerTest {
    private static final String GROUP_ID = "TestGroup";
    private Scheduler scheduler;
    private EventBus eventBus;
    private QuartzEventScheduler testSubject;

    QuartzEventSchedulerTest() {
    }

    @BeforeEach
    void setUp() throws SchedulerException {
        this.eventBus = (EventBus)Mockito.mock(EventBus.class);
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        this.scheduler = (Scheduler)Mockito.spy((Object)schedulerFactory.getScheduler());
        this.scheduler.getContext().put(EventBus.class.getName(), (Object)this.eventBus);
        this.scheduler.start();
        this.testSubject = QuartzEventScheduler.builder().scheduler(this.scheduler).eventBus(this.eventBus).serializer(TestSerializer.XSTREAM.getSerializer()).build();
        this.testSubject.setGroupIdentifier(GROUP_ID);
    }

    @AfterEach
    void tearDown() throws SchedulerException {
        if (this.scheduler != null) {
            this.scheduler.shutdown(true);
        }
    }

    @Test
    void scheduleJob() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ((EventBus)Mockito.doAnswer(invocation -> {
            latch.countDown();
            return null;
        }).when((Object)this.eventBus)).publish(new EventMessage[]{(EventMessage)Mockito.isA(EventMessage.class)});
        ScheduleToken token = this.testSubject.schedule(Duration.ofMillis(30L), this.buildTestEvent());
        Assertions.assertTrue((boolean)token.toString().contains("Quartz"));
        Assertions.assertTrue((boolean)token.toString().contains(GROUP_ID));
        latch.await(1L, TimeUnit.SECONDS);
        ((EventBus)Mockito.verify((Object)this.eventBus)).publish(new EventMessage[]{(EventMessage)Mockito.isA(EventMessage.class)});
    }

    @Test
    void scheduleJobTransactionalUnitOfWork() throws InterruptedException {
        Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Mockito.when((Object)transactionManager.startTransaction()).thenReturn((Object)mockTransaction);
        this.testSubject = QuartzEventScheduler.builder().scheduler(this.scheduler).eventBus(this.eventBus).transactionManager(transactionManager).serializer(TestSerializer.XSTREAM.getSerializer()).build();
        this.testSubject.setGroupIdentifier(GROUP_ID);
        CountDownLatch latch = new CountDownLatch(1);
        ((Transaction)Mockito.doAnswer(invocation -> {
            latch.countDown();
            return null;
        }).when((Object)mockTransaction)).commit();
        ScheduleToken token = this.testSubject.schedule(Duration.ofMillis(30L), this.buildTestEvent());
        Assertions.assertTrue((boolean)token.toString().contains("Quartz"));
        Assertions.assertTrue((boolean)token.toString().contains(GROUP_ID));
        latch.await(1L, TimeUnit.SECONDS);
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> ((Transaction)Mockito.verify((Object)mockTransaction)).commit());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{transactionManager, this.eventBus, mockTransaction});
        ((TransactionManager)inOrder.verify((Object)transactionManager)).startTransaction();
        ((EventBus)inOrder.verify((Object)this.eventBus)).publish(new EventMessage[]{(EventMessage)Mockito.isA(EventMessage.class)});
        ((Transaction)inOrder.verify((Object)mockTransaction)).commit();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void scheduleJobTransactionalUnitOfWorkFailingTransaction() throws InterruptedException {
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)transactionManager.startTransaction()).thenAnswer(i -> {
            latch.countDown();
            throw new MockException();
        });
        this.testSubject = QuartzEventScheduler.builder().scheduler(this.scheduler).eventBus(this.eventBus).transactionManager(transactionManager).serializer(TestSerializer.XSTREAM.getSerializer()).build();
        this.testSubject.setGroupIdentifier(GROUP_ID);
        ScheduleToken token = this.testSubject.schedule(Duration.ofMillis(30L), this.buildTestEvent());
        Assertions.assertTrue((boolean)token.toString().contains("Quartz"));
        Assertions.assertTrue((boolean)token.toString().contains(GROUP_ID));
        latch.await(1L, TimeUnit.SECONDS);
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> ((TransactionManager)Mockito.verify((Object)transactionManager)).startTransaction());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{transactionManager, this.eventBus});
        ((TransactionManager)inOrder.verify((Object)transactionManager)).startTransaction();
        inOrder.verifyNoMoreInteractions();
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted());
    }

    @Test
    void cancelJob() throws SchedulerException {
        ScheduleToken token = this.testSubject.schedule(Duration.ofMillis(1000L), this.buildTestEvent());
        Assertions.assertEquals((int)1, (int)this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)GROUP_ID)).size());
        this.testSubject.cancelSchedule(token);
        Assertions.assertEquals((int)0, (int)this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)GROUP_ID)).size());
        this.scheduler.shutdown(true);
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).publish(new EventMessage[]{(EventMessage)Mockito.isA(EventMessage.class)});
    }

    @Test
    void shutdownInvokesSchedulerShutdown() throws SchedulerException {
        this.testSubject.shutdown();
        ((Scheduler)Mockito.verify((Object)this.scheduler)).shutdown(true);
    }

    @Test
    void shutdownFailureResultsInSchedulingException() throws SchedulerException {
        Scheduler scheduler = (Scheduler)Mockito.spy((Object)new StdSchedulerFactory().getScheduler());
        ((Scheduler)Mockito.doAnswer(invocation -> {
            throw new SchedulerException();
        }).when((Object)scheduler)).shutdown(true);
        QuartzEventScheduler testSubject = QuartzEventScheduler.builder().scheduler(scheduler).eventBus(this.eventBus).serializer(TestSerializer.XSTREAM.getSerializer()).build();
        Assertions.assertThrows(SchedulingException.class, () -> ((QuartzEventScheduler)testSubject).shutdown());
    }

    @Test
    void buildWithNullEventJobDataBinderThrowsAxonConfigurationException() {
        QuartzEventScheduler.Builder builderTestSubject = QuartzEventScheduler.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.jobDataBinder(null));
    }

    @Test
    void buildWithNullSerializerThrowsAxonConfigurationException() {
        QuartzEventScheduler.Builder builderTestSubject = QuartzEventScheduler.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.serializer(null));
    }

    @Test
    void buildWithoutSchedulerThrowsAxonConfigurationException() {
        SimpleEventBus eventBus = SimpleEventBus.builder().build();
        QuartzEventScheduler.Builder builderTestSubject = QuartzEventScheduler.builder().eventBus((EventBus)eventBus).serializer(TestSerializer.XSTREAM.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((QuartzEventScheduler.Builder)builderTestSubject).build());
    }

    @Test
    void buildWithoutEventBusThrowsAxonConfigurationException() {
        Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        QuartzEventScheduler.Builder builderTestSubject = QuartzEventScheduler.builder().scheduler(scheduler).serializer(TestSerializer.XSTREAM.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((QuartzEventScheduler.Builder)builderTestSubject).build());
    }

    private EventMessage<Object> buildTestEvent() {
        return new GenericEventMessage(new Object());
    }
}

