/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import org.axonframework.common.Priority;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class MultiParameterResolverFactoryTest {
    private ParameterResolverFactory mockFactory1;
    private ParameterResolverFactory mockFactory2;
    private ParameterResolver mockResolver1;
    private ParameterResolver mockResolver2;
    private MultiParameterResolverFactory testSubject;

    MultiParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockFactory1 = (ParameterResolverFactory)Mockito.mock(ParameterResolverFactory.class);
        this.mockFactory2 = (ParameterResolverFactory)Mockito.mock(ParameterResolverFactory.class);
        this.mockResolver1 = (ParameterResolver)Mockito.mock(ParameterResolver.class);
        this.mockResolver2 = (ParameterResolver)Mockito.mock(ParameterResolver.class);
        Mockito.when((Object)this.mockFactory1.createInstance((Executable)ArgumentMatchers.any(Executable.class), (Parameter[])ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn((Object)this.mockResolver1);
        Mockito.when((Object)this.mockFactory2.createInstance((Executable)ArgumentMatchers.any(Executable.class), (Parameter[])ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn((Object)this.mockResolver2);
        this.testSubject = new MultiParameterResolverFactory(new ParameterResolverFactory[]{this.mockFactory1, this.mockFactory2});
    }

    @Test
    void resolversQueriedInOrderProvided() throws Exception {
        Method equals = this.getClass().getMethod("equals", Object.class);
        ParameterResolver factory = this.testSubject.createInstance((Executable)equals, equals.getParameters(), 0);
        Assertions.assertFalse((boolean)factory.matches(null));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockFactory1, this.mockFactory2, this.mockResolver1, this.mockResolver2});
        ((ParameterResolverFactory)inOrder.verify((Object)this.mockFactory1)).createInstance((Executable)ArgumentMatchers.any(Executable.class), (Parameter[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((ParameterResolver)inOrder.verify((Object)this.mockResolver1)).matches((Message)Mockito.any());
        ((ParameterResolverFactory)Mockito.verify((Object)this.mockFactory2, (VerificationMode)Mockito.never())).createInstance((Executable)ArgumentMatchers.any(Executable.class), (Parameter[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((ParameterResolver)Mockito.verify((Object)this.mockResolver2, (VerificationMode)Mockito.never())).matches((Message)Mockito.any(Message.class));
    }

    @Test
    void firstMatchingResolverMayReturnValue() throws Exception {
        Method equals = this.getClass().getMethod("equals", Object.class);
        EventMessage message = GenericEventMessage.asEventMessage((Object)"test");
        Mockito.when((Object)this.mockFactory1.createInstance((Executable)ArgumentMatchers.any(Executable.class), (Parameter[])ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(null);
        Mockito.when((Object)this.mockResolver2.matches((Message)message)).thenReturn((Object)true);
        Mockito.when((Object)this.mockResolver2.resolveParameterValue((Message)message)).thenReturn((Object)"Resolved");
        ParameterResolver factory = this.testSubject.createInstance((Executable)equals, equals.getParameters(), 0);
        Assertions.assertTrue((boolean)factory.matches((Message)message));
        Assertions.assertEquals((Object)"Resolved", (Object)factory.resolveParameterValue((Message)message));
        ((ParameterResolver)Mockito.verify((Object)this.mockResolver1, (VerificationMode)Mockito.never())).resolveParameterValue((Message)Mockito.any(Message.class));
    }

    @Test
    void nestedParameterResolversAreOrdered() {
        LowPrioParameterResolverFactory lowPrio = new LowPrioParameterResolverFactory();
        HighPrioParameterResolverFactory highPrio = new HighPrioParameterResolverFactory();
        this.testSubject = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{this.mockFactory1, new MultiParameterResolverFactory(new ParameterResolverFactory[]{lowPrio, this.mockFactory2}), new MultiParameterResolverFactory(new ParameterResolverFactory[]{highPrio})});
        Assertions.assertEquals(Arrays.asList(highPrio, this.mockFactory1, this.mockFactory2, lowPrio), (Object)this.testSubject.getDelegates());
    }

    private static class AbstractNoopParameterResolverFactory
    implements ParameterResolverFactory {
        private AbstractNoopParameterResolverFactory() {
        }

        public ParameterResolver createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
            return null;
        }
    }

    @Priority(value=0x3FFFFFFF)
    private static class HighPrioParameterResolverFactory
    extends AbstractNoopParameterResolverFactory {
        private HighPrioParameterResolverFactory() {
        }
    }

    @Priority(value=-1073741824)
    private static class LowPrioParameterResolverFactory
    extends AbstractNoopParameterResolverFactory {
        private LowPrioParameterResolverFactory() {
        }
    }
}

