/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.DoNotEnqueue;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DoNotEnqueueTest {
    private DeadLetter<EventMessage<String>> testLetter;

    DoNotEnqueueTest() {
    }

    @BeforeEach
    void setUp() {
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        this.testLetter = new GenericDeadLetter((Object)"seqId", (Message)GenericEventMessage.asEventMessage((Object)"payload"));
    }

    @Test
    void constructorDoNotEnqueueDoesNotAllowEnqueueing() {
        DoNotEnqueue testSubject = new DoNotEnqueue();
        Assertions.assertFalse((boolean)testSubject.shouldEnqueue());
        Assertions.assertFalse((boolean)testSubject.enqueueCause().isPresent());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }

    @Test
    void decisionsDoNotEnqueueDoesNotAllowEnqueueing() {
        DoNotEnqueue testSubject = Decisions.doNotEnqueue();
        Assertions.assertFalse((boolean)testSubject.shouldEnqueue());
        Assertions.assertFalse((boolean)testSubject.enqueueCause().isPresent());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }

    @Test
    void decisionsEvictDoesNotAllowEnqueueing() {
        DoNotEnqueue testSubject = Decisions.evict();
        Assertions.assertFalse((boolean)testSubject.shouldEnqueue());
        Assertions.assertFalse((boolean)testSubject.enqueueCause().isPresent());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }
}

