/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.GenericQueryResponseMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.NoHandlerForQueryException;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SimpleQueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.registration.DuplicateQueryHandlerResolution;
import org.axonframework.queryhandling.registration.DuplicateQueryHandlerSubscriptionException;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SimpleQueryBusTest {
    private static final String TRACE_ID = "traceId";
    private static final String CORRELATION_ID = "correlationId";
    private final ResponseType<String> singleStringResponse = ResponseTypes.instanceOf(String.class);
    private final ResponseType<List<String>> multipleStringResponse = ResponseTypes.multipleInstancesOf(String.class);
    private SimpleQueryBus testSubject;
    private MessageMonitor<QueryMessage<?, ?>> messageMonitor;
    private QueryInvocationErrorHandler errorHandler;
    private MessageMonitor.MonitorCallback monitorCallback;
    private TestSpanFactory spanFactory;

    SimpleQueryBusTest() {
    }

    @BeforeEach
    void setUp() {
        this.spanFactory = new TestSpanFactory();
        this.messageMonitor = (MessageMonitor)Mockito.mock(MessageMonitor.class);
        this.errorHandler = (QueryInvocationErrorHandler)Mockito.mock(QueryInvocationErrorHandler.class);
        this.monitorCallback = (MessageMonitor.MonitorCallback)Mockito.mock(MessageMonitor.MonitorCallback.class);
        Mockito.when((Object)this.messageMonitor.onMessageIngested((Message)Mockito.any())).thenReturn((Object)this.monitorCallback);
        this.testSubject = SimpleQueryBus.builder().messageMonitor(this.messageMonitor).errorHandler(this.errorHandler).spanFactory((SpanFactory)this.spanFactory).queryUpdateEmitter((QueryUpdateEmitter)SimpleQueryUpdateEmitter.builder().spanFactory((SpanFactory)this.spanFactory).build()).build();
        CorrelationDataInterceptor correlationDataInterceptor = new CorrelationDataInterceptor(new CorrelationDataProvider[]{new MessageOriginProvider(CORRELATION_ID, TRACE_ID)});
        this.testSubject.registerHandlerInterceptor((MessageHandlerInterceptor)correlationDataInterceptor);
    }

    @Test
    public void handlerInterceptorThrowsException() throws ExecutionException, InterruptedException {
        this.testSubject.subscribe("test", String.class, q -> q.getPayload().toString());
        this.testSubject.registerHandlerInterceptor((unitOfWork, interceptorChain) -> {
            throw new RuntimeException("Faking");
        });
        CompletableFuture result = this.testSubject.query((QueryMessage)new GenericQueryMessage((Object)"hello", "test", ResponseTypes.instanceOf(String.class)));
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)((QueryResponseMessage)result.get()).isExceptional());
    }

    @Test
    void subscribe() {
        this.testSubject.subscribe("test", String.class, Message::getPayload);
        Assertions.assertEquals((int)1, (int)this.testSubject.getSubscriptions().size());
        Assertions.assertEquals((int)1, (int)((Collection)this.testSubject.getSubscriptions().values().iterator().next()).size());
        this.testSubject.subscribe("test", String.class, q -> "aa" + q.getPayload());
        Assertions.assertEquals((int)1, (int)this.testSubject.getSubscriptions().size());
        Assertions.assertEquals((int)2, (int)((Collection)this.testSubject.getSubscriptions().values().iterator().next()).size());
        this.testSubject.subscribe("test2", String.class, q -> "aa" + q.getPayload());
        Assertions.assertEquals((int)2, (int)this.testSubject.getSubscriptions().size());
    }

    @Test
    void subscribingSameHandlerTwiceInvokedOnce() throws Exception {
        AtomicInteger invocationCount = new AtomicInteger();
        MessageHandler handler = message -> {
            invocationCount.incrementAndGet();
            return "reply";
        };
        Registration subscription = this.testSubject.subscribe("test", String.class, handler);
        this.testSubject.subscribe("test", String.class, handler);
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"request", "test", this.singleStringResponse);
        String result = (String)((CompletableFuture)this.testSubject.query((QueryMessage)testQueryMessage).thenApply(Message::getPayload)).get();
        Assertions.assertEquals((Object)"reply", (Object)result);
        Assertions.assertEquals((int)1, (int)invocationCount.get());
        Assertions.assertTrue((boolean)subscription.cancel());
        Assertions.assertTrue((boolean)this.testSubject.query((QueryMessage)testQueryMessage).isDone());
        Assertions.assertTrue((boolean)this.testSubject.query((QueryMessage)testQueryMessage).isCompletedExceptionally());
    }

    @Test
    void subscribingSameQueryTwiceWithThrowingDuplicateResolver() throws Exception {
        this.testSubject = SimpleQueryBus.builder().messageMonitor(this.messageMonitor).errorHandler(this.errorHandler).duplicateQueryHandlerResolver(DuplicateQueryHandlerResolution.rejectDuplicates()).build();
        MessageHandler handlerOne = message -> "reply";
        MessageHandler handlerTwo = message -> "reply";
        this.testSubject.subscribe("test", String.class, handlerOne);
        Assertions.assertThrows(DuplicateQueryHandlerSubscriptionException.class, () -> this.testSubject.subscribe("test", String.class, handlerTwo));
    }

    @Test
    void queryResultContainsCorrelationData() throws Exception {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        QueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse).andMetaData(Collections.singletonMap(TRACE_ID, "fakeTraceId"));
        CompletableFuture result = this.testSubject.query(testQueryMessage);
        Assertions.assertTrue((boolean)result.isDone(), (String)"SimpleQueryBus should resolve CompletableFutures directly");
        Assertions.assertEquals((Object)"hello1234", (Object)((QueryResponseMessage)result.get()).getPayload());
        Assertions.assertEquals((Object)MetaData.with((String)CORRELATION_ID, (Object)testQueryMessage.getIdentifier()).and(TRACE_ID, (Object)"fakeTraceId"), (Object)((QueryResponseMessage)result.get()).getMetaData());
    }

    @Test
    void nullResponseProperlyReturned() throws ExecutionException, InterruptedException {
        this.testSubject.subscribe(String.class.getName(), String.class, p -> null);
        QueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse).andMetaData(Collections.singletonMap(TRACE_ID, "fakeTraceId"));
        CompletableFuture result = this.testSubject.query(testQueryMessage);
        Assertions.assertTrue((boolean)result.isDone(), (String)"SimpleQueryBus should resolve CompletableFutures directly");
        Assertions.assertNull((Object)((QueryResponseMessage)result.get()).getPayload());
        Assertions.assertEquals(String.class, (Object)((QueryResponseMessage)result.get()).getPayloadType());
        Assertions.assertEquals((Object)MetaData.with((String)CORRELATION_ID, (Object)testQueryMessage.getIdentifier()).and(TRACE_ID, (Object)"fakeTraceId"), (Object)((QueryResponseMessage)result.get()).getMetaData());
    }

    @Test
    void queryWithTransaction() throws Exception {
        TransactionManager mockTxManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Transaction mockTx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)mockTxManager.startTransaction()).thenReturn((Object)mockTx);
        this.testSubject = SimpleQueryBus.builder().transactionManager(mockTxManager).build();
        this.testSubject.subscribe(String.class.getName(), ReflectionUtils.methodOf(this.getClass(), (String)"stringListQueryHandler", (Class[])new Class[0]).getGenericReturnType(), q -> Arrays.asList(q.getPayload() + "1234", q.getPayload() + "567"));
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", ResponseTypes.multipleInstancesOf(String.class));
        CompletionStage result = this.testSubject.query((QueryMessage)testQueryMessage).thenApply(Message::getPayload);
        Assertions.assertTrue((boolean)((CompletableFuture)result).isDone());
        List completedResult = (List)((CompletableFuture)result).get();
        Assertions.assertTrue((boolean)completedResult.contains("hello1234"));
        Assertions.assertTrue((boolean)completedResult.contains("hello567"));
        ((TransactionManager)Mockito.verify((Object)mockTxManager)).startTransaction();
        ((Transaction)Mockito.verify((Object)mockTx)).commit();
    }

    public List<String> stringListQueryHandler() {
        return new ArrayList<String>();
    }

    @Test
    void querySingleWithTransaction() throws Exception {
        TransactionManager mockTxManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Transaction mockTx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)mockTxManager.startTransaction()).thenReturn((Object)mockTx);
        this.testSubject = SimpleQueryBus.builder().transactionManager(mockTxManager).build();
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse);
        CompletionStage result = this.testSubject.query((QueryMessage)testQueryMessage).thenApply(Message::getPayload);
        Assertions.assertEquals((Object)"hello1234", ((CompletableFuture)result).get());
        ((TransactionManager)Mockito.verify((Object)mockTxManager)).startTransaction();
        ((Transaction)Mockito.verify((Object)mockTx)).commit();
    }

    @Test
    void querySingleIsTraced() throws ExecutionException, InterruptedException {
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse);
        this.testSubject.subscribe(String.class.getName(), String.class, arg_0 -> this.lambda$querySingleIsTraced$12((QueryMessage)testQueryMessage, arg_0));
        this.testSubject.query((QueryMessage)testQueryMessage).get();
        this.spanFactory.verifySpanCompleted("SimpleQueryBus.query", (Message<?>)testQueryMessage);
    }

    @Test
    void ScatterGatherIsTraced() {
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.multipleStringResponse);
        this.testSubject.subscribe(String.class.getName(), String.class, arg_0 -> this.lambda$ScatterGatherIsTraced$13((QueryMessage)testQueryMessage, arg_0));
        this.testSubject.subscribe(String.class.getName(), String.class, arg_0 -> this.lambda$ScatterGatherIsTraced$14((QueryMessage)testQueryMessage, arg_0));
        this.testSubject.scatterGather((QueryMessage)testQueryMessage, 500L, TimeUnit.MILLISECONDS).collect(Collectors.toList());
        this.spanFactory.verifySpanCompleted("SimpleQueryBus.scatterGather(0)", (Message<?>)testQueryMessage);
        this.spanFactory.verifySpanCompleted("SimpleQueryBus.scatterGather(1)", (Message<?>)testQueryMessage);
    }

    @Test
    void queryListWithSingleHandlerReturnsSingleAsList() throws Exception {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.multipleStringResponse);
        CompletionStage result = this.testSubject.query((QueryMessage)testQueryMessage).thenApply(Message::getPayload);
        Assertions.assertEquals((int)1, (int)((List)((CompletableFuture)result).get()).size());
        Assertions.assertEquals((Object)"hello1234", ((List)((CompletableFuture)result).get()).get(0));
    }

    @Test
    void queryListWithBothSingleHandlerAndListHandlerReturnsListResult() throws Exception {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        this.testSubject.subscribe(String.class.getName(), String[].class, q -> Arrays.asList(q.getPayload() + "1234", q.getPayload() + "5678"));
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.multipleStringResponse);
        CompletionStage result = this.testSubject.query((QueryMessage)testQueryMessage).thenApply(Message::getPayload);
        Assertions.assertEquals((int)2, (int)((List)((CompletableFuture)result).get()).size());
        Assertions.assertEquals((Object)"hello1234", ((List)((CompletableFuture)result).get()).get(0));
        Assertions.assertEquals((Object)"hello5678", ((List)((CompletableFuture)result).get()).get(1));
    }

    @Test
    void queryForSingleResultWithUnsuitableHandlers() throws Exception {
        AtomicInteger invocationCount = new AtomicInteger();
        MessageHandler failingHandler = message -> {
            invocationCount.incrementAndGet();
            throw new NoHandlerForQueryException("Mock");
        };
        MessageHandler passingHandler = message -> {
            invocationCount.incrementAndGet();
            return "reply";
        };
        this.testSubject.subscribe("query", String.class, failingHandler);
        this.testSubject.subscribe("query", String.class, message -> failingHandler.handle(message));
        this.testSubject.subscribe("query", String.class, passingHandler);
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"query", "query", this.singleStringResponse);
        CompletionStage result = this.testSubject.query((QueryMessage)testQueryMessage).thenApply(Message::getPayload);
        Assertions.assertTrue((boolean)((CompletableFuture)result).isDone());
        Assertions.assertEquals((Object)"reply", ((CompletableFuture)result).get());
        Assertions.assertEquals((int)3, (int)invocationCount.get());
    }

    @Test
    void queryWithOnlyUnsuitableResultsInException() throws Exception {
        this.testSubject.subscribe("query", String.class, message -> {
            throw new NoHandlerForQueryException("Mock");
        });
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"query", "query", this.singleStringResponse);
        CompletableFuture result = this.testSubject.query((QueryMessage)testQueryMessage);
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)"NoHandlerForQueryException", ((CompletableFuture)((CompletableFuture)result.thenApply(Message::getPayload)).exceptionally(e -> e.getCause().getClass().getSimpleName())).get());
    }

    @Test
    void queryReturnsResponseMessageFromHandlerAsIs() throws Exception {
        GenericQueryResponseMessage soleResult = new GenericQueryResponseMessage((Object)"soleResult");
        this.testSubject.subscribe("query", String.class, message -> soleResult);
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"query", "query", this.singleStringResponse);
        CompletableFuture result = this.testSubject.query((QueryMessage)testQueryMessage);
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertSame(result.get(), (Object)soleResult);
    }

    @Test
    void queryWithHandlersResultsInException() throws Exception {
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"query", "query", this.singleStringResponse);
        CompletableFuture result = this.testSubject.query((QueryMessage)testQueryMessage);
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)"NoHandlerForQueryException", ((CompletableFuture)((CompletableFuture)result.thenApply(Message::getPayload)).exceptionally(e -> e.getCause().getClass().getSimpleName())).get());
    }

    @Test
    void queryForSingleResultWillReportErrors() throws Exception {
        MessageHandler failingHandler = message -> {
            throw new MockException("Mock");
        };
        this.testSubject.subscribe("query", String.class, failingHandler);
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"query", "query", this.singleStringResponse);
        CompletableFuture result = this.testSubject.query((QueryMessage)testQueryMessage);
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        QueryResponseMessage queryResponseMessage = (QueryResponseMessage)result.get();
        Assertions.assertTrue((boolean)queryResponseMessage.isExceptional());
        Assertions.assertEquals((Object)"Mock", (Object)queryResponseMessage.exceptionResult().getMessage());
    }

    @Test
    void queryWithInterceptors() throws Exception {
        this.testSubject.registerDispatchInterceptor(messages -> (i, m) -> m.andMetaData(Collections.singletonMap("key", "value")));
        this.testSubject.registerHandlerInterceptor((unitOfWork, interceptorChain) -> {
            if (((QueryMessage)unitOfWork.getMessage()).getMetaData().containsKey((Object)"key")) {
                return "fakeReply";
            }
            return interceptorChain.proceed();
        });
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse);
        CompletionStage result = this.testSubject.query((QueryMessage)testQueryMessage).thenApply(Message::getPayload);
        Assertions.assertEquals((Object)"fakeReply", ((CompletableFuture)result).get());
    }

    @Test
    void queryDoesNotArriveAtUnsubscribedHandler() throws Exception {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> "1234");
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + " is not here!").close();
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse);
        CompletionStage result = this.testSubject.query((QueryMessage)testQueryMessage).thenApply(Message::getPayload);
        Assertions.assertEquals((Object)"1234", ((CompletableFuture)result).get());
    }

    @Test
    void queryReturnsException() throws Exception {
        MockException mockException = new MockException();
        this.testSubject.subscribe(String.class.getName(), String.class, q -> {
            throw mockException;
        });
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse);
        CompletableFuture result = this.testSubject.query((QueryMessage)testQueryMessage);
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        QueryResponseMessage queryResponseMessage = (QueryResponseMessage)result.get();
        Assertions.assertTrue((boolean)queryResponseMessage.isExceptional());
        Assertions.assertEquals((Object)mockException, (Object)queryResponseMessage.exceptionResult());
    }

    @Test
    void queryUnknown() throws Exception {
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse);
        CompletableFuture result = this.testSubject.query((QueryMessage)testQueryMessage);
        try {
            result.get();
            Assertions.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assertions.assertEquals(NoHandlerForQueryException.class, e.getCause().getClass());
        }
        this.spanFactory.verifySpanHasException("SimpleQueryBus.query", NoHandlerForQueryException.class);
    }

    @Test
    void queryUnsubscribedHandlers() throws Exception {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + " is not here!").close();
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + " is not here!").close();
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse);
        CompletableFuture result = this.testSubject.query((QueryMessage)testQueryMessage);
        try {
            result.get();
            Assertions.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assertions.assertEquals(NoHandlerForQueryException.class, e.getCause().getClass());
        }
        ((MessageMonitor)Mockito.verify(this.messageMonitor, (VerificationMode)Mockito.times((int)1))).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback, (VerificationMode)Mockito.times((int)1))).reportFailure((Throwable)Mockito.any());
    }

    @Test
    void scatterGather() {
        int expectedResults = 3;
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "5678");
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "90");
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"Hello, World", this.singleStringResponse);
        Set results = this.testSubject.scatterGather((QueryMessage)testQueryMessage, 0L, TimeUnit.SECONDS).collect(Collectors.toSet());
        Assertions.assertEquals((int)expectedResults, (int)results.size());
        Set resultSet = results.stream().map(Message::getPayload).collect(Collectors.toSet());
        Assertions.assertEquals((int)expectedResults, (int)resultSet.size());
        ((MessageMonitor)Mockito.verify(this.messageMonitor, (VerificationMode)Mockito.times((int)1))).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback, (VerificationMode)Mockito.times((int)3))).reportSuccess();
    }

    /*
     * Exception decompiling
     */
    @Test
    void scatterGatherOnArrayQueryHandlers() throws NoSuchMethodException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] stringArrayQueryHandler() {
        return new String[0];
    }

    @Test
    void scatterGatherWithTransaction() {
        TransactionManager mockTxManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Transaction mockTx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)mockTxManager.startTransaction()).thenReturn((Object)mockTx);
        this.testSubject = SimpleQueryBus.builder().messageMonitor(this.messageMonitor).transactionManager(mockTxManager).errorHandler(this.errorHandler).build();
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "567");
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"Hello, World", this.singleStringResponse);
        Set results = this.testSubject.scatterGather((QueryMessage)testQueryMessage, 0L, TimeUnit.SECONDS).collect(Collectors.toSet());
        Assertions.assertEquals((int)2, (int)results.size());
        ((MessageMonitor)Mockito.verify(this.messageMonitor, (VerificationMode)Mockito.times((int)1))).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback, (VerificationMode)Mockito.times((int)2))).reportSuccess();
        ((TransactionManager)Mockito.verify((Object)mockTxManager, (VerificationMode)Mockito.times((int)2))).startTransaction();
        ((Transaction)Mockito.verify((Object)mockTx, (VerificationMode)Mockito.times((int)2))).commit();
    }

    @Test
    void scatterGatherWithTransactionRollsBackOnFailure() {
        TransactionManager mockTxManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Transaction mockTx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)mockTxManager.startTransaction()).thenReturn((Object)mockTx);
        this.testSubject = SimpleQueryBus.builder().messageMonitor(this.messageMonitor).transactionManager(mockTxManager).errorHandler(this.errorHandler).build();
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        this.testSubject.subscribe(String.class.getName(), String.class, q -> {
            throw new MockException();
        });
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"Hello, World", this.singleStringResponse);
        Set results = this.testSubject.scatterGather((QueryMessage)testQueryMessage, 0L, TimeUnit.SECONDS).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)results.size());
        ((MessageMonitor)Mockito.verify(this.messageMonitor, (VerificationMode)Mockito.times((int)1))).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback, (VerificationMode)Mockito.times((int)1))).reportSuccess();
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback, (VerificationMode)Mockito.times((int)1))).reportFailure((Throwable)Mockito.isA(MockException.class));
        ((TransactionManager)Mockito.verify((Object)mockTxManager, (VerificationMode)Mockito.times((int)2))).startTransaction();
        ((Transaction)Mockito.verify((Object)mockTx, (VerificationMode)Mockito.times((int)1))).commit();
        ((Transaction)Mockito.verify((Object)mockTx, (VerificationMode)Mockito.times((int)1))).rollback();
    }

    @Test
    void queryFirstFromScatterGatherWillCommitUnitOfWork() {
        TransactionManager mockTxManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Transaction mockTx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)mockTxManager.startTransaction()).thenReturn((Object)mockTx);
        this.testSubject = SimpleQueryBus.builder().messageMonitor(this.messageMonitor).transactionManager(mockTxManager).errorHandler(this.errorHandler).build();
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "567");
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"Hello, World", this.singleStringResponse);
        Optional firstResult = this.testSubject.scatterGather((QueryMessage)testQueryMessage, 0L, TimeUnit.SECONDS).findFirst();
        Assertions.assertTrue((boolean)firstResult.isPresent());
        ((MessageMonitor)Mockito.verify(this.messageMonitor, (VerificationMode)Mockito.times((int)1))).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback, (VerificationMode)Mockito.atMost((int)2))).reportSuccess();
        ((TransactionManager)Mockito.verify((Object)mockTxManager)).startTransaction();
        ((Transaction)Mockito.verify((Object)mockTx)).commit();
    }

    @Test
    void scatterGatherWithInterceptors() {
        this.testSubject.registerDispatchInterceptor(messages -> (i, m) -> m.andMetaData(Collections.singletonMap("key", "value")));
        this.testSubject.registerHandlerInterceptor((unitOfWork, interceptorChain) -> {
            if (((QueryMessage)unitOfWork.getMessage()).getMetaData().containsKey((Object)"key")) {
                return "fakeReply";
            }
            return interceptorChain.proceed();
        });
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "567");
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"Hello, World", this.singleStringResponse);
        List results = this.testSubject.scatterGather((QueryMessage)testQueryMessage, 0L, TimeUnit.SECONDS).map(Message::getPayload).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)results.size());
        ((MessageMonitor)Mockito.verify(this.messageMonitor, (VerificationMode)Mockito.times((int)1))).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback, (VerificationMode)Mockito.times((int)2))).reportSuccess();
        Assertions.assertEquals(Arrays.asList("fakeReply", "fakeReply"), results);
    }

    @Test
    void scatterGatherReturnsEmptyStreamWhenNoHandlersAvailable() {
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"Hello, World", this.singleStringResponse);
        Set allResults = this.testSubject.scatterGather((QueryMessage)testQueryMessage, 0L, TimeUnit.SECONDS).collect(Collectors.toSet());
        Assertions.assertEquals((int)0, (int)allResults.size());
        ((MessageMonitor)Mockito.verify(this.messageMonitor)).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback)).reportIgnored();
    }

    @Test
    void scatterGatherReportsExceptionsWithErrorHandler() {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        this.testSubject.subscribe(String.class.getName(), String.class, q -> {
            throw new MockException();
        });
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"Hello, World", this.singleStringResponse);
        Set results = this.testSubject.scatterGather((QueryMessage)testQueryMessage, 0L, TimeUnit.SECONDS).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)results.size());
        ((QueryInvocationErrorHandler)Mockito.verify((Object)this.errorHandler)).onError((Throwable)Mockito.isA(MockException.class), (QueryMessage)Mockito.eq((Object)testQueryMessage), (MessageHandler)Mockito.isA(MessageHandler.class));
        ((MessageMonitor)Mockito.verify(this.messageMonitor, (VerificationMode)Mockito.times((int)1))).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback, (VerificationMode)Mockito.times((int)1))).reportSuccess();
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.monitorCallback, (VerificationMode)Mockito.times((int)1))).reportFailure((Throwable)Mockito.isA(MockException.class));
    }

    @Test
    void queryResponseMessageCorrelationData() throws ExecutionException, InterruptedException {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        this.testSubject.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor(new CorrelationDataProvider[]{new MessageOriginProvider()}));
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"Hello, World", this.singleStringResponse);
        QueryResponseMessage queryResponseMessage = (QueryResponseMessage)this.testSubject.query((QueryMessage)testQueryMessage).get();
        Assertions.assertEquals((Object)testQueryMessage.getIdentifier(), (Object)queryResponseMessage.getMetaData().get((Object)TRACE_ID));
        Assertions.assertEquals((Object)testQueryMessage.getIdentifier(), (Object)queryResponseMessage.getMetaData().get((Object)CORRELATION_ID));
        Assertions.assertEquals((Object)"Hello, World1234", (Object)queryResponseMessage.getPayload());
    }

    @Test
    void subscriptionQueryReportsExceptionInInitialResult() {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> {
            throw new MockException();
        });
        SubscriptionQueryResult result = this.testSubject.subscriptionQuery((SubscriptionQueryMessage)new GenericSubscriptionQueryMessage((Object)"test", ResponseTypes.instanceOf(String.class), ResponseTypes.instanceOf(String.class)));
        Mono initialResult = result.initialResult();
        Assertions.assertFalse((boolean)((Boolean)initialResult.map(r -> false).onErrorReturn(MockException.class::isInstance, (Object)true).block()), (String)"Exception by handler should be reported in result, not on Mono");
        Assertions.assertTrue((boolean)((QueryResponseMessage)initialResult.block()).isExceptional());
    }

    @Test
    void subscriptionQueryIncreasingProjection() throws InterruptedException {
        CountDownLatch ten = new CountDownLatch(1);
        CountDownLatch hundred = new CountDownLatch(1);
        CountDownLatch thousand = new CountDownLatch(1);
        AtomicLong value = new AtomicLong();
        this.testSubject.subscribe("queryName", Long.class, q -> value.get());
        QueryUpdateEmitter updateEmitter = this.testSubject.queryUpdateEmitter();
        Disposable disposable = Flux.interval((Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(3L)).doOnNext(next -> {
            if (next == 10L) {
                ten.countDown();
            }
            if (next == 100L) {
                hundred.countDown();
            }
            if (next == 1000L) {
                thousand.countDown();
            }
            value.set((long)next);
            updateEmitter.emit(query -> "queryName".equals(query.getQueryName()), next);
        }).doOnComplete(() -> updateEmitter.complete(query -> "queryName".equals(query.getQueryName()))).subscribe();
        SubscriptionQueryResult result = this.testSubject.subscriptionQuery((SubscriptionQueryMessage)new GenericSubscriptionQueryMessage((Object)"test", "queryName", ResponseTypes.instanceOf(Long.class), ResponseTypes.instanceOf(Long.class)));
        Mono initialResult = result.initialResult();
        ten.await();
        Long firstInitialResult = (Long)((QueryResponseMessage)Objects.requireNonNull(initialResult.block())).getPayload();
        hundred.await();
        Long fistUpdate = (Long)((SubscriptionQueryUpdateMessage)Objects.requireNonNull(result.updates().next().block())).getPayload();
        thousand.await();
        Long anotherInitialResult = (Long)((QueryResponseMessage)Objects.requireNonNull(initialResult.block())).getPayload();
        Assertions.assertTrue((fistUpdate <= firstInitialResult + 1L ? 1 : 0) != 0);
        Assertions.assertTrue((firstInitialResult <= anotherInitialResult ? 1 : 0) != 0);
        disposable.dispose();
    }

    @Test
    void subscriptionQueryIsTraced() throws InterruptedException {
        CountDownLatch updatedLatch = new CountDownLatch(2);
        AtomicLong value = new AtomicLong();
        this.testSubject.subscribe("queryName", Long.class, q -> value.get());
        QueryUpdateEmitter updateEmitter = this.testSubject.queryUpdateEmitter();
        Disposable disposable = Flux.interval((Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(20L)).doOnNext(next -> {
            updatedLatch.countDown();
            updateEmitter.emit(query -> "queryName".equals(query.getQueryName()), next);
        }).doOnComplete(() -> updateEmitter.complete(query -> "queryName".equals(query.getQueryName()))).subscribe();
        SubscriptionQueryResult result = this.testSubject.subscriptionQuery((SubscriptionQueryMessage)new GenericSubscriptionQueryMessage((Object)"test", "queryName", ResponseTypes.instanceOf(Long.class), ResponseTypes.instanceOf(Long.class)));
        Mono initialResult = result.initialResult();
        ((QueryResponseMessage)Objects.requireNonNull(initialResult.block())).getPayload();
        this.spanFactory.verifySpanCompleted("SimpleQueryBus.query");
        updatedLatch.await();
        ((SubscriptionQueryUpdateMessage)Objects.requireNonNull(result.updates().next().block())).getPayload();
        this.spanFactory.verifySpanCompleted("QueryUpdateEmitter.emit queryName");
        disposable.dispose();
    }

    @Test
    void queryReportsExceptionInResponseMessage() throws ExecutionException, InterruptedException {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> {
            throw new MockException();
        });
        CompletableFuture result = this.testSubject.query((QueryMessage)new GenericQueryMessage((Object)"test", ResponseTypes.instanceOf(String.class)));
        Assertions.assertFalse((boolean)((Boolean)((CompletableFuture)((CompletableFuture)result.thenApply(r -> false)).exceptionally(MockException.class::isInstance)).get()), (String)"Exception by handler should be reported in result, not on Mono");
        Assertions.assertTrue((boolean)((QueryResponseMessage)result.get()).isExceptional());
    }

    @Test
    void queryHandlerDeclaresFutureResponseType() throws Exception {
        Type responseType = ReflectionUtils.methodOf(this.getClass(), (String)"futureMethod", (Class[])new Class[0]).getGenericReturnType();
        this.testSubject.subscribe(String.class.getName(), responseType, q -> CompletableFuture.completedFuture(q.getPayload() + "1234"));
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse);
        CompletableFuture result = this.testSubject.query((QueryMessage)testQueryMessage);
        Assertions.assertTrue((boolean)result.isDone(), (String)"SimpleQueryBus should resolve CompletableFutures directly");
        Assertions.assertEquals((Object)"hello1234", (Object)((QueryResponseMessage)result.get()).getPayload());
    }

    @Test
    void queryHandlerDeclaresCompletableFutureResponseType() throws Exception {
        Type responseType = ReflectionUtils.methodOf(this.getClass(), (String)"completableFutureMethod", (Class[])new Class[0]).getGenericReturnType();
        this.testSubject.subscribe(String.class.getName(), responseType, q -> CompletableFuture.completedFuture(q.getPayload() + "1234"));
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"hello", this.singleStringResponse);
        CompletableFuture result = this.testSubject.query((QueryMessage)testQueryMessage);
        Assertions.assertTrue((boolean)result.isDone(), (String)"SimpleQueryBus should resolve CompletableFutures directly");
        Assertions.assertEquals((Object)"hello1234", (Object)((QueryResponseMessage)result.get()).getPayload());
    }

    @Test
    void onSubscriptionQueryCancelTheActiveSubscriptionIsRemovedFromTheEmitterIfFluxIsNotSubscribed() {
        this.testSubject.subscribe(String.class.getName(), String.class, q -> q.getPayload() + "1234");
        GenericSubscriptionQueryMessage testQuery = new GenericSubscriptionQueryMessage((Object)"test", ResponseTypes.instanceOf(String.class), ResponseTypes.instanceOf(String.class));
        SubscriptionQueryResult result = this.testSubject.subscriptionQuery((SubscriptionQueryMessage)testQuery);
        result.cancel();
        Assertions.assertEquals((int)0, (int)this.testSubject.queryUpdateEmitter().activeSubscriptions().size());
    }

    public Future<String> futureMethod() {
        return null;
    }

    public CompletableFuture<String> completableFutureMethod() {
        return null;
    }

    private static /* synthetic */ Object lambda$scatterGatherOnArrayQueryHandlers$40(QueryMessage q) throws Exception {
        return new String[]{q.getPayload() + "9", q.getPayload() + "0"};
    }

    private static /* synthetic */ Object lambda$scatterGatherOnArrayQueryHandlers$39(QueryMessage q) throws Exception {
        return new String[]{q.getPayload() + "56", q.getPayload() + "78"};
    }

    private /* synthetic */ Object lambda$ScatterGatherIsTraced$14(QueryMessage testQueryMessage, QueryMessage q) throws Exception {
        this.spanFactory.verifySpanActive("SimpleQueryBus.scatterGather(1)", (Message<?>)testQueryMessage);
        return q.getPayload() + "12345678";
    }

    private /* synthetic */ Object lambda$ScatterGatherIsTraced$13(QueryMessage testQueryMessage, QueryMessage q) throws Exception {
        this.spanFactory.verifySpanActive("SimpleQueryBus.scatterGather(0)", (Message<?>)testQueryMessage);
        return q.getPayload() + "1234";
    }

    private /* synthetic */ Object lambda$querySingleIsTraced$12(QueryMessage testQueryMessage, QueryMessage q) throws Exception {
        this.spanFactory.verifySpanActive("SimpleQueryBus.query", (Message<?>)testQueryMessage);
        return q.getPayload() + "1234";
    }
}

