/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.annotation;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.axonframework.common.Registration;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.UnsupportedHandlerException;
import org.axonframework.messaging.interceptors.MessageHandlerInterceptor;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.NoHandlerForQueryException;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.annotation.AnnotationQueryHandlerAdapter;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AnnotationQueryHandlerAdapterTest {
    private AnnotationQueryHandlerAdapter<?> testSubject;
    private final QueryBus queryBus = (QueryBus)Mockito.mock(QueryBus.class);

    AnnotationQueryHandlerAdapterTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new AnnotationQueryHandlerAdapter((Object)new MyQueryHandler());
    }

    @Test
    void subscribe() {
        Mockito.when((Object)this.queryBus.subscribe((String)Mockito.any(), (Type)Mockito.any(), (MessageHandler)Mockito.any())).thenReturn(() -> true);
        Registration registration = this.testSubject.subscribe(this.queryBus);
        ((QueryBus)Mockito.verify((Object)this.queryBus, (VerificationMode)Mockito.times((int)1))).subscribe((String)Mockito.eq((Object)String.class.getName()), (Type)Mockito.eq(String.class), (MessageHandler)Mockito.any());
        ((QueryBus)Mockito.verify((Object)this.queryBus, (VerificationMode)Mockito.times((int)1))).subscribe((String)Mockito.eq((Object)"Hello"), (Type)Mockito.eq(String.class), (MessageHandler)Mockito.any());
        Assertions.assertTrue((boolean)registration.cancel());
    }

    @Test
    void subscribeFailsForHandlerWithInvalidParameters() {
        Assertions.assertThrows(UnsupportedHandlerException.class, () -> new AnnotationQueryHandlerAdapter((Object)new MySecondQueryHandler()));
    }

    @Test
    void subscribeFailsForHandlerWithVoidReturnType() {
        Assertions.assertThrows(UnsupportedHandlerException.class, () -> new AnnotationQueryHandlerAdapter((Object)new MyThirdQueryHandler()));
    }

    @Test
    void handleQuery() throws Exception {
        String testResponse = "hello";
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)testResponse, ResponseTypes.instanceOf(String.class));
        Object result = this.testSubject.handle((QueryMessage)testQueryMessage);
        Assertions.assertEquals((Object)testResponse, (Object)result);
    }

    @Test
    void handleQueryWithException() {
        GenericQueryMessage testQuery = new GenericQueryMessage((Object)"hello", ResponseTypes.instanceOf(Integer.class));
        Assertions.assertThrows(MockException.class, () -> this.lambda$handleQueryWithException$3((QueryMessage)testQuery));
    }

    @Test
    void handleQueryWithEmptyOptional() throws Exception {
        GenericQueryMessage testQuery = new GenericQueryMessage((Object)"hello", "noEcho", ResponseTypes.instanceOf(String.class));
        Assertions.assertNull((Object)this.testSubject.handle((QueryMessage)testQuery));
    }

    @Test
    void handleQueryWithProvidedOptional() throws Exception {
        GenericQueryMessage testQuery = new GenericQueryMessage((Object)"hello", "Hello", ResponseTypes.instanceOf(String.class));
        Assertions.assertEquals((Object)"hello", (Object)this.testSubject.handle((QueryMessage)testQuery));
    }

    @Test
    void handleQueryForCollection() throws Exception {
        int testResponse = 5;
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)testResponse, ResponseTypes.multipleInstancesOf(String.class));
        Collection result = (Collection)this.testSubject.handle((QueryMessage)testQueryMessage);
        Assertions.assertEquals((int)testResponse, (int)result.size());
    }

    @Test
    void handleQueryThrowsNoHandlerForQueryException() {
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)42L, ResponseTypes.multipleInstancesOf(String.class));
        Assertions.assertThrows(NoHandlerForQueryException.class, () -> this.lambda$handleQueryThrowsNoHandlerForQueryException$4((QueryMessage)testQueryMessage));
    }

    @Test
    void interceptMessages() throws Exception {
        ArrayList withInterceptor = new ArrayList();
        ArrayList withoutInterceptor = new ArrayList();
        this.testSubject = new AnnotationQueryHandlerAdapter((Object)new MyInterceptingQueryHandler(withoutInterceptor, withInterceptor));
        GenericQueryMessage testQueryMessage = new GenericQueryMessage((Object)"Hi", "Hello", ResponseTypes.instanceOf(String.class));
        String result = (String)this.testSubject.handle((QueryMessage)testQueryMessage);
        Assertions.assertEquals((Object)"Hi", (Object)result);
        Assertions.assertEquals(Collections.singletonList(testQueryMessage), withInterceptor);
        Assertions.assertEquals(Collections.singletonList(testQueryMessage), withoutInterceptor);
    }

    @Test
    void canHandleMessage() {
        GenericQueryMessage testIntegerQuery = new GenericQueryMessage((Object)"hello", ResponseTypes.instanceOf(Integer.class));
        GenericQueryMessage testLongQuery = new GenericQueryMessage((Object)"hello", ResponseTypes.instanceOf(Long.class));
        Assertions.assertTrue((boolean)this.testSubject.canHandle((QueryMessage)testIntegerQuery));
        Assertions.assertFalse((boolean)this.testSubject.canHandle((QueryMessage)testLongQuery));
    }

    private /* synthetic */ void lambda$handleQueryThrowsNoHandlerForQueryException$4(QueryMessage testQueryMessage) throws Throwable {
        this.testSubject.handle(testQueryMessage);
    }

    private /* synthetic */ void lambda$handleQueryWithException$3(QueryMessage testQuery) throws Throwable {
        this.testSubject.handle(testQuery);
    }

    private static class MyInterceptingQueryHandler
    extends MyQueryHandler {
        private final List<QueryMessage<?, ?>> interceptedWithoutInterceptorChain;
        private final List<QueryMessage<?, ?>> interceptedWithInterceptorChain;

        private MyInterceptingQueryHandler(List<QueryMessage<?, ?>> interceptedWithoutInterceptorChain, List<QueryMessage<?, ?>> interceptedWithInterceptorChain) {
            this.interceptedWithoutInterceptorChain = interceptedWithoutInterceptorChain;
            this.interceptedWithInterceptorChain = interceptedWithInterceptorChain;
        }

        @MessageHandlerInterceptor
        public void interceptAny(QueryMessage<?, ?> query) {
            this.interceptedWithoutInterceptorChain.add(query);
        }

        @MessageHandlerInterceptor
        public Object interceptAny(QueryMessage<?, ?> query, InterceptorChain chain) throws Exception {
            this.interceptedWithInterceptorChain.add(query);
            return chain.proceed();
        }
    }

    private static class MyThirdQueryHandler {
        private MyThirdQueryHandler() {
        }

        @QueryHandler
        public void echo(String echo) {
        }
    }

    private static class MySecondQueryHandler {
        private MySecondQueryHandler() {
        }

        @QueryHandler
        public String echo(MetaData metaData, String echo) {
            return echo;
        }
    }

    private static class MyQueryHandler {
        private MyQueryHandler() {
        }

        @QueryHandler
        public String echo(String echo) {
            return echo;
        }

        @QueryHandler(queryName="Hello")
        public Optional<String> echo2(String echo) {
            return Optional.ofNullable(echo);
        }

        @QueryHandler
        public Integer echo3(String echo) {
            throw new MockException("Mock");
        }

        @QueryHandler(queryName="noEcho")
        public Optional<String> echo4(String echo) {
            return Optional.empty();
        }

        @QueryHandler
        public List<? extends String> echo4(Integer count) {
            ArrayList<String> value = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                value.add("echo");
            }
            return value;
        }
    }
}

