/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nu.xom.Document;
import org.axonframework.serialization.Revision;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.axonframework.utils.StubDomainEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class XStreamSerializerTest {
    private static final String SPECIAL__CHAR__STRING = "Special chars: '\"&;\n\\<>/\n\t";
    private static final String REGULAR_STRING = "Henk";
    private TestEvent testEvent;
    private XStreamSerializer testSubject;

    XStreamSerializerTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = XStreamSerializer.builder().xStream(new XStream()).build();
        this.testEvent = new TestEvent(REGULAR_STRING);
    }

    @Test
    void serializeAndDeserializeDomainEvent() {
        SerializedObject serializedEvent = this.testSubject.serialize((Object)this.testEvent, byte[].class);
        Object actualResult = this.testSubject.deserialize(serializedEvent);
        Assertions.assertTrue((boolean)(actualResult instanceof TestEvent));
        TestEvent actualEvent = (TestEvent)actualResult;
        Assertions.assertEquals((Object)this.testEvent, (Object)actualEvent);
    }

    @Test
    void serializeAndDeserializeDomainEvent_WithXomUpcasters() {
        SerializedObject serializedEvent = this.testSubject.serialize((Object)this.testEvent, Document.class);
        Object actualResult = this.testSubject.deserialize(serializedEvent);
        Assertions.assertEquals((Object)this.testEvent, (Object)actualResult);
    }

    @Test
    void serializeAndDeserializeDomainEvent_WithDom4JUpcasters() {
        SerializedObject serializedEvent = this.testSubject.serialize((Object)this.testEvent, org.dom4j.Document.class);
        Object actualResult = this.testSubject.deserialize(serializedEvent);
        Assertions.assertEquals((Object)this.testEvent, (Object)actualResult);
    }

    @Test
    void serializeAndDeserializeArray() {
        TestEvent toSerialize = new TestEvent("first");
        SerializedObject serialized = this.testSubject.serialize((Object)new TestEvent[]{toSerialize}, String.class);
        Class actualType = this.testSubject.classForType(serialized.getType());
        Assertions.assertTrue((boolean)actualType.isArray());
        Assertions.assertEquals(TestEvent.class, actualType.getComponentType());
        TestEvent[] actual = (TestEvent[])this.testSubject.deserialize(serialized);
        Assertions.assertEquals((int)1, (int)actual.length);
        Assertions.assertEquals((Object)toSerialize.getName(), (Object)actual[0].getName());
    }

    @Test
    void serializeAndDeserializeList() {
        TestEvent toSerialize = new TestEvent("first");
        SerializedObject serialized = this.testSubject.serialize(Collections.singletonList(toSerialize), String.class);
        List actual = (List)this.testSubject.deserialize(serialized);
        Assertions.assertEquals((int)1, (int)actual.size());
        Assertions.assertEquals((Object)toSerialize.getName(), (Object)((TestEvent)actual.get(0)).getName());
    }

    @Test
    void deserializeEmptyBytes() {
        Assertions.assertEquals(Void.class, (Object)this.testSubject.classForType(SerializedType.emptyType()));
        Assertions.assertNull((Object)this.testSubject.deserialize((SerializedObject)new SimpleSerializedObject((Object)new byte[0], byte[].class, SerializedType.emptyType())));
    }

    @Test
    void packageAlias() {
        this.testSubject.addPackageAlias("axon-eh", "org.axonframework.utils");
        this.testSubject.addPackageAlias("axon", "org.axonframework");
        SerializedObject serialized = this.testSubject.serialize((Object)new StubDomainEvent(), byte[].class);
        String asString = new String((byte[])serialized.getData(), StandardCharsets.UTF_8);
        Assertions.assertFalse((boolean)asString.contains("org.axonframework.domain"), (String)("Package name found in:" + asString));
        StubDomainEvent deserialized = (StubDomainEvent)this.testSubject.deserialize(serialized);
        Assertions.assertEquals(StubDomainEvent.class, deserialized.getClass());
        Assertions.assertTrue((boolean)asString.contains("axon-eh"));
    }

    @Test
    void deserializeNullValue() {
        SerializedObject serializedNull = this.testSubject.serialize(null, byte[].class);
        Assertions.assertEquals((Object)"empty", (Object)serializedNull.getType().getName());
        SimpleSerializedObject serializedNullString = new SimpleSerializedObject(serializedNull.getData(), byte[].class, this.testSubject.typeForClass(String.class));
        Assertions.assertNull((Object)this.testSubject.deserialize(serializedNull));
        Assertions.assertNull((Object)this.testSubject.deserialize((SerializedObject)serializedNullString));
    }

    @Test
    void alias() {
        this.testSubject.addAlias("stub", StubDomainEvent.class);
        SerializedObject serialized = this.testSubject.serialize((Object)new StubDomainEvent(), byte[].class);
        String asString = new String((byte[])serialized.getData(), StandardCharsets.UTF_8);
        Assertions.assertFalse((boolean)asString.contains("org.axonframework.domain"));
        Assertions.assertTrue((boolean)asString.contains("<stub"));
        StubDomainEvent deserialized = (StubDomainEvent)this.testSubject.deserialize(serialized);
        Assertions.assertEquals(StubDomainEvent.class, deserialized.getClass());
    }

    @Test
    void fieldAlias() {
        this.testSubject.addFieldAlias("relevantPeriod", TestEvent.class, "period");
        SerializedObject serialized = this.testSubject.serialize((Object)this.testEvent, byte[].class);
        String asString = new String((byte[])serialized.getData(), StandardCharsets.UTF_8);
        Assertions.assertFalse((boolean)asString.contains("period"));
        Assertions.assertTrue((boolean)asString.contains("<relevantPeriod"));
        TestEvent deserialized = (TestEvent)this.testSubject.deserialize(serialized);
        Assertions.assertNotNull((Object)deserialized);
    }

    @Test
    void revisionNumber() {
        SerializedObject serialized = this.testSubject.serialize((Object)new RevisionSpecifiedEvent(), byte[].class);
        Assertions.assertNotNull((Object)serialized);
        Assertions.assertEquals((Object)"2", (Object)serialized.getType().getRevision());
        Assertions.assertEquals((Object)RevisionSpecifiedEvent.class.getName(), (Object)serialized.getType().getName());
    }

    @Test
    void serializedTypeUsesClassAlias() {
        this.testSubject.addAlias("rse", RevisionSpecifiedEvent.class);
        SerializedObject serialized = this.testSubject.serialize((Object)new RevisionSpecifiedEvent(), byte[].class);
        Assertions.assertNotNull((Object)serialized);
        Assertions.assertEquals((Object)"2", (Object)serialized.getType().getRevision());
        Assertions.assertEquals((Object)"rse", (Object)serialized.getType().getName());
    }

    @Test
    void serializeWithSpecialCharacters_WithDom4JUpcasters() {
        SerializedObject serialized = this.testSubject.serialize((Object)new TestEvent(SPECIAL__CHAR__STRING), byte[].class);
        TestEvent deserialized = (TestEvent)this.testSubject.deserialize(serialized);
        Assertions.assertArrayEquals((byte[])SPECIAL__CHAR__STRING.getBytes(), (byte[])deserialized.getName().getBytes());
    }

    @Test
    void serializeNullValue() {
        SerializedObject serialized = this.testSubject.serialize(null, byte[].class);
        String deserialized = (String)this.testSubject.deserialize(serialized);
        Assertions.assertNull((Object)deserialized);
    }

    @Test
    void serializeWithSpecialCharacters_WithoutUpcasters() {
        SerializedObject serialized = this.testSubject.serialize((Object)new TestEvent(SPECIAL__CHAR__STRING), byte[].class);
        TestEvent deserialized = (TestEvent)this.testSubject.deserialize(serialized);
        Assertions.assertEquals((Object)SPECIAL__CHAR__STRING, (Object)deserialized.getName());
    }

    @Test
    void unknownPropertiesAreIgnoredWhenConfiguringLenientDeserialization() {
        this.testSubject = XStreamSerializer.builder().xStream(new XStream()).lenientDeserialization().build();
        SerializedObject serialized = this.testSubject.serialize((Object)this.testEvent, org.dom4j.Document.class);
        org.dom4j.Document data = (org.dom4j.Document)serialized.getData();
        data.getRootElement().addElement("unknown").setText("Ignored");
        TestEvent actual = (TestEvent)this.testSubject.deserialize((SerializedObject)new SimpleSerializedObject((Object)data, org.dom4j.Document.class, serialized.getType()));
        Assertions.assertEquals((Object)this.testEvent, (Object)actual);
    }

    @Test
    void unknownPropertiesFailDeserializationByDefault() {
        this.testSubject = XStreamSerializer.builder().xStream(new XStream()).build();
        SerializedObject serialized = this.testSubject.serialize((Object)this.testEvent, org.dom4j.Document.class);
        org.dom4j.Document data = (org.dom4j.Document)serialized.getData();
        data.getRootElement().addElement("unknown").setText("Ignored");
        Assertions.assertThrows(AbstractReflectionConverter.UnknownFieldException.class, () -> this.testSubject.deserialize((SerializedObject)new SimpleSerializedObject((Object)data, org.dom4j.Document.class, serialized.getType())));
    }

    @Test
    void disableAxonTypeSecurity() {
        XStream xStream = (XStream)Mockito.mock(XStream.class);
        XStreamSerializer.builder().xStream(xStream).disableAxonTypeSecurity().build();
        ((XStream)Mockito.verify((Object)xStream, (VerificationMode)Mockito.times((int)0))).allowTypesByWildcard(new String[]{"org.axonframework.**"});
        XStreamSerializer.builder().xStream(xStream).build();
        ((XStream)Mockito.verify((Object)xStream)).allowTypesByWildcard(new String[]{"org.axonframework.**"});
    }

    public static class TestEvent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final LocalDate date;
        private final Instant dateTime;
        private final Period period;

        public TestEvent(String name) {
            this.name = name;
            this.date = LocalDate.now();
            this.dateTime = Instant.now();
            this.period = Period.ofDays(100);
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestEvent testEvent = (TestEvent)o;
            if (!Objects.equals(this.date, testEvent.date)) {
                return false;
            }
            if (!Objects.equals(this.dateTime, testEvent.dateTime)) {
                return false;
            }
            if (!Objects.equals(this.name, testEvent.name)) {
                return false;
            }
            return Objects.equals(this.period, testEvent.period);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
            result = 31 * result + (this.dateTime != null ? this.dateTime.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            return result;
        }
    }

    @Revision(value="2")
    public static class RevisionSpecifiedEvent {
    }
}

