/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.util.Arrays;
import java.util.function.Supplier;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.MultiSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class MultiSpanFactoryTest {
    private final SpanFactory spanFactory1 = (SpanFactory)Mockito.mock(SpanFactory.class);
    private final Span mockSpan1 = (Span)Mockito.mock(Span.class);
    private final SpanFactory spanFactory2 = (SpanFactory)Mockito.mock(SpanFactory.class);
    private final Span mockSpan2 = (Span)Mockito.mock(Span.class);
    private final SpanFactory multiSpanFactory = new MultiSpanFactory(Arrays.asList(this.spanFactory1, this.spanFactory2));
    private final GenericEventMessage<?> message = new GenericEventMessage((Object)"payload");
    private final Supplier<String> stringSupplier = () -> "Trace";

    MultiSpanFactoryTest() {
    }

    @Test
    void rootTracesCreatedWillDelegateToAllFactories() {
        Mockito.when((Object)this.spanFactory1.createRootTrace((Supplier)Mockito.any())).thenReturn((Object)this.mockSpan1);
        Mockito.when((Object)this.spanFactory2.createRootTrace((Supplier)Mockito.any())).thenReturn((Object)this.mockSpan2);
        Span span = this.multiSpanFactory.createRootTrace(() -> "Trace").start();
        ((Span)Mockito.verify((Object)this.mockSpan1)).start();
        ((Span)Mockito.verify((Object)this.mockSpan2)).start();
        ((Span)Mockito.verify((Object)this.mockSpan1, (VerificationMode)Mockito.never())).end();
        ((Span)Mockito.verify((Object)this.mockSpan2, (VerificationMode)Mockito.never())).end();
        RuntimeException exception = new RuntimeException("My Exception");
        span.recordException((Throwable)exception).end();
        ((Span)Mockito.verify((Object)this.mockSpan1)).end();
        ((Span)Mockito.verify((Object)this.mockSpan2)).end();
        ((Span)Mockito.verify((Object)this.mockSpan1)).recordException((Throwable)exception);
        ((Span)Mockito.verify((Object)this.mockSpan2)).recordException((Throwable)exception);
    }

    @Test
    void handlerSpansCreatedWillDelegateToAllFactories() {
        this.multiSpanFactory.createHandlerSpan(this.stringSupplier, this.message, false, new Message[0]);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory1)).createHandlerSpan(this.stringSupplier, this.message, false, new Message[0]);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory2)).createHandlerSpan(this.stringSupplier, this.message, false, new Message[0]);
    }

    @Test
    void dispatchSpansCreatedWillDelegateToAllFactories() {
        this.multiSpanFactory.createDispatchSpan(this.stringSupplier, this.message, new Message[0]);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory1)).createDispatchSpan(this.stringSupplier, this.message, new Message[0]);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory2)).createDispatchSpan(this.stringSupplier, this.message, new Message[0]);
    }

    @Test
    void internalSpansCreatedWillDelegateToAllFactories() {
        this.multiSpanFactory.createInternalSpan(this.stringSupplier);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory1)).createInternalSpan(this.stringSupplier);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory2)).createInternalSpan(this.stringSupplier);
    }

    @Test
    void internalSpansWithMessageCreatedWillDelegateToAllFactories() {
        this.multiSpanFactory.createInternalSpan(this.stringSupplier, this.message);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory1)).createInternalSpan(this.stringSupplier, this.message);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory2)).createInternalSpan(this.stringSupplier, this.message);
    }

    @Test
    void registerSpanAttributeProviderWillDelegateToAllFactories() {
        SpanAttributesProvider provider = (SpanAttributesProvider)Mockito.mock(SpanAttributesProvider.class);
        this.multiSpanFactory.registerSpanAttributeProvider(provider);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory1)).registerSpanAttributeProvider(provider);
        ((SpanFactory)Mockito.verify((Object)this.spanFactory2)).registerSpanAttributeProvider(provider);
    }

    @Test
    void propagateContextDelegateToAllFactories() {
        Message original = (Message)Mockito.mock(Message.class);
        Message modifiedFirst = (Message)Mockito.mock(Message.class);
        Message modifiedSecond = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)this.spanFactory1.propagateContext(original)).thenReturn((Object)modifiedFirst);
        Mockito.when((Object)this.spanFactory2.propagateContext(modifiedFirst)).thenReturn((Object)modifiedSecond);
        Message result = this.multiSpanFactory.propagateContext(original);
        Assertions.assertSame((Object)result, (Object)modifiedSecond);
    }
}

