/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.axonframework.commandhandling.AnnotationCommandHandlerAdapter;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.Registration;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AnnotationCommandHandlerAdapterTest {
    private AnnotationCommandHandlerAdapter testSubject;
    private CommandBus mockBus;
    private MyCommandHandler mockTarget;
    private UnitOfWork<CommandMessage<?>> mockUnitOfWork;
    private ParameterResolverFactory parameterResolverFactory;

    AnnotationCommandHandlerAdapterTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockBus = (CommandBus)Mockito.mock(CommandBus.class);
        this.mockTarget = new MyCommandHandler();
        this.parameterResolverFactory = ClasspathParameterResolverFactory.forClass(this.getClass());
        this.testSubject = new AnnotationCommandHandlerAdapter((Object)this.mockTarget, this.parameterResolverFactory);
        this.mockUnitOfWork = (UnitOfWork)Mockito.mock(UnitOfWork.class);
        Mockito.when((Object)this.mockUnitOfWork.resources()).thenReturn(Mockito.mock(Map.class));
        Mockito.when((Object)this.mockUnitOfWork.getCorrelationData()).thenReturn((Object)MetaData.emptyInstance());
        Mockito.when((Object)this.mockBus.subscribe((String)Mockito.any(), (MessageHandler)Mockito.any())).thenReturn(Mockito.mock(Registration.class));
        CurrentUnitOfWork.set(this.mockUnitOfWork);
    }

    @AfterEach
    void tearDown() {
        CurrentUnitOfWork.clear(this.mockUnitOfWork);
    }

    @Test
    void handlerDispatching_VoidReturnType() throws Exception {
        Object actualReturnValue = this.testSubject.handle(GenericCommandMessage.asCommandMessage((Object)""));
        Assertions.assertNull((Object)actualReturnValue);
        Assertions.assertEquals((int)1, (int)this.mockTarget.voidHandlerInvoked);
        Assertions.assertEquals((int)0, (int)this.mockTarget.returningHandlerInvoked);
    }

    @Test
    void handlerDispatching_WithReturnType() throws Exception {
        Object actualReturnValue = this.testSubject.handle(GenericCommandMessage.asCommandMessage((Object)1L));
        Assertions.assertEquals((Object)1L, (Object)actualReturnValue);
        Assertions.assertEquals((int)0, (int)this.mockTarget.voidHandlerInvoked);
        Assertions.assertEquals((int)1, (int)this.mockTarget.returningHandlerInvoked);
    }

    @Test
    void handlerDispatching_WithCustomCommandName() throws Exception {
        Object actualReturnValue = this.testSubject.handle((CommandMessage)new GenericCommandMessage((Message)new GenericMessage((Object)1L), "almostLong"));
        Assertions.assertEquals((Object)1L, (Object)actualReturnValue);
        Assertions.assertEquals((int)0, (int)this.mockTarget.voidHandlerInvoked);
        Assertions.assertEquals((int)0, (int)this.mockTarget.returningHandlerInvoked);
        Assertions.assertEquals((int)1, (int)this.mockTarget.almostDuplicateReturningHandlerInvoked);
    }

    @Test
    void handlerDispatching_ThrowingException() {
        try {
            this.testSubject.handle(GenericCommandMessage.asCommandMessage(new HashSet()));
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception ex) {
            Assertions.assertEquals(Exception.class, ex.getClass());
            return;
        }
        Assertions.fail((String)"Shouldn't make it till here");
    }

    @Test
    void subscribe() {
        this.testSubject.subscribe(this.mockBus);
        ((CommandBus)Mockito.verify((Object)this.mockBus)).subscribe(Long.class.getName(), (MessageHandler)this.testSubject);
        ((CommandBus)Mockito.verify((Object)this.mockBus)).subscribe(String.class.getName(), (MessageHandler)this.testSubject);
        ((CommandBus)Mockito.verify((Object)this.mockBus)).subscribe(HashSet.class.getName(), (MessageHandler)this.testSubject);
        ((CommandBus)Mockito.verify((Object)this.mockBus)).subscribe(ArrayList.class.getName(), (MessageHandler)this.testSubject);
        ((CommandBus)Mockito.verify((Object)this.mockBus)).subscribe("almostLong", (MessageHandler)this.testSubject);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBus});
    }

    @Test
    void handle_NoHandlerForCommand() throws Exception {
        CommandMessage command = GenericCommandMessage.asCommandMessage(new LinkedList());
        Assertions.assertThrows(NoHandlerForCommandException.class, () -> this.testSubject.handle(command));
    }

    private static class MyCommandHandler {
        private int voidHandlerInvoked;
        private int returningHandlerInvoked;
        private int almostDuplicateReturningHandlerInvoked;

        private MyCommandHandler() {
        }

        @CommandHandler
        public void myVoidHandler(String stringCommand, UnitOfWork<CommandMessage<?>> unitOfWork) {
            ++this.voidHandlerInvoked;
        }

        @CommandHandler(commandName="almostLong")
        public Long myAlmostDuplicateReturningHandler(Long longCommand, UnitOfWork<CommandMessage<?>> unitOfWork) {
            Assertions.assertNotNull(unitOfWork, (String)"The UnitOfWork was not passed to the command handler");
            ++this.almostDuplicateReturningHandlerInvoked;
            return longCommand;
        }

        @CommandHandler
        public Long myReturningHandler(Long longCommand, UnitOfWork<CommandMessage<?>> unitOfWork) {
            Assertions.assertNotNull(unitOfWork, (String)"The UnitOfWork was not passed to the command handler");
            ++this.returningHandlerInvoked;
            return longCommand;
        }

        @CommandHandler
        public void exceptionThrowingHandler(HashSet o) throws Exception {
            throw new Exception("Some exception");
        }

        @CommandHandler
        public void exceptionThrowingHandler(ArrayList o) {
            throw new RuntimeException("Some exception");
        }
    }
}

