/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.LinkedList;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class WrappedCommandCallbackTest {
    WrappedCommandCallbackTest() {
    }

    @Test
    void wrappedCallbackShouldCallBothInOrder() {
        LinkedList calls = new LinkedList();
        CommandCallback callbackOne = (message, result) -> calls.add("one");
        CommandCallback callbackTwo = (message, result) -> calls.add("two");
        CommandCallback wrappedCallback = callbackOne.wrap(callbackTwo);
        wrappedCallback.onResult((CommandMessage)Mockito.mock(CommandMessage.class), (CommandResultMessage)Mockito.mock(CommandResultMessage.class));
        Assertions.assertEquals((Object)"two", calls.get(0));
        Assertions.assertEquals((Object)"one", calls.get(1));
    }

    @Test
    void wrapWithNullShouldRetainOriginal() {
        CommandCallback original = (message, result) -> {};
        CommandCallback wrappedWithNull = original.wrap(null);
        Assertions.assertSame((Object)original, (Object)wrappedWithNull);
    }
}

