/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.RoutingKey;
import org.axonframework.commandhandling.distributed.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.distributed.CommandDispatchException;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.commandhandling.distributed.UnresolvedRoutingKeyPolicy;
import org.axonframework.common.AxonConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AnnotationRoutingStrategyTest {
    private AnnotationRoutingStrategy testSubject;

    AnnotationRoutingStrategyTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = AnnotationRoutingStrategy.defaultStrategy();
    }

    @Test
    void getRoutingKeyFromField() {
        GenericCommandMessage testCommand = new GenericCommandMessage((Object)new SomeFieldAnnotatedCommand());
        Assertions.assertEquals((Object)"Target", (Object)this.testSubject.getRoutingKey((CommandMessage)testCommand));
        GenericCommandMessage otherTestCommand = new GenericCommandMessage((Object)new SomeOtherFieldAnnotatedCommand());
        Assertions.assertEquals((Object)"Target", (Object)this.testSubject.getRoutingKey((CommandMessage)otherTestCommand));
    }

    @Test
    void getRoutingKeyFromMethod() {
        GenericCommandMessage testCommand = new GenericCommandMessage((Object)new SomeMethodAnnotatedCommand());
        Assertions.assertEquals((Object)"Target", (Object)this.testSubject.getRoutingKey((CommandMessage)testCommand));
        GenericCommandMessage otherTestCommand = new GenericCommandMessage((Object)new SomeOtherMethodAnnotatedCommand());
        Assertions.assertEquals((Object)"Target", (Object)this.testSubject.getRoutingKey((CommandMessage)otherTestCommand));
    }

    @Test
    void nullRoutingKeyOnFieldThrowsCommandDispatchException() {
        AnnotationRoutingStrategy errorFallbackRoutingStrategy = AnnotationRoutingStrategy.builder().fallbackRoutingStrategy((RoutingStrategy)UnresolvedRoutingKeyPolicy.ERROR).build();
        GenericCommandMessage testCommand = new GenericCommandMessage((Object)new SomeNullMethodAnnotatedCommand());
        Assertions.assertThrows(CommandDispatchException.class, () -> AnnotationRoutingStrategyTest.lambda$nullRoutingKeyOnFieldThrowsCommandDispatchException$0(errorFallbackRoutingStrategy, (CommandMessage)testCommand));
    }

    @Test
    void nullRoutingKeyOnMethodThrowsCommandDispatchException() {
        AnnotationRoutingStrategy errorFallbackRoutingStrategy = AnnotationRoutingStrategy.builder().fallbackRoutingStrategy((RoutingStrategy)UnresolvedRoutingKeyPolicy.ERROR).build();
        GenericCommandMessage testCommand = new GenericCommandMessage((Object)new SomeNullMethodAnnotatedCommand());
        Assertions.assertThrows(CommandDispatchException.class, () -> AnnotationRoutingStrategyTest.lambda$nullRoutingKeyOnMethodThrowsCommandDispatchException$1(errorFallbackRoutingStrategy, (CommandMessage)testCommand));
    }

    @Test
    void resolvesRoutingKeyFromAnnotationDoesNotInvokeFallbackStrategy() {
        RoutingStrategy fallbackRoutingStrategy = (RoutingStrategy)Mockito.mock(RoutingStrategy.class);
        AnnotationRoutingStrategy testSubjectWithMockedFallbackStrategy = AnnotationRoutingStrategy.builder().fallbackRoutingStrategy(fallbackRoutingStrategy).build();
        GenericCommandMessage testCommand = new GenericCommandMessage((Object)new SomeFieldAnnotatedCommand());
        Assertions.assertEquals((Object)"Target", (Object)testSubjectWithMockedFallbackStrategy.getRoutingKey((CommandMessage)testCommand));
        Mockito.verifyNoInteractions((Object[])new Object[]{fallbackRoutingStrategy});
    }

    @Test
    void resolvesRoutingKeyFromFallbackStrategy() {
        String expectedRoutingKey = "some-routing-key";
        RoutingStrategy fallbackRoutingStrategy = (RoutingStrategy)Mockito.mock(RoutingStrategy.class);
        Mockito.when((Object)fallbackRoutingStrategy.getRoutingKey((CommandMessage)Mockito.any())).thenReturn((Object)expectedRoutingKey);
        AnnotationRoutingStrategy testSubjectWithMockedFallbackStrategy = AnnotationRoutingStrategy.builder().fallbackRoutingStrategy(fallbackRoutingStrategy).build();
        GenericCommandMessage testCommand = new GenericCommandMessage((Object)new SomeCommandWithoutTheRoutingAnnotation("target"));
        Assertions.assertEquals((Object)expectedRoutingKey, (Object)testSubjectWithMockedFallbackStrategy.getRoutingKey((CommandMessage)testCommand));
        ((RoutingStrategy)Mockito.verify((Object)fallbackRoutingStrategy)).getRoutingKey((CommandMessage)testCommand);
    }

    @Test
    void buildAnnotationRoutingStrategyFailsForNullFallbackRoutingStrategy() {
        AnnotationRoutingStrategy.Builder builderTestSubject = AnnotationRoutingStrategy.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.fallbackRoutingStrategy(null));
    }

    @Test
    void buildAnnotationRoutingStrategyFailsForNullAnnotationType() {
        AnnotationRoutingStrategy.Builder builderTestSubject = AnnotationRoutingStrategy.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.annotationType(null));
    }

    private static /* synthetic */ void lambda$nullRoutingKeyOnMethodThrowsCommandDispatchException$1(AnnotationRoutingStrategy errorFallbackRoutingStrategy, CommandMessage testCommand) throws Throwable {
        errorFallbackRoutingStrategy.getRoutingKey(testCommand);
    }

    private static /* synthetic */ void lambda$nullRoutingKeyOnFieldThrowsCommandDispatchException$0(AnnotationRoutingStrategy errorFallbackRoutingStrategy, CommandMessage testCommand) throws Throwable {
        errorFallbackRoutingStrategy.getRoutingKey(testCommand);
    }

    public static class SomeCommandWithoutTheRoutingAnnotation {
        private final String target;

        public SomeCommandWithoutTheRoutingAnnotation(String target) {
            this.target = target;
        }

        public String getTarget() {
            return this.target;
        }
    }

    public static class SomeNullMethodAnnotatedCommand {
        private final String target;

        public SomeNullMethodAnnotatedCommand() {
            this.target = null;
        }

        @RoutingKey
        public String getTarget() {
            return this.target;
        }
    }

    private static class SomeObject {
        private final String target;

        public SomeObject(String target) {
            this.target = target;
        }

        public String toString() {
            return this.target;
        }
    }

    public static class SomeOtherMethodAnnotatedCommand {
        private final SomeObject target = new SomeObject("Target");

        @RoutingKey
        public SomeObject getTarget() {
            return this.target;
        }
    }

    public static class SomeMethodAnnotatedCommand {
        private final String target = "Target";

        @RoutingKey
        public String getTarget() {
            return "Target";
        }
    }

    public static class SomeOtherFieldAnnotatedCommand {
        @RoutingKey
        private final SomeObject target = new SomeObject("Target");
    }

    public static class SomeFieldAnnotatedCommand {
        @RoutingKey
        private final String target = "Target";
    }
}

