/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.caching;

import java.util.Collections;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.common.Registration;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.caching.WeakReferenceCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class WeakReferenceCacheTest {
    private WeakReferenceCache testSubject;
    private Cache.EntryListener mockListener;
    private Registration registration;

    WeakReferenceCacheTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockListener = (Cache.EntryListener)Mockito.mock(Cache.EntryListener.class);
        this.testSubject = new WeakReferenceCache();
        this.registration = this.testSubject.registerCacheEntryListener(this.mockListener);
    }

    @Test
    void itemPurgedWhenNoLongerReferenced() throws Exception {
        int i;
        this.registration.cancel();
        final CopyOnWriteArraySet expiredEntries = new CopyOnWriteArraySet();
        this.testSubject.registerCacheEntryListener((Cache.EntryListener)new Cache.EntryListenerAdapter(){

            public void onEntryExpired(Object key) {
                expiredEntries.add(key.toString());
            }
        });
        Object value = new Object();
        this.testSubject.put((Object)"test1", value);
        Assertions.assertSame((Object)value, (Object)this.testSubject.get((Object)"test1"));
        value = null;
        System.gc();
        for (i = 0; i < 5 && this.testSubject.containsKey((Object)"test1"); ++i) {
            System.gc();
            Thread.sleep(100L);
        }
        Assertions.assertNull((Object)this.testSubject.get((Object)"test1"));
        for (i = 0; i < 5 && !expiredEntries.contains("test1"); ++i) {
            this.testSubject.get((Object)"test1");
            Thread.sleep(100L);
        }
        Assertions.assertEquals(Collections.singleton("test1"), expiredEntries);
    }

    @Test
    void entryListenerNotifiedOfCreationUpdateAndDeletion() {
        Object value = new Object();
        Object value2 = new Object();
        this.testSubject.put((Object)"test1", value);
        ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryCreated((Object)"test1", value);
        this.testSubject.put((Object)"test1", value2);
        ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryUpdated((Object)"test1", value2);
        this.testSubject.get((Object)"test1");
        ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryRead((Object)"test1", value2);
        this.testSubject.remove((Object)"test1");
        ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryRemoved((Object)"test1");
        Assertions.assertNull((Object)this.testSubject.get((Object)"test1"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockListener});
    }

    @Test
    void shouldThrowIllegalArgumentExceptionWhenKeyIsNullOnGet() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.get(null));
    }

    @Test
    void shouldThrowIllegalArgumentExceptionWhenKeyIsNullOnContainsKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.containsKey(null));
    }

    @Test
    void removeAllRemovesAllEntries() {
        this.testSubject.put((Object)"one", new Object());
        this.testSubject.put((Object)"two", new Object());
        this.testSubject.put((Object)"three", new Object());
        this.testSubject.put((Object)"four", new Object());
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"one"));
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"two"));
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"three"));
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"four"));
        this.testSubject.removeAll();
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"one"));
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"two"));
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"three"));
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"four"));
    }

    @Test
    void computeIfPresentDoesNotUpdateNonExistingEntry() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.testSubject.computeIfPresent((Object)"some-key", v -> {
            invoked.set(true);
            return v;
        });
        Assertions.assertFalse((boolean)invoked.get());
    }

    @Test
    void computeIfPresentUpdatesExistingEntry() {
        String testKey = "some-key";
        this.testSubject.put((Object)testKey, new Object());
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.testSubject.computeIfPresent((Object)testKey, v -> {
            invoked.set(true);
            return v;
        });
        Assertions.assertTrue((boolean)invoked.get());
    }
}

