/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.lock;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.common.lock.DeadlockException;
import org.axonframework.common.lock.Lock;
import org.axonframework.common.lock.LockAcquisitionFailedException;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

class PessimisticLockFactoryTest {
    private String identifier = "mockId";

    PessimisticLockFactoryTest() {
    }

    @Test
    void lockReferenceCleanedUpAtUnlock() throws NoSuchFieldException, IllegalAccessException {
        PessimisticLockFactory manager = PessimisticLockFactory.builder().build();
        Lock lock = manager.obtainLock(this.identifier);
        lock.release();
        Field locksField = manager.getClass().getDeclaredField("locks");
        locksField.setAccessible(true);
        Map locks = (Map)locksField.get(manager);
        Assertions.assertEquals((int)0, (int)locks.size(), (String)"Expected lock to be cleaned up");
    }

    @Test
    void lockOnlyCleanedUpIfNoLocksAreHeld() throws NoSuchFieldException, IllegalAccessException {
        PessimisticLockFactory manager = PessimisticLockFactory.builder().build();
        Lock lock1 = manager.obtainLock(this.identifier);
        Lock lock2 = manager.obtainLock(this.identifier);
        lock1.release();
        Field locksField = manager.getClass().getDeclaredField("locks");
        locksField.setAccessible(true);
        Map locks = (Map)locksField.get(manager);
        Assertions.assertEquals((int)1, (int)locks.size(), (String)"Expected lock not to be cleaned up");
        lock2.release();
        locks = (Map)locksField.get(manager);
        Assertions.assertEquals((int)0, (int)locks.size(), (String)"Expected locks to be cleaned up");
    }

    @Test
    @Timeout(value=10L)
    void deadlockDetected_TwoThreadsInVector() throws InterruptedException {
        PessimisticLockFactory lock = PessimisticLockFactory.builder().build();
        CountDownLatch starter = new CountDownLatch(1);
        CountDownLatch cdl = new CountDownLatch(1);
        AtomicBoolean deadlockInThread = new AtomicBoolean(false);
        Thread t1 = this.createThread(starter, cdl, deadlockInThread, lock, "id1", lock, "id2");
        t1.start();
        lock.obtainLock("id2");
        starter.await();
        cdl.countDown();
        try {
            lock.obtainLock("id1");
            Assertions.assertTrue((boolean)deadlockInThread.get());
        }
        catch (DeadlockException deadlockException) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=12L)
    void deadlockDetected_TwoDifferentLockInstances() throws InterruptedException {
        PessimisticLockFactory lock1 = PessimisticLockFactory.builder().build();
        PessimisticLockFactory lock2 = PessimisticLockFactory.builder().build();
        CountDownLatch starter = new CountDownLatch(1);
        CountDownLatch cdl = new CountDownLatch(1);
        AtomicBoolean deadlockInThread = new AtomicBoolean(false);
        Thread t1 = this.createThread(starter, cdl, deadlockInThread, lock1, "id1", lock2, "id1");
        t1.start();
        lock2.obtainLock("id1");
        starter.await();
        cdl.countDown();
        try {
            lock1.obtainLock("id1");
            Assertions.assertTrue((boolean)deadlockInThread.get());
        }
        catch (DeadlockException deadlockException) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=10L)
    void deadlockDetected_ThreeThreadsInVector() throws InterruptedException {
        PessimisticLockFactory lock = PessimisticLockFactory.builder().build();
        CountDownLatch starter = new CountDownLatch(3);
        CountDownLatch cdl = new CountDownLatch(1);
        AtomicBoolean deadlockInThread = new AtomicBoolean(false);
        Thread t1 = this.createThread(starter, cdl, deadlockInThread, lock, "id1", lock, "id2");
        Thread t2 = this.createThread(starter, cdl, deadlockInThread, lock, "id2", lock, "id3");
        Thread t3 = this.createThread(starter, cdl, deadlockInThread, lock, "id3", lock, "id4");
        t1.start();
        t2.start();
        t3.start();
        lock.obtainLock("id4");
        starter.await();
        cdl.countDown();
        try {
            lock.obtainLock("id1");
            Assertions.assertTrue((boolean)deadlockInThread.get());
        }
        catch (DeadlockException deadlockException) {
            // empty catch block
        }
    }

    private Thread createThread(CountDownLatch starter, CountDownLatch cdl, AtomicBoolean deadlockInThread, PessimisticLockFactory LockFactory1, String firstId, PessimisticLockFactory LockFactory2, String secondId) {
        return new Thread(() -> {
            Lock lock1 = LockFactory1.obtainLock(firstId);
            starter.countDown();
            try {
                cdl.await();
                Lock lock2 = LockFactory2.obtainLock(secondId);
                lock2.release();
            }
            catch (InterruptedException e) {
                System.out.println("Thread 1 interrupted");
            }
            catch (DeadlockException e) {
                deadlockInThread.set(true);
            }
            finally {
                lock1.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5L)
    void acquireBackoff() {
        PessimisticLockFactory lockFactory = PessimisticLockFactory.builder().acquireAttempts(10).queueLengthThreshold(Integer.MAX_VALUE).lockAttemptTimeout(0).build();
        CountDownLatch rendezvous = new CountDownLatch(1);
        try {
            AtomicReference<Exception> exceptionInThread = new AtomicReference<Exception>();
            String id = "aggregateId";
            this.createThreadObtainLockAndWaitForState(lockFactory, Thread.State.WAITING, rendezvous, exceptionInThread, "aggregateId");
            Assertions.assertThrows(LockAcquisitionFailedException.class, () -> lockFactory.obtainLock("aggregateId"));
        }
        finally {
            rendezvous.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5L)
    void queueBackoff() {
        PessimisticLockFactory lockFactory = PessimisticLockFactory.builder().acquireAttempts(Integer.MAX_VALUE).queueLengthThreshold(2).lockAttemptTimeout(10000).build();
        CountDownLatch rendezvous = new CountDownLatch(1);
        try {
            AtomicReference<Exception> exceptionInThread = new AtomicReference<Exception>();
            String id = "aggregateId";
            this.createThreadObtainLockAndWaitForState(lockFactory, Thread.State.WAITING, rendezvous, exceptionInThread, "aggregateId");
            this.createThreadObtainLockAndWaitForState(lockFactory, Thread.State.TIMED_WAITING, rendezvous, exceptionInThread, "aggregateId");
            this.createThreadObtainLockAndWaitForState(lockFactory, Thread.State.TIMED_WAITING, rendezvous, exceptionInThread, "aggregateId");
            Assertions.assertThrows(LockAcquisitionFailedException.class, () -> lockFactory.obtainLock("aggregateId"));
        }
        finally {
            rendezvous.countDown();
        }
    }

    @Test
    void backoffParametersConstructorAquireAttempts() {
        int illegalValue = 0;
        Assertions.assertThrows(IllegalArgumentException.class, () -> PessimisticLockFactory.builder().acquireAttempts(illegalValue));
    }

    @Test
    void backoffParametersConstructorMaximumQueued() {
        int illegalValue = 0;
        Assertions.assertThrows(IllegalArgumentException.class, () -> PessimisticLockFactory.builder().queueLengthThreshold(illegalValue));
    }

    @Test
    void backoffParametersConstructorSpinTime() {
        int illegalValue = -1;
        Assertions.assertThrows(IllegalArgumentException.class, () -> PessimisticLockFactory.builder().lockAttemptTimeout(illegalValue));
    }

    @Test
    void shouldThrowIllegalArgumentExceptionWhenIdentifierIsNull() {
        this.identifier = null;
        PessimisticLockFactory manager = PessimisticLockFactory.builder().build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> manager.obtainLock(this.identifier));
    }

    private void createThreadObtainLockAndWaitForState(PessimisticLockFactory lockFactory, Thread.State state, CountDownLatch rendezvous, AtomicReference<Exception> exceptionInThread, String id) {
        Thread thread = new Thread(() -> {
            try (Lock ignored = lockFactory.obtainLock(id);){
                rendezvous.await();
            }
            catch (Exception e) {
                exceptionInThread.set(e);
            }
        });
        thread.start();
        while (thread.isAlive() && rendezvous.getCount() > 0L && thread.getState() != state) {
            Thread.yield();
        }
    }
}

