/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Collections;
import java.util.HashMap;
import java.util.OptionalLong;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.MultiSourceTrackingToken;
import org.axonframework.eventhandling.TrackingToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class MultiSourceTrackingTokenTest {
    private MultiSourceTrackingToken testSubject;

    MultiSourceTrackingTokenTest() {
    }

    @BeforeEach
    void setUp() {
        HashMap<String, GlobalSequenceTrackingToken> tokenMap = new HashMap<String, GlobalSequenceTrackingToken>();
        tokenMap.put("token1", new GlobalSequenceTrackingToken(0L));
        tokenMap.put("token2", new GlobalSequenceTrackingToken(0L));
        this.testSubject = new MultiSourceTrackingToken(tokenMap);
    }

    @Test
    void incompatibleToken() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.covers((TrackingToken)new GlobalSequenceTrackingToken(0L)));
    }

    @Test
    void trackingTokenIsImmutable() {
        MultiSourceTrackingToken newToken = this.testSubject.advancedTo("token1", (TrackingToken)new GlobalSequenceTrackingToken(1L));
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(0L), (Object)this.testSubject.getTokenForStream("token1"));
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(0L), (Object)this.testSubject.getTokenForStream("token2"));
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(1L), (Object)newToken.getTokenForStream("token1"));
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(0L), (Object)newToken.getTokenForStream("token2"));
    }

    @Test
    void lowerBound() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        newTokens.put("token2", new GlobalSequenceTrackingToken(2L));
        HashMap<String, GlobalSequenceTrackingToken> expectedTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        expectedTokens.put("token1", new GlobalSequenceTrackingToken(0L));
        expectedTokens.put("token2", new GlobalSequenceTrackingToken(0L));
        MultiSourceTrackingToken newMultiToken = (MultiSourceTrackingToken)this.testSubject.lowerBound((TrackingToken)new MultiSourceTrackingToken(newTokens));
        Assertions.assertEquals((Object)new MultiSourceTrackingToken(expectedTokens), (Object)newMultiToken);
    }

    @Test
    void lowerBoundWithNullOnThisToken() {
        HashMap<String, GlobalSequenceTrackingToken> tokens = new HashMap<String, GlobalSequenceTrackingToken>();
        tokens.put("token1", new GlobalSequenceTrackingToken(2L));
        tokens.put("token2", null);
        this.testSubject = new MultiSourceTrackingToken(tokens);
        HashMap<String, GlobalSequenceTrackingToken> otherTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        otherTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        otherTokens.put("token2", new GlobalSequenceTrackingToken(2L));
        HashMap<String, GlobalSequenceTrackingToken> expectedTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        expectedTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        expectedTokens.put("token2", null);
        MultiSourceTrackingToken result = (MultiSourceTrackingToken)this.testSubject.lowerBound((TrackingToken)new MultiSourceTrackingToken(otherTokens));
        Assertions.assertEquals((Object)new MultiSourceTrackingToken(expectedTokens), (Object)result);
    }

    @Test
    void lowerBoundWithNullOnOtherToken() {
        HashMap<String, GlobalSequenceTrackingToken> tokens = new HashMap<String, GlobalSequenceTrackingToken>();
        tokens.put("token1", new GlobalSequenceTrackingToken(2L));
        tokens.put("token2", new GlobalSequenceTrackingToken(2L));
        this.testSubject = new MultiSourceTrackingToken(tokens);
        HashMap<String, GlobalSequenceTrackingToken> otherTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        otherTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        otherTokens.put("token2", null);
        HashMap<String, GlobalSequenceTrackingToken> expectedTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        expectedTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        expectedTokens.put("token2", null);
        MultiSourceTrackingToken result = (MultiSourceTrackingToken)this.testSubject.lowerBound((TrackingToken)new MultiSourceTrackingToken(otherTokens));
        Assertions.assertEquals((Object)new MultiSourceTrackingToken(expectedTokens), (Object)result);
    }

    @Test
    void lowerBoundMismatchTokens() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        newTokens.put("token3", new GlobalSequenceTrackingToken(2L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.lowerBound((TrackingToken)new MultiSourceTrackingToken(newTokens)));
    }

    @Test
    void lowerBoundDifferentNumberOfTokens() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.lowerBound((TrackingToken)new MultiSourceTrackingToken(newTokens)));
    }

    @Test
    void positionNotProvidedWhenUnderlyingTokensDontProvide() {
        TrackingToken trackingToken = (TrackingToken)Mockito.mock(TrackingToken.class);
        Mockito.when((Object)trackingToken.position()).thenReturn((Object)OptionalLong.empty());
        this.testSubject = new MultiSourceTrackingToken(Collections.singletonMap("key", trackingToken));
        Assertions.assertFalse((boolean)this.testSubject.position().isPresent());
    }

    @Test
    void upperBound() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        newTokens.put("token2", new GlobalSequenceTrackingToken(2L));
        MultiSourceTrackingToken newMultiToken = (MultiSourceTrackingToken)this.testSubject.upperBound((TrackingToken)new MultiSourceTrackingToken(newTokens));
        Assertions.assertEquals((Object)new MultiSourceTrackingToken(newTokens), (Object)newMultiToken);
    }

    @Test
    void upperBoundWithNullInThisToken() {
        HashMap<String, GlobalSequenceTrackingToken> tokens = new HashMap<String, GlobalSequenceTrackingToken>();
        tokens.put("token1", new GlobalSequenceTrackingToken(0L));
        tokens.put("token2", null);
        this.testSubject = new MultiSourceTrackingToken(tokens);
        HashMap<String, GlobalSequenceTrackingToken> otherTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        otherTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        otherTokens.put("token2", new GlobalSequenceTrackingToken(2L));
        MultiSourceTrackingToken result = (MultiSourceTrackingToken)this.testSubject.upperBound((TrackingToken)new MultiSourceTrackingToken(otherTokens));
        Assertions.assertEquals((Object)new MultiSourceTrackingToken(otherTokens), (Object)result);
    }

    @Test
    void upperBoundWithNullInOtherToken() {
        HashMap<String, GlobalSequenceTrackingToken> expectedTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        expectedTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        expectedTokens.put("token2", new GlobalSequenceTrackingToken(2L));
        HashMap<String, GlobalSequenceTrackingToken> tokens = new HashMap<String, GlobalSequenceTrackingToken>();
        tokens.put("token1", new GlobalSequenceTrackingToken(0L));
        tokens.put("token2", new GlobalSequenceTrackingToken(2L));
        this.testSubject = new MultiSourceTrackingToken(tokens);
        HashMap<String, GlobalSequenceTrackingToken> otherTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        otherTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        otherTokens.put("token2", null);
        MultiSourceTrackingToken result = (MultiSourceTrackingToken)this.testSubject.upperBound((TrackingToken)new MultiSourceTrackingToken(otherTokens));
        Assertions.assertEquals((Object)new MultiSourceTrackingToken(expectedTokens), (Object)result);
    }

    @Test
    void upperBoundMismatchTokens() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        newTokens.put("token3", new GlobalSequenceTrackingToken(2L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.upperBound((TrackingToken)new MultiSourceTrackingToken(newTokens)));
    }

    @Test
    void upperBoundDifferentNumberOfTokens() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.upperBound((TrackingToken)new MultiSourceTrackingToken(newTokens)));
    }

    @Test
    void covers() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(0L));
        newTokens.put("token2", new GlobalSequenceTrackingToken(0L));
        Assertions.assertTrue((boolean)this.testSubject.covers((TrackingToken)new MultiSourceTrackingToken(newTokens)));
    }

    @Test
    void doesNotCover() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        newTokens.put("token2", new GlobalSequenceTrackingToken(0L));
        Assertions.assertFalse((boolean)this.testSubject.covers((TrackingToken)new MultiSourceTrackingToken(newTokens)));
    }

    @Test
    void coversNullConstituents() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(0L));
        newTokens.put("token2", null);
        MultiSourceTrackingToken tokenWithNullConstituent = new MultiSourceTrackingToken(newTokens);
        Assertions.assertTrue((boolean)tokenWithNullConstituent.covers((TrackingToken)tokenWithNullConstituent));
        Assertions.assertTrue((boolean)this.testSubject.covers((TrackingToken)tokenWithNullConstituent));
        Assertions.assertFalse((boolean)tokenWithNullConstituent.covers((TrackingToken)this.testSubject));
    }

    @Test
    void coversMismatchTokens() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        newTokens.put("token3", new GlobalSequenceTrackingToken(2L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.covers((TrackingToken)new MultiSourceTrackingToken(newTokens)));
    }

    @Test
    void coversDifferentNumberOfTokens() {
        HashMap<String, GlobalSequenceTrackingToken> newTokens = new HashMap<String, GlobalSequenceTrackingToken>();
        newTokens.put("token1", new GlobalSequenceTrackingToken(1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.covers((TrackingToken)new MultiSourceTrackingToken(newTokens)));
    }

    @Test
    void advancedTo() {
        MultiSourceTrackingToken result = this.testSubject.advancedTo("token1", (TrackingToken)new GlobalSequenceTrackingToken(4L));
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(4L), (Object)result.getTokenForStream("token1"));
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(0L), (Object)result.getTokenForStream("token2"));
    }

    @Test
    void getTokenForStream() {
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(0L), (Object)this.testSubject.getTokenForStream("token1"));
    }

    @Test
    void hasPosition() {
        Assertions.assertTrue((boolean)this.testSubject.position().isPresent());
        Assertions.assertEquals((long)0L, (long)this.testSubject.position().getAsLong());
    }

    @Test
    void positionWithNullValue() {
        HashMap<String, GlobalSequenceTrackingToken> tokenMap = new HashMap<String, GlobalSequenceTrackingToken>();
        tokenMap.put("token1", new GlobalSequenceTrackingToken(10L));
        tokenMap.put("token2", null);
        MultiSourceTrackingToken newMultiToken = new MultiSourceTrackingToken(tokenMap);
        Assertions.assertEquals((long)10L, (long)newMultiToken.position().orElse(-1L));
    }

    @Test
    void positionWithNullValue2() {
        HashMap<String, GlobalSequenceTrackingToken> tokenMap = new HashMap<String, GlobalSequenceTrackingToken>();
        tokenMap.put("token1", null);
        tokenMap.put("token2", new GlobalSequenceTrackingToken(10L));
        MultiSourceTrackingToken newMultiToken = new MultiSourceTrackingToken(tokenMap);
        Assertions.assertEquals((long)10L, (long)newMultiToken.position().orElse(-1L));
    }

    @Test
    void equals() {
        HashMap<String, GlobalSequenceTrackingToken> tokenMap = new HashMap<String, GlobalSequenceTrackingToken>();
        tokenMap.put("token1", new GlobalSequenceTrackingToken(0L));
        tokenMap.put("token2", new GlobalSequenceTrackingToken(0L));
        MultiSourceTrackingToken newMultiToken = new MultiSourceTrackingToken(tokenMap);
        Assertions.assertEquals((Object)newMultiToken, (Object)this.testSubject);
    }

    @Test
    void notEquals() {
        HashMap<String, GlobalSequenceTrackingToken> tokenMap = new HashMap<String, GlobalSequenceTrackingToken>();
        tokenMap.put("token1", new GlobalSequenceTrackingToken(1L));
        tokenMap.put("token2", new GlobalSequenceTrackingToken(0L));
        MultiSourceTrackingToken newMultiToken = new MultiSourceTrackingToken(tokenMap);
        Assertions.assertNotEquals((Object)newMultiToken, (Object)this.testSubject);
    }

    @Test
    void constituentTokenNotInitialized() {
        HashMap<String, GlobalSequenceTrackingToken> tokenMap = new HashMap<String, GlobalSequenceTrackingToken>();
        tokenMap.put("token1", null);
        tokenMap.put("token2", new GlobalSequenceTrackingToken(0L));
        MultiSourceTrackingToken newMultiToken = new MultiSourceTrackingToken(tokenMap);
        Assertions.assertNotEquals((Object)newMultiToken, (Object)this.testSubject);
    }
}

