/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.List;
import java.util.function.Consumer;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.SimpleEventBus;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SimpleEventBusTest {
    private Consumer<List<? extends EventMessage<?>>> listener1;
    private Consumer<List<? extends EventMessage<?>>> listener2;
    private Consumer<List<? extends EventMessage<?>>> listener3;
    private EventBus testSubject;

    SimpleEventBusTest() {
    }

    @BeforeEach
    void setUp() {
        this.listener1 = (Consumer)Mockito.mock(Consumer.class);
        this.listener2 = (Consumer)Mockito.mock(Consumer.class);
        this.listener3 = (Consumer)Mockito.mock(Consumer.class);
        this.testSubject = SimpleEventBus.builder().build();
    }

    @Test
    void eventIsDispatchedToSubscribedListeners() throws Exception {
        this.testSubject.publish(new EventMessage[]{this.newEvent()});
        this.testSubject.subscribe(this.listener1);
        Registration subscription1 = this.testSubject.subscribe(this.listener1);
        this.testSubject.publish(new EventMessage[]{this.newEvent()});
        Registration subscription2 = this.testSubject.subscribe(this.listener2);
        Registration subscription3 = this.testSubject.subscribe(this.listener3);
        this.testSubject.publish(new EventMessage[]{this.newEvent()});
        subscription1.close();
        this.testSubject.publish(new EventMessage[]{this.newEvent()});
        subscription2.close();
        subscription3.close();
        subscription3.close();
        this.testSubject.publish(new EventMessage[]{this.newEvent()});
        ((Consumer)Mockito.verify(this.listener1, (VerificationMode)Mockito.times((int)2))).accept(Mockito.anyList());
        ((Consumer)Mockito.verify(this.listener2, (VerificationMode)Mockito.times((int)2))).accept(Mockito.anyList());
        ((Consumer)Mockito.verify(this.listener3, (VerificationMode)Mockito.times((int)2))).accept(Mockito.anyList());
    }

    private EventMessage newEvent() {
        return new GenericEventMessage(new Object());
    }
}

