/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.eventhandling.deadletter.DeadLetteringEventHandlerInvoker;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.EnqueuePolicy;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.utils.EventTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DeadLetteringEventHandlerInvokerTest {
    private static final DomainEventMessage<String> TEST_EVENT = EventTestUtils.createEvent();
    private static final Object TEST_SEQUENCE_ID = TEST_EVENT.getAggregateIdentifier();
    private static final DeadLetter<EventMessage<?>> TEST_DEAD_LETTER = new GenericDeadLetter(TEST_SEQUENCE_ID, TEST_EVENT);
    private EventMessageHandler handler;
    private SequencingPolicy<? super EventMessage<?>> sequencingPolicy;
    private SequencedDeadLetterQueue<EventMessage<?>> queue;
    private EnqueuePolicy<EventMessage<?>> enqueuePolicy;
    private TransactionManager transactionManager;
    private DeadLetteringEventHandlerInvoker testSubject;

    DeadLetteringEventHandlerInvokerTest() {
    }

    @BeforeEach
    void setUp() {
        this.handler = (EventMessageHandler)Mockito.mock(EventMessageHandler.class);
        this.sequencingPolicy = (SequencingPolicy)Mockito.spy((Object)SequentialPerAggregatePolicy.instance());
        this.queue = (SequencedDeadLetterQueue)Mockito.mock(SequencedDeadLetterQueue.class);
        this.enqueuePolicy = (EnqueuePolicy)Mockito.mock(EnqueuePolicy.class);
        Mockito.when((Object)this.enqueuePolicy.decide((DeadLetter)Mockito.any(), (Throwable)Mockito.any())).thenReturn((Object)Decisions.ignore());
        this.transactionManager = (TransactionManager)Mockito.spy((Object)new StubTransactionManager());
        this.setTestSubject(this.createTestSubject());
    }

    private void setTestSubject(DeadLetteringEventHandlerInvoker testSubject) {
        this.testSubject = testSubject;
    }

    private DeadLetteringEventHandlerInvoker createTestSubject() {
        return this.createTestSubject(builder -> builder);
    }

    private DeadLetteringEventHandlerInvoker createTestSubject(UnaryOperator<DeadLetteringEventHandlerInvoker.Builder> customization) {
        DeadLetteringEventHandlerInvoker.Builder invokerBuilder = ((DeadLetteringEventHandlerInvoker.Builder)((DeadLetteringEventHandlerInvoker.Builder)((DeadLetteringEventHandlerInvoker.Builder)DeadLetteringEventHandlerInvoker.builder().eventHandlers(new Object[]{this.handler})).sequencingPolicy(this.sequencingPolicy)).listenerInvocationErrorHandler((ListenerInvocationErrorHandler)PropagatingErrorHandler.instance())).queue(this.queue).enqueuePolicy(this.enqueuePolicy).transactionManager(this.transactionManager);
        return ((DeadLetteringEventHandlerInvoker.Builder)customization.apply(invokerBuilder)).build();
    }

    @Test
    void handleMethodHandlesEventJustFine() throws Exception {
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        GenericDeadLetter expectedIfPresentLetter = new GenericDeadLetter(TEST_SEQUENCE_ID, TEST_EVENT);
        Mockito.when((Object)this.queue.enqueueIfPresent(Mockito.any(), (Supplier)Mockito.any())).thenReturn((Object)false);
        this.testSubject.handle(TEST_EVENT, Segment.ROOT_SEGMENT);
        ((SequencingPolicy)Mockito.verify(this.sequencingPolicy, (VerificationMode)Mockito.times((int)2))).getSequenceIdentifierFor(TEST_EVENT);
        ((EventMessageHandler)Mockito.verify((Object)this.handler)).handle(TEST_EVENT);
        ArgumentCaptor enqueueIfPresentCaptor = ArgumentCaptor.forClass(Supplier.class);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).enqueueIfPresent(Mockito.eq((Object)TEST_SEQUENCE_ID), (Supplier)enqueueIfPresentCaptor.capture());
        DeadLetteringEventHandlerInvokerTest.assertLetter(expectedIfPresentLetter, (DeadLetter)((Supplier)enqueueIfPresentCaptor.getValue()).get());
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue, (VerificationMode)Mockito.never())).enqueue(Mockito.eq((Object)TEST_SEQUENCE_ID), (DeadLetter)Mockito.any());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.transactionManager});
    }

    @Test
    void handleMethodIgnoresEventForNonMatchingSegment() throws Exception {
        Segment testSegment = (Segment)Mockito.mock(Segment.class);
        Mockito.when((Object)testSegment.matches(Mockito.any())).thenReturn((Object)false);
        this.testSubject.handle(TEST_EVENT, testSegment);
        ((SequencingPolicy)Mockito.verify(this.sequencingPolicy)).getSequenceIdentifierFor(TEST_EVENT);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.handler});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.queue});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.transactionManager});
    }

    @Test
    void handleMethodEnqueuesOnShouldEnqueueDecisionWhenDelegateThrowsAnException() throws Exception {
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        RuntimeException testCause = new RuntimeException("some-cause");
        GenericDeadLetter expectedIfPresentLetter = new GenericDeadLetter(TEST_SEQUENCE_ID, TEST_EVENT);
        GenericDeadLetter expectedEnqueuedLetter = new GenericDeadLetter(TEST_SEQUENCE_ID, TEST_EVENT, (Throwable)testCause);
        ((EventMessageHandler)Mockito.doThrow((Throwable[])new Throwable[]{testCause}).when((Object)this.handler)).handle(TEST_EVENT);
        Mockito.when((Object)this.queue.enqueueIfPresent(Mockito.any(), (Supplier)Mockito.any())).thenReturn((Object)false);
        this.testSubject.handle(TEST_EVENT, Segment.ROOT_SEGMENT);
        ((SequencingPolicy)Mockito.verify(this.sequencingPolicy, (VerificationMode)Mockito.times((int)2))).getSequenceIdentifierFor(TEST_EVENT);
        ((EventMessageHandler)Mockito.verify((Object)this.handler)).handle(TEST_EVENT);
        ArgumentCaptor enqueueIfPresentCaptor = ArgumentCaptor.forClass(Supplier.class);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).enqueueIfPresent(Mockito.eq((Object)TEST_SEQUENCE_ID), (Supplier)enqueueIfPresentCaptor.capture());
        DeadLetteringEventHandlerInvokerTest.assertLetter(expectedIfPresentLetter, (DeadLetter)((Supplier)enqueueIfPresentCaptor.getValue()).get());
        ArgumentCaptor policyCaptor = ArgumentCaptor.forClass(DeadLetter.class);
        ((EnqueuePolicy)Mockito.verify(this.enqueuePolicy)).decide((DeadLetter)policyCaptor.capture(), (Throwable)Mockito.eq((Object)testCause));
        DeadLetteringEventHandlerInvokerTest.assertLetter(expectedEnqueuedLetter, (DeadLetter)policyCaptor.getValue());
        ArgumentCaptor enqueueCaptor = ArgumentCaptor.forClass(DeadLetter.class);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).enqueue(Mockito.eq((Object)TEST_SEQUENCE_ID), (DeadLetter)enqueueCaptor.capture());
        DeadLetteringEventHandlerInvokerTest.assertLetter(expectedEnqueuedLetter, (DeadLetter)enqueueCaptor.getValue());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.transactionManager});
    }

    @Test
    void handleMethodDoesNotEnqueueForShouldNotEnqueueDecisionWhenDelegateThrowsAnException() throws Exception {
        Mockito.when((Object)this.enqueuePolicy.decide((DeadLetter)Mockito.any(), (Throwable)Mockito.any())).thenReturn((Object)Decisions.doNotEnqueue());
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        RuntimeException testCause = new RuntimeException("some-cause");
        GenericDeadLetter expectedIfPresentLetter = new GenericDeadLetter(TEST_SEQUENCE_ID, TEST_EVENT);
        GenericDeadLetter expectedEnqueuedLetter = new GenericDeadLetter(TEST_SEQUENCE_ID, TEST_EVENT, (Throwable)testCause);
        ((EventMessageHandler)Mockito.doThrow((Throwable[])new Throwable[]{testCause}).when((Object)this.handler)).handle(TEST_EVENT);
        Mockito.when((Object)this.queue.enqueueIfPresent(Mockito.any(), (Supplier)Mockito.any())).thenReturn((Object)false);
        this.testSubject.handle(TEST_EVENT, Segment.ROOT_SEGMENT);
        ((SequencingPolicy)Mockito.verify(this.sequencingPolicy, (VerificationMode)Mockito.times((int)2))).getSequenceIdentifierFor(TEST_EVENT);
        ((EventMessageHandler)Mockito.verify((Object)this.handler)).handle(TEST_EVENT);
        ArgumentCaptor enqueueIfPresentCaptor = ArgumentCaptor.forClass(Supplier.class);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).enqueueIfPresent(Mockito.eq((Object)TEST_SEQUENCE_ID), (Supplier)enqueueIfPresentCaptor.capture());
        DeadLetteringEventHandlerInvokerTest.assertLetter(expectedIfPresentLetter, (DeadLetter)((Supplier)enqueueIfPresentCaptor.getValue()).get());
        ArgumentCaptor policyCaptor = ArgumentCaptor.forClass(DeadLetter.class);
        ((EnqueuePolicy)Mockito.verify(this.enqueuePolicy)).decide((DeadLetter)policyCaptor.capture(), (Throwable)Mockito.eq((Object)testCause));
        DeadLetteringEventHandlerInvokerTest.assertLetter(expectedEnqueuedLetter, (DeadLetter)policyCaptor.getValue());
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue, (VerificationMode)Mockito.never())).enqueue(Mockito.eq((Object)TEST_SEQUENCE_ID), (DeadLetter)Mockito.any());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.transactionManager});
    }

    @Test
    void handleMethodDoesNotHandleEventOnDelegateWhenEnqueueIfPresentReturnsTrue() throws Exception {
        Mockito.when((Object)this.queue.enqueueIfPresent(Mockito.any(), (Supplier)Mockito.any())).thenReturn((Object)true);
        this.testSubject.handle(TEST_EVENT, Segment.ROOT_SEGMENT);
        ((SequencingPolicy)Mockito.verify(this.sequencingPolicy, (VerificationMode)Mockito.times((int)2))).getSequenceIdentifierFor(TEST_EVENT);
        ((EventMessageHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).handle(TEST_EVENT);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue, (VerificationMode)Mockito.never())).enqueue(TEST_SEQUENCE_ID, TEST_DEAD_LETTER);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.transactionManager});
    }

    @Test
    void performResetOnlyInvokesParentWhenAllowResetSetToFalse() {
        this.setTestSubject(this.createTestSubject(builder -> builder.allowReset(false)));
        this.testSubject.performReset();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.queue});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.transactionManager});
        ((EventMessageHandler)Mockito.verify((Object)this.handler)).prepareReset(null);
    }

    @Test
    void performResetClearsOutTheQueueWhenAllowResetSetToTrue() {
        this.setTestSubject(this.createTestSubject(builder -> builder.allowReset(true)));
        this.testSubject.performReset();
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).clear();
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).executeInTransaction((Runnable)Mockito.any());
        ((EventMessageHandler)Mockito.verify((Object)this.handler)).prepareReset(null);
    }

    @Test
    void performResetWithContextOnlyInvokesParentForAllowResetSetToFalse() {
        this.setTestSubject(this.createTestSubject(builder -> builder.allowReset(false)));
        String testContext = "some-reset-context";
        this.testSubject.performReset((Object)testContext);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.queue});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.transactionManager});
        ((EventMessageHandler)Mockito.verify((Object)this.handler)).prepareReset((Object)testContext);
    }

    @Test
    void performResetWithContextClearsOutTheQueueForAllowResetSetToTrue() {
        this.setTestSubject(this.createTestSubject(builder -> builder.allowReset(true)));
        String testContext = "some-reset-context";
        this.testSubject.performReset((Object)testContext);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).clear();
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).executeInTransaction((Runnable)Mockito.any());
        ((EventMessageHandler)Mockito.verify((Object)this.handler)).prepareReset((Object)testContext);
    }

    @Test
    void processAnyLettersReturnsFalseWhenFirstInvocationReturnsFalse() {
        Mockito.when((Object)this.queue.process((Predicate)Mockito.any(), (Function)Mockito.any())).thenReturn((Object)false);
        boolean result = this.testSubject.processAny();
        Assertions.assertFalse((boolean)result);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).startTransaction();
        ArgumentCaptor filterCaptor = ArgumentCaptor.forClass(Predicate.class);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).process((Predicate)filterCaptor.capture(), (Function)Mockito.any());
        Predicate letterFilter = (Predicate)filterCaptor.getValue();
        Assertions.assertTrue((boolean)letterFilter.test(null));
    }

    @Test
    void processAnyLettersReturnsTrueWhenFirstInvocationReturnsTrue() {
        GenericDeadLetter testDeadLetter = new GenericDeadLetter((Object)"expectedIdentifier", (Message)GenericEventMessage.asEventMessage((Object)"payload"));
        Mockito.when((Object)this.queue.process((Predicate)Mockito.any(), (Function)Mockito.any())).thenReturn((Object)true).thenReturn((Object)false);
        boolean result = this.testSubject.processAny();
        Assertions.assertTrue((boolean)result);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).startTransaction();
        ArgumentCaptor filterCaptor = ArgumentCaptor.forClass(Predicate.class);
        ArgumentCaptor taskFilterCaptor = ArgumentCaptor.forClass(Function.class);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).process((Predicate)filterCaptor.capture(), (Function)taskFilterCaptor.capture());
        ((Function)taskFilterCaptor.getAllValues().get(0)).apply(testDeadLetter);
        filterCaptor.getAllValues().forEach(letterFilter -> Assertions.assertTrue((boolean)letterFilter.test(null)));
    }

    @Test
    void processLettersMatchingSequenceReturnsFalseWhenFirstInvocationReturnsFalse() {
        AtomicBoolean filterInvoked = new AtomicBoolean();
        Predicate<DeadLetter> testFilter = letter -> {
            filterInvoked.set(true);
            return true;
        };
        Mockito.when((Object)this.queue.process((Predicate)Mockito.any(), (Function)Mockito.any())).thenReturn((Object)false);
        boolean result = this.testSubject.process(testFilter);
        Assertions.assertFalse((boolean)result);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).startTransaction();
        ArgumentCaptor filterCaptor = ArgumentCaptor.forClass(Predicate.class);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).process((Predicate)filterCaptor.capture(), (Function)Mockito.any());
        Predicate letterFilter = (Predicate)filterCaptor.getValue();
        Assertions.assertTrue((boolean)letterFilter.test(null));
        Assertions.assertTrue((boolean)filterInvoked.get());
    }

    @Test
    void processLettersMatchingSequenceReturnsTrueWhenFirstInvocationReturnsTrue() {
        GenericDeadLetter testDeadLetter = new GenericDeadLetter((Object)"expectedIdentifier", (Message)GenericEventMessage.asEventMessage((Object)"payload"));
        AtomicBoolean filterInvoked = new AtomicBoolean();
        Predicate<DeadLetter> testFilter = letter -> {
            filterInvoked.set(true);
            return true;
        };
        Mockito.when((Object)this.queue.process((Predicate)Mockito.any(), (Function)Mockito.any())).thenReturn((Object)true).thenReturn((Object)false);
        boolean result = this.testSubject.process(testFilter);
        Assertions.assertTrue((boolean)result);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).startTransaction();
        ArgumentCaptor letterFilterCaptor = ArgumentCaptor.forClass(Predicate.class);
        ArgumentCaptor taskFilterCaptor = ArgumentCaptor.forClass(Function.class);
        ((SequencedDeadLetterQueue)Mockito.verify(this.queue)).process((Predicate)letterFilterCaptor.capture(), (Function)taskFilterCaptor.capture());
        ((Function)taskFilterCaptor.getAllValues().get(0)).apply(testDeadLetter);
        letterFilterCaptor.getAllValues().forEach(letterFilter -> Assertions.assertTrue((boolean)letterFilter.test(null)));
        Assertions.assertTrue((boolean)filterInvoked.get());
    }

    @Test
    void buildWithNullDeadLetterQueueThrowsAxonConfigurationException() {
        DeadLetteringEventHandlerInvoker.Builder builderTestSubject = DeadLetteringEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.queue(null));
    }

    @Test
    void buildWithoutDeadLetterQueueThrowsAxonConfigurationException() {
        DeadLetteringEventHandlerInvoker.Builder builderTestSubject = DeadLetteringEventHandlerInvoker.builder().transactionManager(NoTransactionManager.instance());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((DeadLetteringEventHandlerInvoker.Builder)builderTestSubject).build());
    }

    @Test
    void buildWithNullEnqueuePolicyThrowsAxonConfigurationException() {
        DeadLetteringEventHandlerInvoker.Builder builderTestSubject = DeadLetteringEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.enqueuePolicy(null));
    }

    @Test
    void buildWithNullTransactionManagerThrowsAxonConfigurationException() {
        DeadLetteringEventHandlerInvoker.Builder builderTestSubject = DeadLetteringEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.transactionManager(null));
    }

    @Test
    void buildWithoutTransactionManagerThrowsAxonConfigurationException() {
        DeadLetteringEventHandlerInvoker.Builder builderTestSubject = DeadLetteringEventHandlerInvoker.builder().queue(this.queue);
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((DeadLetteringEventHandlerInvoker.Builder)builderTestSubject).build());
    }

    @Test
    void buildWithNullListenerInvocationErrorHandlerThrowsAxonConfigurationException() {
        DeadLetteringEventHandlerInvoker.Builder builderTestSubject = DeadLetteringEventHandlerInvoker.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> {
            DeadLetteringEventHandlerInvoker.Builder cfr_ignored_0 = (DeadLetteringEventHandlerInvoker.Builder)builderTestSubject.listenerInvocationErrorHandler(null);
        });
    }

    private static void assertLetter(DeadLetter<? extends EventMessage<?>> expected, DeadLetter<? extends EventMessage<?>> result) {
        Assertions.assertEquals((Object)expected.message(), (Object)result.message());
        Assertions.assertEquals((Object)expected.cause(), (Object)result.cause());
        Assertions.assertEquals((Object)expected.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)expected.lastTouched(), (Object)result.lastTouched());
        Assertions.assertEquals((Object)expected.diagnostics(), (Object)result.diagnostics());
    }

    private static class StubTransactionManager
    implements TransactionManager {
        private StubTransactionManager() {
        }

        public Transaction startTransaction() {
            return NoTransactionManager.INSTANCE.startTransaction();
        }
    }
}

