/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.gateway;

import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class DefaultEventGatewayTest {
    private DefaultEventGateway testSubject;
    private EventBus mockEventBus;
    private MessageDispatchInterceptor mockEventMessageTransformer;

    DefaultEventGatewayTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.mockEventBus = (EventBus)Mockito.mock(EventBus.class);
        this.mockEventMessageTransformer = (MessageDispatchInterceptor)Mockito.mock(MessageDispatchInterceptor.class);
        Mockito.when((Object)this.mockEventMessageTransformer.handle((Message)ArgumentMatchers.isA(EventMessage.class))).thenAnswer(invocation -> invocation.getArguments()[0]);
        this.testSubject = DefaultEventGateway.builder().eventBus(this.mockEventBus).dispatchInterceptors(new MessageDispatchInterceptor[]{this.mockEventMessageTransformer}).build();
    }

    @Test
    void publish() {
        this.testSubject.publish((Object)"Event1");
        ((EventBus)Mockito.verify((Object)this.mockEventBus)).publish(new EventMessage[]{(EventMessage)Mockito.argThat(msg -> msg.getPayload().equals("Event1"))});
        ((MessageDispatchInterceptor)Mockito.verify((Object)this.mockEventMessageTransformer)).handle((Message)Mockito.argThat(msg -> msg.getPayload().equals("Event1")));
        this.testSubject.publish(new Object[]{"Event2", "Event3"});
        ((EventBus)Mockito.verify((Object)this.mockEventBus)).publish(new EventMessage[]{(EventMessage)Mockito.argThat(msg -> msg.getPayload().equals("Event2"))});
        ((MessageDispatchInterceptor)Mockito.verify((Object)this.mockEventMessageTransformer)).handle((Message)Mockito.argThat(msg -> msg.getPayload().equals("Event2")));
        ((EventBus)Mockito.verify((Object)this.mockEventBus)).publish(new EventMessage[]{(EventMessage)Mockito.argThat(msg -> msg.getPayload().equals("Event3"))});
        ((MessageDispatchInterceptor)Mockito.verify((Object)this.mockEventMessageTransformer)).handle((Message)Mockito.argThat(msg -> msg.getPayload().equals("Event3")));
    }
}

