/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.pooled;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackerStatus;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.pooled.SplitTask;
import org.axonframework.eventhandling.pooled.WorkPackage;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SplitTaskTest {
    private static final String PROCESSOR_NAME = "test";
    private static final int SEGMENT_ID = Segment.ROOT_SEGMENT.getSegmentId();
    private CompletableFuture<Boolean> result;
    private final Map<Integer, WorkPackage> workPackages = new HashMap<Integer, WorkPackage>();
    private final TokenStore tokenStore = (TokenStore)Mockito.mock(TokenStore.class);
    private SplitTask testSubject;
    private final WorkPackage workPackage = (WorkPackage)Mockito.mock(WorkPackage.class);

    SplitTaskTest() {
    }

    @BeforeEach
    void setUp() {
        this.result = new CompletableFuture();
        this.testSubject = new SplitTask(this.result, PROCESSOR_NAME, SEGMENT_ID, this.workPackages, this.tokenStore, NoTransactionManager.instance());
    }

    @Test
    void runSplitsSegmentFromWorkPackage() throws ExecutionException, InterruptedException {
        Segment testSegmentToSplit = Segment.ROOT_SEGMENT;
        GlobalSequenceTrackingToken testTokenToSplit = new GlobalSequenceTrackingToken(0L);
        TrackerStatus[] expectedTokens = TrackerStatus.split((Segment)testSegmentToSplit, (TrackingToken)testTokenToSplit);
        TrackerStatus expectedOriginal = expectedTokens[0];
        TrackerStatus expectedSplit = expectedTokens[1];
        Mockito.when((Object)this.workPackage.segment()).thenReturn((Object)testSegmentToSplit);
        Mockito.when((Object)this.workPackage.abort(null)).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, SEGMENT_ID)).thenReturn((Object)testTokenToSplit);
        this.workPackages.put(SEGMENT_ID, this.workPackage);
        this.testSubject.run();
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).initializeSegment(expectedSplit.getTrackingToken(), PROCESSOR_NAME, expectedSplit.getSegment().getSegmentId());
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).releaseClaim(PROCESSOR_NAME, expectedOriginal.getSegment().getSegmentId());
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.get());
    }

    @Test
    void runSplitsSegmentAfterClaiming() throws ExecutionException, InterruptedException {
        int[] testSegmentIds = new int[]{SEGMENT_ID};
        Segment testSegmentToSplit = Segment.computeSegment((int)SEGMENT_ID, (int[])testSegmentIds);
        GlobalSequenceTrackingToken testTokenToSplit = new GlobalSequenceTrackingToken(0L);
        TrackerStatus[] expectedTokens = TrackerStatus.split((Segment)testSegmentToSplit, (TrackingToken)testTokenToSplit);
        TrackerStatus expectedOriginal = expectedTokens[0];
        TrackerStatus expectedSplit = expectedTokens[1];
        Mockito.when((Object)this.tokenStore.fetchSegments(PROCESSOR_NAME)).thenReturn((Object)testSegmentIds);
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, SEGMENT_ID)).thenReturn((Object)testTokenToSplit);
        this.testSubject.run();
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).initializeSegment(expectedSplit.getTrackingToken(), PROCESSOR_NAME, expectedSplit.getSegment().getSegmentId());
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).releaseClaim(PROCESSOR_NAME, expectedOriginal.getSegment().getSegmentId());
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.get());
    }

    @Test
    void runCompletesExceptionallyThroughUnableToClaimTokenException() {
        Mockito.when((Object)this.tokenStore.fetchSegments(PROCESSOR_NAME)).thenReturn((Object)new int[]{SEGMENT_ID});
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, SEGMENT_ID)).thenThrow(new Throwable[]{new UnableToClaimTokenException("some exception")});
        this.testSubject.run();
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.isCompletedExceptionally());
        Assertions.assertThrows(ExecutionException.class, () -> this.result.get());
    }

    @Test
    void runCompletesExceptionallyThroughOtherException() {
        Mockito.when((Object)this.tokenStore.fetchSegments(PROCESSOR_NAME)).thenThrow(new Throwable[]{new IllegalStateException("some exception")});
        this.testSubject.run();
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.isCompletedExceptionally());
        Assertions.assertThrows(ExecutionException.class, () -> this.result.get());
    }

    @Test
    void description() {
        String result = this.testSubject.getDescription();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.contains("Split"));
    }
}

