/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.eventhandling.AllowReplay;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.DisallowReplay;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.TrackingToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReplayAwareMessageHandlerWrapperWithDisallowReplayTest {
    private SomeHandler handler;
    private SomeMethodHandler methodHandler;
    private AnnotationEventHandlerAdapter testSubject;
    private AnnotationEventHandlerAdapter testMethodSubject;
    private ReplayToken replayToken;

    ReplayAwareMessageHandlerWrapperWithDisallowReplayTest() {
    }

    @BeforeEach
    void setUp() {
        this.handler = new SomeHandler();
        this.methodHandler = new SomeMethodHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)this.handler);
        this.testMethodSubject = new AnnotationEventHandlerAdapter((Object)this.methodHandler);
        this.replayToken = new ReplayToken((TrackingToken)new GlobalSequenceTrackingToken(1L));
    }

    @Test
    void invokeWithReplayTokens() throws Exception {
        GenericTrackedEventMessage stringEvent = new GenericTrackedEventMessage((TrackingToken)this.replayToken, GenericEventMessage.asEventMessage((Object)"1"));
        GenericTrackedEventMessage longEvent = new GenericTrackedEventMessage((TrackingToken)this.replayToken, GenericEventMessage.asEventMessage((Object)1L));
        Assertions.assertTrue((boolean)this.testSubject.canHandle((EventMessage)stringEvent));
        Assertions.assertTrue((boolean)this.testMethodSubject.canHandle((EventMessage)stringEvent));
        Assertions.assertTrue((boolean)this.testSubject.canHandle((EventMessage)longEvent));
        Assertions.assertTrue((boolean)this.testMethodSubject.canHandle((EventMessage)longEvent));
        this.testSubject.handle((EventMessage)stringEvent);
        this.testMethodSubject.handle((EventMessage)stringEvent);
        this.testSubject.handle((EventMessage)longEvent);
        this.testMethodSubject.handle((EventMessage)longEvent);
        Assertions.assertTrue((boolean)this.handler.receivedLongs.isEmpty());
        Assertions.assertTrue((boolean)this.methodHandler.receivedLongs.isEmpty());
        Assertions.assertFalse((boolean)this.handler.receivedStrings.isEmpty());
        Assertions.assertFalse((boolean)this.methodHandler.receivedStrings.isEmpty());
    }

    private static class SomeMethodHandler {
        private List<String> receivedStrings = new ArrayList<String>();
        private List<Long> receivedLongs = new ArrayList<Long>();

        private SomeMethodHandler() {
        }

        @AllowReplay
        @EventHandler
        public void handle(String event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedStrings.add(event);
        }

        @EventHandler
        @DisallowReplay
        public void handle(Long event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedLongs.add(event);
        }
    }

    @DisallowReplay
    private static class SomeHandler {
        private List<String> receivedStrings = new ArrayList<String>();
        private List<Long> receivedLongs = new ArrayList<Long>();

        private SomeHandler() {
        }

        @AllowReplay
        @EventHandler
        public void handle(String event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedStrings.add(event);
        }

        @EventHandler
        public void handle(Long event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedLongs.add(event);
        }
    }
}

