/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.replay.ReplayContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReplayContextParameterResolverFactoryTest {
    private final MyResetContext resetContext = new MyResetContext(Arrays.asList(2L, 3L));
    private SomeHandler handler;
    private AnnotationEventHandlerAdapter testSubject;
    private ReplayToken replayToken;
    private GlobalSequenceTrackingToken regularToken;

    ReplayContextParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.handler = new SomeHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)this.handler);
        this.regularToken = new GlobalSequenceTrackingToken(1L);
        this.replayToken = (ReplayToken)ReplayToken.createReplayToken((TrackingToken)this.regularToken, (TrackingToken)new GlobalSequenceTrackingToken(0L), (Object)this.resetContext);
    }

    @Test
    void resolvesIfMatching() throws Exception {
        GenericTrackedEventMessage replayEvent = new GenericTrackedEventMessage((TrackingToken)this.replayToken, GenericEventMessage.asEventMessage((Object)1L));
        GenericTrackedEventMessage liveEvent = new GenericTrackedEventMessage((TrackingToken)this.regularToken, GenericEventMessage.asEventMessage((Object)2L));
        Assertions.assertTrue((boolean)this.testSubject.canHandle((EventMessage)replayEvent));
        Assertions.assertTrue((boolean)this.testSubject.canHandle((EventMessage)liveEvent));
        this.testSubject.handle(this.createMessage(1L, true));
        this.testSubject.handle(this.createMessage(2L, true));
        this.testSubject.handle(this.createMessage(3L, true));
        this.testSubject.handle(this.createMessage(4L, false));
        Assertions.assertEquals(Arrays.asList(1L, 2L, 3L, 4L), (Object)this.handler.receivedLongs);
        Assertions.assertEquals(Arrays.asList(2L, 3L), (Object)this.handler.receivedInReplay);
    }

    private TrackedEventMessage<Object> createMessage(Long position, boolean replay) {
        return new GenericTrackedEventMessage(this.createToken(position, replay), GenericEventMessage.asEventMessage((Object)position));
    }

    private TrackingToken createToken(Long position, boolean replay) {
        if (replay) {
            return ReplayToken.createReplayToken((TrackingToken)new GlobalSequenceTrackingToken(position + 1L), (TrackingToken)new GlobalSequenceTrackingToken(position.longValue()), (Object)this.resetContext);
        }
        return new GlobalSequenceTrackingToken(position.longValue());
    }

    private static class MyResetContext {
        private final List<Long> sequences;

        public MyResetContext(List<Long> sequences) {
            this.sequences = sequences;
        }
    }

    private static class SomeHandler {
        private List<Long> receivedLongs = new ArrayList<Long>();
        private List<Long> receivedInReplay = new ArrayList<Long>();

        private SomeHandler() {
        }

        @EventHandler
        public void handle(Long event, TrackingToken token, @ReplayContext MyResetContext resetContext) {
            boolean tokenMatchesFilter;
            this.receivedLongs.add(event);
            long position = token.position().orElse(0L);
            boolean bl = tokenMatchesFilter = resetContext != null && resetContext.sequences.contains(position);
            if (tokenMatchesFilter) {
                this.receivedInReplay.add(event);
            }
        }
    }
}

