/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.correlation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.correlation.SimpleCorrelationDataProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SimpleCorrelationDataProviderTest {
    SimpleCorrelationDataProviderTest() {
    }

    @Test
    void resolveCorrelationData() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("key1", "value1");
        metaData.put("key2", "value2");
        metaData.put("key3", "value3");
        GenericMessage message = new GenericMessage((Object)"payload", metaData);
        Assertions.assertEquals(Collections.singletonMap("key1", "value1"), (Object)new SimpleCorrelationDataProvider(new String[]{"key1"}).correlationDataFor((Message)message));
        Map actual2 = new SimpleCorrelationDataProvider(new String[]{"key1", "key2", "noExist", null}).correlationDataFor((Message)message);
        Assertions.assertEquals((Object)"value1", actual2.get("key1"));
        Assertions.assertEquals((Object)"value2", actual2.get("key2"));
    }
}

