/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import java.util.Arrays;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CorrelationDataInterceptorTest {
    private CorrelationDataInterceptor<Message<?>> subject;
    private UnitOfWork<Message<?>> mockUnitOfWork;
    private InterceptorChain mockInterceptorChain;
    private CorrelationDataProvider mockProvider1;
    private CorrelationDataProvider mockProvider2;

    CorrelationDataInterceptorTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockProvider1 = (CorrelationDataProvider)Mockito.mock(CorrelationDataProvider.class);
        this.mockProvider2 = (CorrelationDataProvider)Mockito.mock(CorrelationDataProvider.class);
        this.subject = new CorrelationDataInterceptor(Arrays.asList(this.mockProvider1, this.mockProvider2));
        this.mockUnitOfWork = (UnitOfWork)Mockito.mock(UnitOfWork.class);
        this.mockInterceptorChain = (InterceptorChain)Mockito.mock(InterceptorChain.class);
    }

    @Test
    void attachesCorrelationDataProvidersToUnitOfWork() throws Exception {
        this.subject.handle(this.mockUnitOfWork, this.mockInterceptorChain);
        ((UnitOfWork)Mockito.verify(this.mockUnitOfWork)).registerCorrelationDataProvider(this.mockProvider1);
        ((UnitOfWork)Mockito.verify(this.mockUnitOfWork)).registerCorrelationDataProvider(this.mockProvider2);
        ((InterceptorChain)Mockito.verify((Object)this.mockInterceptorChain)).proceed();
    }
}

