/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import java.lang.reflect.Field;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.slf4j.Log4jLogger;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.interceptors.LoggingInterceptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

class LoggingInterceptorTest {
    private LoggingInterceptor<Message<?>> testSubject;
    private ExtendedLogger mockLogger;
    private InterceptorChain interceptorChain;
    private UnitOfWork<Message<?>> unitOfWork;

    LoggingInterceptorTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testSubject = new LoggingInterceptor();
        Log4jLogger logger = (Log4jLogger)LoggerFactory.getLogger(LoggingInterceptor.class);
        Field loggerField = logger.getClass().getDeclaredField("logger");
        ReflectionUtils.makeAccessible((Field)loggerField);
        this.mockLogger = (ExtendedLogger)Mockito.mock(ExtendedLogger.class);
        loggerField.set(logger, this.mockLogger);
        this.interceptorChain = (InterceptorChain)Mockito.mock(InterceptorChain.class);
        this.unitOfWork = new DefaultUnitOfWork((Message)new GenericMessage((Object)new StubMessage()));
    }

    @Test
    void constructorWithCustomLogger() throws Exception {
        this.testSubject = new LoggingInterceptor("my.custom.logger");
        Field field = this.testSubject.getClass().getDeclaredField("logger");
        field.setAccessible(true);
        Logger logger = (Logger)field.get(this.testSubject);
        Assertions.assertEquals((Object)"my.custom.logger", (Object)logger.getName());
    }

    @Test
    void handlerInterceptorWithIncomingLoggingNullReturnValue() throws Exception {
        Mockito.when((Object)this.mockLogger.isInfoEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.interceptorChain.proceed()).thenReturn(null);
        this.testSubject.handle(this.unitOfWork, this.interceptorChain);
        ((ExtendedLogger)Mockito.verify((Object)this.mockLogger)).logIfEnabled(Mockito.anyString(), (Level)Mockito.eq((Object)Level.INFO), (Marker)Mockito.isNull(), Mockito.anyString(), (Object)Mockito.contains((String)"StubMessage"));
        ((ExtendedLogger)Mockito.verify((Object)this.mockLogger)).logIfEnabled(Mockito.anyString(), (Level)Mockito.eq((Object)Level.INFO), (Marker)Mockito.isNull(), Mockito.anyString(), (Object)Mockito.contains((String)"StubMessage"), (Object)Mockito.contains((String)"null"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
    }

    @Test
    void handlerInterceptorWithSuccessfulExecutionVoidReturnValue() throws Exception {
        Mockito.when((Object)this.mockLogger.isInfoEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.interceptorChain.proceed()).thenReturn(null);
        this.testSubject.handle(this.unitOfWork, this.interceptorChain);
        ((ExtendedLogger)Mockito.verify((Object)this.mockLogger)).logIfEnabled(Mockito.anyString(), (Level)Mockito.eq((Object)Level.INFO), (Marker)Mockito.isNull(), Mockito.anyString(), (Object)Mockito.contains((String)"StubMessage"));
        ((ExtendedLogger)Mockito.verify((Object)this.mockLogger)).logIfEnabled(Mockito.anyString(), (Level)Mockito.eq((Object)Level.INFO), (Marker)Mockito.isNull(), Mockito.anyString(), (Object)Mockito.contains((String)"StubMessage"), (Object)Mockito.contains((String)"null"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
    }

    @Test
    void handlerInterceptorWithSuccessfulExecutionCustomReturnValue() throws Exception {
        Mockito.when((Object)this.interceptorChain.proceed()).thenReturn((Object)new StubResponse());
        Mockito.when((Object)this.mockLogger.isInfoEnabled()).thenReturn((Object)true);
        this.testSubject.handle(this.unitOfWork, this.interceptorChain);
        ((ExtendedLogger)Mockito.verify((Object)this.mockLogger)).logIfEnabled(Mockito.anyString(), (Level)Mockito.eq((Object)Level.INFO), (Marker)Mockito.isNull(), Mockito.anyString(), (Object)Mockito.contains((String)"StubMessage"));
        ((ExtendedLogger)Mockito.verify((Object)this.mockLogger)).logIfEnabled(Mockito.anyString(), (Level)Mockito.eq((Object)Level.INFO), (Marker)Mockito.isNull(), Mockito.anyString(), (Object)Mockito.contains((String)"StubMessage"), (Object)Mockito.contains((String)"StubResponse"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
    }

    @Test
    void handlerInterceptorWithFailedExecution() throws Exception {
        RuntimeException exception = new RuntimeException();
        Mockito.when((Object)this.interceptorChain.proceed()).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)this.mockLogger.isInfoEnabled()).thenReturn((Object)true);
        try {
            this.testSubject.handle(this.unitOfWork, this.interceptorChain);
            Assertions.fail((String)"Expected exception to be propagated");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((ExtendedLogger)Mockito.verify((Object)this.mockLogger)).logIfEnabled(Mockito.anyString(), (Level)Mockito.eq((Object)Level.INFO), (Marker)Mockito.isNull(), Mockito.anyString(), (Object)Mockito.contains((String)"StubMessage"));
        ((ExtendedLogger)Mockito.verify((Object)this.mockLogger)).logIfEnabled(Mockito.anyString(), (Level)Mockito.eq((Object)Level.WARN), (Marker)Mockito.isNull(), (String)AdditionalMatchers.and((Object)Mockito.contains((String)"failed"), (Object)Mockito.contains((String)"StubMessage")), (Throwable)Mockito.eq((Object)exception));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
    }

    @Test
    void dispatchInterceptorLogging() {
        Mockito.when((Object)this.mockLogger.isInfoEnabled()).thenReturn((Object)true);
        this.testSubject.handle((Message)new GenericMessage((Object)new StubMessage()));
        ((ExtendedLogger)Mockito.verify((Object)this.mockLogger)).logIfEnabled(Mockito.anyString(), (Level)Mockito.eq((Object)Level.INFO), (Marker)Mockito.isNull(), Mockito.anyString(), (Object)Mockito.contains((String)"StubMessage"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
    }

    private static class StubResponse {
        private StubResponse() {
        }
    }

    private static class StubMessage {
        private StubMessage() {
        }
    }
}

