/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SerializedMessageTest {
    private final SerializedObject<String> serializedPayload = new SimpleSerializedObject((Object)"serializedPayload", String.class, "java.lang.Object", "1");
    private final SerializedObject<String> serializedMetaData = new SerializedMetaData((Object)"serializedMetaData", String.class);
    private final Object deserializedPayload = new Object();
    private final MetaData deserializedMetaData = MetaData.emptyInstance();
    private final Serializer serializer = (Serializer)Mockito.mock(Serializer.class);
    private final String eventId = "eventId";

    SerializedMessageTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.serializer.deserialize(this.serializedMetaData)).thenReturn((Object)this.deserializedMetaData);
        Mockito.when((Object)this.serializer.deserialize(this.serializedPayload)).thenReturn(this.deserializedPayload);
        Mockito.when((Object)this.serializer.classForType((SerializedType)Mockito.isA(SerializedType.class))).thenReturn(Object.class);
        Mockito.when((Object)this.serializer.getConverter()).thenReturn((Object)new ChainingConverter());
    }

    @Test
    void constructorLeavesSerializedObjectsSerialized() {
        SerializedMessage testSubject = new SerializedMessage("eventId", this.serializedPayload, this.serializedMetaData, this.serializer);
        Assertions.assertEquals(Object.class, (Object)testSubject.getPayloadType());
        Assertions.assertFalse((boolean)testSubject.isPayloadDeserialized());
        Assertions.assertEquals(Object.class, testSubject.getPayload().getClass());
        Assertions.assertTrue((boolean)testSubject.isPayloadDeserialized());
        Assertions.assertFalse((boolean)testSubject.isMetaDataDeserialized());
        Assertions.assertSame((Object)MetaData.emptyInstance(), (Object)testSubject.getMetaData());
        Assertions.assertTrue((boolean)testSubject.isMetaDataDeserialized());
    }

    @Test
    void withMetaDataReplacesOriginalMetaData() {
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        Mockito.when((Object)this.serializer.deserialize(this.serializedMetaData)).thenReturn((Object)metaData);
        SerializedMessage testSubject = new SerializedMessage("eventId", this.serializedPayload, this.serializedMetaData, this.serializer);
        SerializedMessage resultOne = testSubject.withMetaData(MetaData.emptyInstance());
        SerializedMessage resultTwo = testSubject.withMetaData(MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)0, (int)resultOne.getMetaData().size());
        Assertions.assertEquals((int)1, (int)resultTwo.getMetaData().size());
    }

    @Test
    void andMetaDataAppendsToOriginalMetaData() {
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        Mockito.when((Object)this.serializer.deserialize(this.serializedMetaData)).thenReturn((Object)metaData);
        SerializedMessage testSubject = new SerializedMessage("eventId", this.serializedPayload, this.serializedMetaData, this.serializer);
        Message resultOne = testSubject.andMetaData((Map)MetaData.emptyInstance());
        Assertions.assertEquals((int)1, (int)resultOne.getMetaData().size());
        Assertions.assertEquals((Object)"value", (Object)resultOne.getMetaData().get((Object)"key"));
        Message resultTwo = testSubject.andMetaData((Map)MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)1, (int)resultTwo.getMetaData().size());
        Assertions.assertEquals((Object)"otherValue", (Object)resultTwo.getMetaData().get((Object)"key"));
    }

    @Test
    void serializePayloadImmediatelyAfterConstructionReturnsOriginalPayload() {
        SerializedMessage testSubject = new SerializedMessage("eventId", this.serializedPayload, this.serializedMetaData, this.serializer);
        SerializedObject result = testSubject.serializePayload(this.serializer, byte[].class);
        Assertions.assertArrayEquals((byte[])"serializedPayload".getBytes(StandardCharsets.UTF_8), (byte[])((byte[])result.getData()));
        ((Serializer)Mockito.verify((Object)this.serializer, (VerificationMode)Mockito.atLeast((int)0))).classForType((SerializedType)Mockito.isA(SerializedType.class));
        ((Serializer)Mockito.verify((Object)this.serializer, (VerificationMode)Mockito.atLeast((int)0))).getConverter();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.serializer});
    }

    @Test
    void serializeMetaDataImmediatelyAfterConstructionReturnsOriginalMetaData() {
        SerializedMessage testSubject = new SerializedMessage("eventId", this.serializedPayload, this.serializedMetaData, this.serializer);
        SerializedObject result = testSubject.serializeMetaData(this.serializer, byte[].class);
        Assertions.assertArrayEquals((byte[])"serializedMetaData".getBytes(StandardCharsets.UTF_8), (byte[])((byte[])result.getData()));
        ((Serializer)Mockito.verify((Object)this.serializer, (VerificationMode)Mockito.atLeast((int)0))).classForType((SerializedType)Mockito.isA(SerializedType.class));
        ((Serializer)Mockito.verify((Object)this.serializer, (VerificationMode)Mockito.atLeast((int)0))).getConverter();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.serializer});
    }

    @Test
    void rethrowSerializationExceptionOnGetPayload() {
        SerializationException serializationException = new SerializationException("test message");
        Mockito.when((Object)this.serializer.deserialize(this.serializedMetaData)).thenThrow(new Throwable[]{serializationException});
        Mockito.when((Object)this.serializer.deserialize(this.serializedPayload)).thenThrow(new Throwable[]{serializationException});
        SerializedMessage testSubject = new SerializedMessage("eventId", this.serializedPayload, this.serializedMetaData, this.serializer);
        SerializationException result = (SerializationException)Assertions.assertThrows(SerializationException.class, () -> ((SerializedMessage)testSubject).getPayload());
        Assertions.assertEquals((Object)"Error while deserializing payload of message eventId", (Object)result.getMessage());
        Assertions.assertSame((Object)serializationException, (Object)result.getCause());
    }

    @Test
    void rethrowSerializationExceptionOnGetMetaData() {
        SerializationException serializationException = new SerializationException("test message");
        Mockito.when((Object)this.serializer.deserialize(this.serializedMetaData)).thenThrow(new Throwable[]{serializationException});
        Mockito.when((Object)this.serializer.deserialize(this.serializedPayload)).thenThrow(new Throwable[]{serializationException});
        SerializedMessage testSubject = new SerializedMessage("eventId", this.serializedPayload, this.serializedMetaData, this.serializer);
        SerializationException result = (SerializationException)Assertions.assertThrows(SerializationException.class, () -> ((SerializedMessage)testSubject).getMetaData());
        Assertions.assertEquals((Object)"Error while deserializing meta data of message eventId", (Object)result.getMessage());
        Assertions.assertSame((Object)serializationException, (Object)result.getCause());
    }
}

