/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.beans.ConstructorProperties;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumSet;
import org.axonframework.serialization.JavaSerializer;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.json.JacksonSerializer;
import org.axonframework.serialization.xml.CompactDriver;
import org.axonframework.serialization.xml.XStreamSerializer;

public enum TestSerializer {
    JAVA{
        private final Serializer serializer = JavaSerializer.builder().build();

        @Override
        public Serializer getSerializer() {
            return this.serializer;
        }

        @Override
        protected String serialize(Object object) {
            return Base64.getEncoder().encodeToString((byte[])this.getSerializer().serialize(object, byte[].class).getData());
        }

        @Override
        protected <T> T deserialize(String serialized, Class<T> type) {
            return (T)this.getSerializer().deserialize(1.asSerializedData(Base64.getDecoder().decode(serialized), type));
        }
    }
    ,
    XSTREAM{
        private final Serializer serializer = this.createSerializer();

        private XStreamSerializer createSerializer() {
            return XStreamSerializer.builder().xStream(new XStream((HierarchicalStreamDriver)new CompactDriver())).build();
        }

        @Override
        public Serializer getSerializer() {
            return this.serializer;
        }
    }
    ,
    JACKSON{
        private final Serializer serializer = JacksonSerializer.defaultSerializer();

        @Override
        public Serializer getSerializer() {
            return this.serializer;
        }
    }
    ,
    JACKSON_ONLY_ACCEPT_CONSTRUCTOR_PARAMETERS{
        private final Serializer serializer = JacksonSerializer.builder().objectMapper(OnlyAcceptConstructorPropertiesAnnotation.attachTo(new ObjectMapper())).build();

        @Override
        public Serializer getSerializer() {
            return this.serializer;
        }
    };


    protected String serialize(Object object) {
        return new String((byte[])this.getSerializer().serialize(object, byte[].class).getData());
    }

    protected <T> T deserialize(String serialized, Class<T> type) {
        return (T)this.getSerializer().deserialize(TestSerializer.asSerializedData(serialized.getBytes(), type));
    }

    public abstract Serializer getSerializer();

    public <T> T serializeDeserialize(T object) {
        return (T)this.deserialize(this.serialize(object), object.getClass());
    }

    public static Collection<TestSerializer> all() {
        return EnumSet.allOf(TestSerializer.class);
    }

    static <T> SerializedObject<byte[]> asSerializedData(byte[] serialized, Class<T> type) {
        SimpleSerializedType serializedType = new SimpleSerializedType(type.getName(), null);
        return new SimpleSerializedObject((Object)serialized, byte[].class, (SerializedType)serializedType);
    }

    private static class OnlyAcceptConstructorPropertiesAnnotation
    extends JacksonAnnotationIntrospector {
        private static final long serialVersionUID = 1L;

        private OnlyAcceptConstructorPropertiesAnnotation() {
        }

        public static ObjectMapper attachTo(ObjectMapper objectMapper) {
            return objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new OnlyAcceptConstructorPropertiesAnnotation());
        }

        public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> config, Annotated annotated) {
            return annotated.hasAnnotation(ConstructorProperties.class) ? super.findCreatorAnnotation(config, annotated) : JsonCreator.Mode.DISABLED;
        }
    }
}

