/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jpa;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.TypedQuery;
import org.axonframework.common.transaction.TransactionManager;

public class PagingJpaQueryIterable<T, R>
implements Iterable<R> {
    private final int pageSize;
    private final Supplier<TypedQuery<T>> querySupplier;
    private final TransactionManager transactionManager;
    private final Function<T, R> lazyMappingFunction;

    public PagingJpaQueryIterable(int pageSize, TransactionManager transactionManager, Supplier<TypedQuery<T>> querySupplier, Function<T, R> lazyMappingFunction) {
        this.pageSize = pageSize;
        this.transactionManager = transactionManager;
        this.querySupplier = querySupplier;
        this.lazyMappingFunction = lazyMappingFunction;
    }

    @Override
    public Iterator<R> iterator() {
        return new PagingIterator();
    }

    public class PagingIterator
    implements Iterator<R> {
        private final Deque<T> queue = new ArrayDeque();
        private int page = 0;

        @Override
        public boolean hasNext() {
            this.refreshPageIfNecessary();
            return !this.queue.isEmpty();
        }

        @Override
        public R next() {
            this.refreshPageIfNecessary();
            Object pop = this.queue.pop();
            if (pop == null) {
                throw new NoSuchElementException();
            }
            return PagingJpaQueryIterable.this.lazyMappingFunction.apply(pop);
        }

        private void refreshPageIfNecessary() {
            if (!this.queue.isEmpty()) {
                return;
            }
            PagingJpaQueryIterable.this.transactionManager.executeInTransaction(() -> ((TypedQuery)PagingJpaQueryIterable.this.querySupplier.get()).setMaxResults(PagingJpaQueryIterable.this.pageSize).setFirstResult(this.page * PagingJpaQueryIterable.this.pageSize).getResultList().forEach(this.queue::offerLast));
            ++this.page;
        }
    }
}

