/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.axonframework.messaging.HandlerAttributes;

public class SimpleHandlerAttributes
implements HandlerAttributes {
    private final Map<String, Object> attributes;

    public SimpleHandlerAttributes(Map<String, Object> attributes) {
        this.attributes = new HashMap<String, Object>(attributes);
    }

    @Override
    public <R> R get(String attributeKey) {
        return (R)this.attributes.get(attributeKey);
    }

    @Override
    public Map<String, Object> getAll() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public boolean contains(String attributeKey) {
        return this.attributes.containsKey(attributeKey);
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public HandlerAttributes mergedWith(HandlerAttributes other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        HashMap<String, Object> combinedAttributes = new HashMap<String, Object>(this.getAll());
        combinedAttributes.putAll(other.getAll());
        return new SimpleHandlerAttributes(combinedAttributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleHandlerAttributes that = (SimpleHandlerAttributes)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.attributes);
    }

    public String toString() {
        return "SimpleHandlerAttributes{attributes=" + this.attributes + '}';
    }
}

