/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.axonframework.commandhandling.CurrentUnitOfWorkParameterResolverFactory;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CurrentUnitOfWorkParameterResolverFactoryTest {
    private CurrentUnitOfWorkParameterResolverFactory testSubject;
    private Method method;

    CurrentUnitOfWorkParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testSubject = new CurrentUnitOfWorkParameterResolverFactory();
        this.method = this.getClass().getMethod("equals", Object.class);
    }

    public void someMethod(UnitOfWork unitOfWork) {
    }

    @Test
    void createInstance() throws Exception {
        Method someMethod = this.getClass().getMethod("someMethod", UnitOfWork.class);
        Assertions.assertNull((Object)this.testSubject.createInstance((Executable)this.method, this.method.getParameters(), 0));
        Assertions.assertSame((Object)this.testSubject, (Object)this.testSubject.createInstance((Executable)someMethod, someMethod.getParameters(), 0));
    }

    @Test
    void resolveParameterValue() {
        DefaultUnitOfWork.startAndGet(null);
        try {
            Assertions.assertSame((Object)CurrentUnitOfWork.get(), (Object)this.testSubject.resolveParameterValue((Message)Mockito.mock(GenericCommandMessage.class)));
        }
        finally {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @Test
    void resolveParameterValueWithoutActiveUnitOfWork() {
        Assertions.assertNull((Object)this.testSubject.resolveParameterValue((Message)Mockito.mock(GenericCommandMessage.class)));
    }

    @Test
    void matches() {
        Assertions.assertTrue((boolean)this.testSubject.matches((Message)Mockito.mock(GenericCommandMessage.class)));
        DefaultUnitOfWork.startAndGet(null);
        try {
            Assertions.assertTrue((boolean)this.testSubject.matches((Message)Mockito.mock(Message.class)));
            Assertions.assertTrue((boolean)this.testSubject.matches((Message)Mockito.mock(EventMessage.class)));
            Assertions.assertTrue((boolean)this.testSubject.matches((Message)Mockito.mock(GenericEventMessage.class)));
            Assertions.assertTrue((boolean)this.testSubject.matches((Message)Mockito.mock(GenericCommandMessage.class)));
        }
        finally {
            CurrentUnitOfWork.get().rollback();
        }
    }
}

