/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolution;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.callbacks.NoOpCallback;
import org.axonframework.common.Registration;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SimpleCommandBusTest {
    private TestSpanFactory spanFactory;
    private SimpleCommandBus testSubject;

    SimpleCommandBusTest() {
    }

    @BeforeEach
    void setUp() {
        this.spanFactory = new TestSpanFactory();
        this.testSubject = SimpleCommandBus.builder().spanFactory((SpanFactory)this.spanFactory).build();
    }

    @AfterEach
    void tearDown() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @Test
    void dispatchCommandHandlerSubscribed() {
        this.testSubject.subscribe(String.class.getName(), (MessageHandler)new MyStringCommandHandler());
        this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"Say hi!"), (command, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                commandResultMessage.optionalExceptionResult().ifPresent(Throwable::printStackTrace);
                Assertions.fail((String)"Did not expect exception");
            }
            Assertions.assertEquals((Object)"Say hi!", (Object)((CommandMessage)commandResultMessage.getPayload()).getPayload());
        });
    }

    @Test
    void dispatchIsCorrectlyTraced() {
        this.testSubject.subscribe(String.class.getName(), (MessageHandler)new MyStringCommandHandler());
        this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"Say hi!"), (command, commandResultMessage) -> {
            this.spanFactory.verifySpanCompleted("SimpleCommandBus.dispatch");
            this.spanFactory.verifySpanPropagated("SimpleCommandBus.dispatch", (Message<?>)command);
            this.spanFactory.verifySpanActive("SimpleCommandBus.handle");
        });
        this.spanFactory.verifySpanCompleted("SimpleCommandBus.handle");
    }

    @Test
    void dispatchIsCorrectlyTracedDuringException() {
        this.testSubject.setRollbackConfiguration((RollbackConfiguration)RollbackConfigurationType.UNCHECKED_EXCEPTIONS);
        this.testSubject.subscribe(String.class.getName(), command -> {
            throw new RuntimeException("Some exception");
        });
        this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"Say hi!"), (command, commandResultMessage) -> {
            this.spanFactory.verifySpanCompleted("SimpleCommandBus.dispatch");
            this.spanFactory.verifySpanPropagated("SimpleCommandBus.dispatch", (Message<?>)command);
            this.spanFactory.verifySpanActive("SimpleCommandBus.handle");
        });
        this.spanFactory.verifySpanCompleted("SimpleCommandBus.handle");
        this.spanFactory.verifySpanHasException("SimpleCommandBus.dispatch", RuntimeException.class);
    }

    @Test
    void dispatchCommandImplicitUnitOfWorkIsCommittedOnReturnValue() {
        AtomicReference unitOfWork = new AtomicReference();
        this.testSubject.subscribe(String.class.getName(), command -> {
            unitOfWork.set(CurrentUnitOfWork.get());
            Assertions.assertTrue((boolean)CurrentUnitOfWork.isStarted());
            Assertions.assertNotNull((Object)CurrentUnitOfWork.get());
            return command;
        });
        this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"Say hi!"), (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                commandResultMessage.optionalExceptionResult().ifPresent(Throwable::printStackTrace);
                Assertions.fail((String)"Did not expect exception");
            }
            Assertions.assertEquals((Object)"Say hi!", (Object)((CommandMessage)commandResultMessage.getPayload()).getPayload());
        });
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted());
        Assertions.assertFalse((boolean)((UnitOfWork)unitOfWork.get()).isRolledBack());
        Assertions.assertFalse((boolean)((UnitOfWork)unitOfWork.get()).isActive());
    }

    @Test
    void fireAndForgetUsesDefaultCallback() {
        CommandCallback mockCallback = this.createCallbackMock();
        this.testSubject = SimpleCommandBus.builder().defaultCommandCallback(mockCallback).build();
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"test");
        this.testSubject.dispatch(command, (CommandCallback)NoOpCallback.INSTANCE);
        ((CommandCallback)Mockito.verify((Object)mockCallback, (VerificationMode)Mockito.never())).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)Mockito.any());
        this.testSubject.dispatch(command);
        ((CommandCallback)Mockito.verify((Object)mockCallback)).onResult((CommandMessage)Mockito.eq((Object)command), (CommandResultMessage)Mockito.any());
    }

    @Test
    void dispatchCommandImplicitUnitOfWorkIsRolledBackOnException() {
        AtomicReference unitOfWork = new AtomicReference();
        this.testSubject.subscribe(String.class.getName(), command -> {
            unitOfWork.set(CurrentUnitOfWork.get());
            Assertions.assertTrue((boolean)CurrentUnitOfWork.isStarted());
            Assertions.assertNotNull((Object)CurrentUnitOfWork.get());
            throw new RuntimeException();
        });
        this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"Say hi!"), (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                Throwable cause = commandResultMessage.exceptionResult();
                Assertions.assertEquals(RuntimeException.class, cause.getClass());
            } else {
                Assertions.fail((String)"Expected exception");
            }
        });
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted());
        Assertions.assertTrue((boolean)((UnitOfWork)unitOfWork.get()).isRolledBack());
    }

    @Test
    void dispatchCommandUnitOfWorkIsCommittedOnCheckedException() {
        AtomicReference unitOfWork = new AtomicReference();
        this.testSubject.subscribe(String.class.getName(), command -> {
            unitOfWork.set(CurrentUnitOfWork.get());
            throw new Exception();
        });
        this.testSubject.setRollbackConfiguration((RollbackConfiguration)RollbackConfigurationType.UNCHECKED_EXCEPTIONS);
        this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"Say hi!"), (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                Throwable cause = commandResultMessage.exceptionResult();
                Assertions.assertEquals(Exception.class, cause.getClass());
            } else {
                Assertions.fail((String)"Expected exception");
            }
        });
        Assertions.assertTrue((!((UnitOfWork)unitOfWork.get()).isActive() ? 1 : 0) != 0);
        Assertions.assertTrue((!((UnitOfWork)unitOfWork.get()).isRolledBack() ? 1 : 0) != 0);
    }

    @Test
    void dispatchCommandNoHandlerSubscribed() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"test");
        CommandCallback callback = this.createCallbackMock();
        this.testSubject.dispatch(command, callback);
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)callback)).onResult((CommandMessage)Mockito.eq((Object)command), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertTrue((boolean)((CommandResultMessage)commandResultMessageCaptor.getValue()).isExceptional());
        Assertions.assertEquals(NoHandlerForCommandException.class, ((CommandResultMessage)commandResultMessageCaptor.getValue()).exceptionResult().getClass());
    }

    private CommandCallback createCallbackMock() {
        CommandCallback mock = (CommandCallback)Mockito.mock(CommandCallback.class);
        Mockito.when((Object)mock.wrap((CommandCallback)Mockito.any())).thenCallRealMethod();
        return mock;
    }

    @Test
    void dispatchCommandHandlerUnsubscribed() {
        MyStringCommandHandler commandHandler = new MyStringCommandHandler();
        Registration subscription = this.testSubject.subscribe(String.class.getName(), (MessageHandler)commandHandler);
        subscription.close();
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"Say hi!");
        CommandCallback callback = this.createCallbackMock();
        this.testSubject.dispatch(command, callback);
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)callback)).onResult((CommandMessage)Mockito.eq((Object)command), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertTrue((boolean)((CommandResultMessage)commandResultMessageCaptor.getValue()).isExceptional());
        Assertions.assertEquals(NoHandlerForCommandException.class, ((CommandResultMessage)commandResultMessageCaptor.getValue()).exceptionResult().getClass());
    }

    @Test
    void dispatchCommandNoHandlerSubscribedCallsMonitorCallbackIgnored() throws InterruptedException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        MessageMonitor messageMonitor = message -> new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                Assertions.fail((String)"Expected #reportFailure");
            }

            public void reportFailure(Throwable cause) {
                countDownLatch.countDown();
            }

            public void reportIgnored() {
                Assertions.fail((String)"Expected #reportFailure");
            }
        };
        this.testSubject = SimpleCommandBus.builder().messageMonitor(messageMonitor).build();
        try {
            this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"test"), this.createCallbackMock());
        }
        catch (NoHandlerForCommandException noHandlerForCommandException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)countDownLatch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    void interceptorChainCommandHandledSuccessfully() throws Exception {
        MessageHandlerInterceptor mockInterceptor1 = (MessageHandlerInterceptor)Mockito.mock(MessageHandlerInterceptor.class);
        MessageHandlerInterceptor mockInterceptor2 = (MessageHandlerInterceptor)Mockito.mock(MessageHandlerInterceptor.class);
        MessageHandler commandHandler = (MessageHandler)Mockito.mock(MessageHandler.class);
        Mockito.when((Object)mockInterceptor1.handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class))).thenAnswer(invocation -> mockInterceptor2.handle((UnitOfWork)invocation.getArguments()[0], (InterceptorChain)invocation.getArguments()[1]));
        Mockito.when((Object)mockInterceptor2.handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class))).thenAnswer(invocation -> commandHandler.handle(((UnitOfWork)invocation.getArguments()[0]).getMessage()));
        this.testSubject.registerHandlerInterceptor(mockInterceptor1);
        this.testSubject.registerHandlerInterceptor(mockInterceptor2);
        Mockito.when((Object)commandHandler.handle((Message)Mockito.isA(CommandMessage.class))).thenReturn((Object)"Hi there!");
        this.testSubject.subscribe(String.class.getName(), commandHandler);
        this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"Hi there!"), (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                Throwable cause = commandResultMessage.exceptionResult();
                throw new RuntimeException("Unexpected exception", cause);
            }
            Assertions.assertEquals((Object)"Hi there!", (Object)commandResultMessage.getPayload());
        });
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockInterceptor1, mockInterceptor2, commandHandler});
        ((MessageHandlerInterceptor)inOrder.verify((Object)mockInterceptor1)).handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class));
        ((MessageHandlerInterceptor)inOrder.verify((Object)mockInterceptor2)).handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class));
        ((MessageHandler)inOrder.verify((Object)commandHandler)).handle((Message)Mockito.isA(GenericCommandMessage.class));
    }

    @Test
    void interceptorChainCommandHandlerThrowsException() throws Exception {
        MessageHandlerInterceptor mockInterceptor1 = (MessageHandlerInterceptor)Mockito.mock(MessageHandlerInterceptor.class);
        MessageHandlerInterceptor mockInterceptor2 = (MessageHandlerInterceptor)Mockito.mock(MessageHandlerInterceptor.class);
        MessageHandler commandHandler = (MessageHandler)Mockito.mock(MessageHandler.class);
        Mockito.when((Object)mockInterceptor1.handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class))).thenAnswer(invocation -> mockInterceptor2.handle((UnitOfWork)invocation.getArguments()[0], (InterceptorChain)invocation.getArguments()[1]));
        Mockito.when((Object)mockInterceptor2.handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class))).thenAnswer(invocation -> commandHandler.handle(((UnitOfWork)invocation.getArguments()[0]).getMessage()));
        this.testSubject.registerHandlerInterceptor(mockInterceptor1);
        this.testSubject.registerHandlerInterceptor(mockInterceptor2);
        Mockito.when((Object)commandHandler.handle((Message)Mockito.isA(CommandMessage.class))).thenThrow(new Throwable[]{new RuntimeException("Faking failed command handling")});
        this.testSubject.subscribe(String.class.getName(), commandHandler);
        this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"Hi there!"), (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                Throwable cause = commandResultMessage.exceptionResult();
                Assertions.assertEquals((Object)"Faking failed command handling", (Object)cause.getMessage());
            } else {
                Assertions.fail((String)"Expected exception to be thrown");
            }
        });
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockInterceptor1, mockInterceptor2, commandHandler});
        ((MessageHandlerInterceptor)inOrder.verify((Object)mockInterceptor1)).handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class));
        ((MessageHandlerInterceptor)inOrder.verify((Object)mockInterceptor2)).handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class));
        ((MessageHandler)inOrder.verify((Object)commandHandler)).handle((Message)Mockito.isA(GenericCommandMessage.class));
    }

    @Test
    void interceptorChainInterceptorThrowsException() throws Exception {
        MessageHandlerInterceptor mockInterceptor1 = (MessageHandlerInterceptor)Mockito.mock(MessageHandlerInterceptor.class, (String)"stubName");
        MessageHandlerInterceptor mockInterceptor2 = (MessageHandlerInterceptor)Mockito.mock(MessageHandlerInterceptor.class);
        Mockito.when((Object)mockInterceptor1.handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class))).thenAnswer(invocation -> ((InterceptorChain)invocation.getArguments()[1]).proceed());
        this.testSubject.registerHandlerInterceptor(mockInterceptor1);
        this.testSubject.registerHandlerInterceptor(mockInterceptor2);
        MessageHandler commandHandler = (MessageHandler)Mockito.mock(MessageHandler.class);
        Mockito.when((Object)commandHandler.handle((Message)Mockito.isA(CommandMessage.class))).thenReturn((Object)"Hi there!");
        this.testSubject.subscribe(String.class.getName(), commandHandler);
        RuntimeException someException = new RuntimeException("Mocking");
        ((MessageHandlerInterceptor)Mockito.doThrow((Throwable[])new Throwable[]{someException}).when((Object)mockInterceptor2)).handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class));
        this.testSubject.dispatch(GenericCommandMessage.asCommandMessage((Object)"Hi there!"), (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                Throwable cause = commandResultMessage.exceptionResult();
                Assertions.assertEquals((Object)"Mocking", (Object)cause.getMessage());
            } else {
                Assertions.fail((String)"Expected exception to be propagated");
            }
        });
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockInterceptor1, mockInterceptor2, commandHandler});
        ((MessageHandlerInterceptor)inOrder.verify((Object)mockInterceptor1)).handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class));
        ((MessageHandlerInterceptor)inOrder.verify((Object)mockInterceptor2)).handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class));
        ((MessageHandler)inOrder.verify((Object)commandHandler, Mockito.never())).handle((Message)Mockito.isA(CommandMessage.class));
    }

    @Test
    void commandReplyMessageCorrelationData() {
        this.testSubject.subscribe(String.class.getName(), message -> message.getPayload().toString());
        this.testSubject.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor(new CorrelationDataProvider[]{new MessageOriginProvider()}));
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"Hi");
        this.testSubject.dispatch(command, (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                Assertions.fail((String)"Command execution should be successful");
            }
            Assertions.assertEquals((Object)command.getIdentifier(), (Object)commandResultMessage.getMetaData().get((Object)"traceId"));
            Assertions.assertEquals((Object)command.getIdentifier(), (Object)commandResultMessage.getMetaData().get((Object)"correlationId"));
            Assertions.assertEquals((Object)command.getPayload(), (Object)commandResultMessage.getPayload());
        });
    }

    @Test
    void duplicateCommandHandlerResolverSetsTheExpectedHandler() {
        DuplicateCommandHandlerResolver testDuplicateCommandHandlerResolver = DuplicateCommandHandlerResolution.silentOverride();
        SimpleCommandBus testSubject = SimpleCommandBus.builder().duplicateCommandHandlerResolver(testDuplicateCommandHandlerResolver).build();
        MyStringCommandHandler initialHandler = (MyStringCommandHandler)Mockito.spy((Object)new MyStringCommandHandler());
        MyStringCommandHandler duplicateHandler = (MyStringCommandHandler)Mockito.spy((Object)new MyStringCommandHandler());
        CommandMessage testMessage = GenericCommandMessage.asCommandMessage((Object)"Say hi!");
        testSubject.subscribe(String.class.getName(), (MessageHandler)initialHandler);
        testSubject.subscribe(String.class.getName(), (MessageHandler)duplicateHandler);
        testSubject.dispatch(testMessage);
        ((MyStringCommandHandler)Mockito.verify((Object)duplicateHandler)).handle(testMessage);
        ((MyStringCommandHandler)Mockito.verify((Object)initialHandler, (VerificationMode)Mockito.never())).handle(testMessage);
    }

    private static class MyStringCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private MyStringCommandHandler() {
        }

        public Object handle(CommandMessage<?> message) {
            return message;
        }
    }
}

