/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class DefaultCommandGatewayTest {
    private DefaultCommandGateway testSubject;
    private CommandBus mockCommandBus;
    private RetryScheduler mockRetryScheduler;
    private MessageDispatchInterceptor<CommandMessage<?>> mockCommandMessageTransformer;

    DefaultCommandGatewayTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockCommandBus = (CommandBus)Mockito.mock(CommandBus.class);
        this.mockRetryScheduler = (RetryScheduler)Mockito.mock(RetryScheduler.class);
        this.mockCommandMessageTransformer = (MessageDispatchInterceptor)Mockito.mock(MessageDispatchInterceptor.class);
        Mockito.when((Object)this.mockCommandMessageTransformer.handle((Message)Mockito.isA(CommandMessage.class))).thenAnswer(invocation -> invocation.getArguments()[0]);
        this.testSubject = DefaultCommandGateway.builder().commandBus(this.mockCommandBus).retryScheduler(this.mockRetryScheduler).dispatchInterceptors(new MessageDispatchInterceptor[]{this.mockCommandMessageTransformer}).build();
    }

    @Test
    void sendWithCallbackCommandIsRetried() {
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Throwable)new RuntimeException(new RuntimeException())));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Mockito.when((Object)this.mockRetryScheduler.scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.isA(RuntimeException.class), (List)Mockito.isA(List.class), (Runnable)Mockito.isA(Runnable.class))).thenAnswer((Answer)new RescheduleCommand()).thenReturn((Object)false);
        AtomicReference actualResult = new AtomicReference();
        this.testSubject.send((Object)"Command", (commandMessage, commandResultMessage) -> actualResult.set(commandResultMessage));
        ((MessageDispatchInterceptor)Mockito.verify(this.mockCommandMessageTransformer)).handle((Message)Mockito.isA(CommandMessage.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((RetryScheduler)Mockito.verify((Object)this.mockRetryScheduler, (VerificationMode)Mockito.times((int)2))).scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.isA(RuntimeException.class), (List)captor.capture(), (Runnable)Mockito.isA(Runnable.class));
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus, (VerificationMode)Mockito.times((int)2))).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Assertions.assertTrue((boolean)((CommandResultMessage)actualResult.get()).isExceptional());
        Assertions.assertTrue((boolean)(((CommandResultMessage)actualResult.get()).exceptionResult() instanceof RuntimeException));
        Assertions.assertEquals((int)1, (int)((List)captor.getAllValues().get(0)).size());
        Assertions.assertEquals((int)2, (int)((List)captor.getValue()).size());
        Assertions.assertEquals((int)2, (int)((Class[])((List)captor.getValue()).get(0)).length);
    }

    @Test
    void sendWithoutCallbackCommandIsRetried() {
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Throwable)new RuntimeException(new RuntimeException())));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Mockito.when((Object)this.mockRetryScheduler.scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.isA(RuntimeException.class), (List)Mockito.isA(List.class), (Runnable)Mockito.isA(Runnable.class))).thenAnswer((Answer)new RescheduleCommand()).thenReturn((Object)false);
        CompletableFuture future = this.testSubject.send((Object)"Command");
        ((MessageDispatchInterceptor)Mockito.verify(this.mockCommandMessageTransformer)).handle((Message)Mockito.isA(CommandMessage.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((RetryScheduler)Mockito.verify((Object)this.mockRetryScheduler, (VerificationMode)Mockito.times((int)2))).scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.isA(RuntimeException.class), (List)captor.capture(), (Runnable)Mockito.isA(Runnable.class));
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus, (VerificationMode)Mockito.times((int)2))).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Assertions.assertEquals((int)1, (int)((List)captor.getAllValues().get(0)).size());
        Assertions.assertEquals((int)2, (int)((List)captor.getValue()).size());
        Assertions.assertEquals((int)2, (int)((Class[])((List)captor.getValue()).get(0)).length);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
    }

    @Test
    void sendWithoutCallback() throws ExecutionException, InterruptedException {
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Object)"returnValue"));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        CompletableFuture future = this.testSubject.send((Object)"Command");
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)"returnValue", future.get());
    }

    @Test
    void sendWithoutCallbackCustomizedCallbackIsCalled() throws ExecutionException, InterruptedException {
        AtomicBoolean finalCallbackCalled = new AtomicBoolean(false);
        AtomicBoolean customizedCallbackCalled = new AtomicBoolean(false);
        this.testSubject = DefaultCommandGateway.builder().commandBus(this.mockCommandBus).retryScheduler(this.mockRetryScheduler).dispatchInterceptors(new MessageDispatchInterceptor[]{this.mockCommandMessageTransformer}).commandCallback((commandMessage, commandResultMessage) -> {
            customizedCallbackCalled.set(true);
            Assertions.assertFalse((boolean)finalCallbackCalled.get());
        }).build();
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Object)"returnValue"));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        CompletionStage future = this.testSubject.send((Object)"Command").whenComplete((o, throwable) -> finalCallbackCalled.set(true));
        Assertions.assertTrue((boolean)((CompletableFuture)future).isDone());
        Assertions.assertTrue((boolean)customizedCallbackCalled.get());
        Assertions.assertEquals((Object)"returnValue", ((CompletableFuture)future).get());
    }

    @Test
    void sendAndWaitCommandIsRetried() {
        RuntimeException failure = new RuntimeException(new RuntimeException());
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Throwable)failure));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Mockito.when((Object)this.mockRetryScheduler.scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.isA(RuntimeException.class), (List)Mockito.isA(List.class), (Runnable)Mockito.isA(Runnable.class))).thenAnswer((Answer)new RescheduleCommand()).thenReturn((Object)false);
        try {
            this.testSubject.sendAndWait((Object)"Command");
        }
        catch (RuntimeException rte) {
            Assertions.assertSame((Object)failure, (Object)rte);
        }
        ((MessageDispatchInterceptor)Mockito.verify(this.mockCommandMessageTransformer)).handle((Message)Mockito.isA(CommandMessage.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((RetryScheduler)Mockito.verify((Object)this.mockRetryScheduler, (VerificationMode)Mockito.times((int)2))).scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.isA(RuntimeException.class), (List)captor.capture(), (Runnable)Mockito.isA(Runnable.class));
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus, (VerificationMode)Mockito.times((int)2))).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Assertions.assertEquals((int)1, (int)((List)captor.getAllValues().get(0)).size());
        Assertions.assertEquals((int)2, (int)((List)captor.getValue()).size());
        Assertions.assertEquals((int)2, (int)((Class[])((List)captor.getValue()).get(0)).length);
    }

    @Test
    void sendAndWaitWithTimeoutCommandIsRetried() {
        RuntimeException failure = new RuntimeException(new RuntimeException());
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Throwable)failure));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Mockito.when((Object)this.mockRetryScheduler.scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.isA(RuntimeException.class), (List)Mockito.isA(List.class), (Runnable)Mockito.isA(Runnable.class))).thenAnswer((Answer)new RescheduleCommand()).thenReturn((Object)false);
        try {
            this.testSubject.sendAndWait((Object)"Command", 1L, TimeUnit.SECONDS);
        }
        catch (RuntimeException rte) {
            Assertions.assertSame((Object)failure, (Object)rte);
        }
        ((MessageDispatchInterceptor)Mockito.verify(this.mockCommandMessageTransformer)).handle((Message)Mockito.isA(CommandMessage.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((RetryScheduler)Mockito.verify((Object)this.mockRetryScheduler, (VerificationMode)Mockito.times((int)2))).scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.isA(RuntimeException.class), (List)captor.capture(), (Runnable)Mockito.isA(Runnable.class));
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus, (VerificationMode)Mockito.times((int)2))).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Assertions.assertEquals((int)1, (int)((List)captor.getAllValues().get(0)).size());
        Assertions.assertEquals((int)2, (int)((List)captor.getValue()).size());
        Assertions.assertEquals((int)2, (int)((Class[])((List)captor.getValue()).get(0)).length);
    }

    @Test
    void sendAndWaitNullOnInterrupt() {
        ((CommandBus)Mockito.doAnswer(invocation -> {
            Thread.currentThread().interrupt();
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Assertions.assertNull((Object)this.testSubject.sendAndWait((Object)"Hello"));
        Assertions.assertTrue((boolean)Thread.interrupted(), (String)"Interrupt flag should be set on thread");
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
    }

    @Test
    void sendAndWaitWithTimeoutNullOnInterrupt() {
        ((CommandBus)Mockito.doAnswer(invocation -> {
            Thread.currentThread().interrupt();
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        try {
            this.testSubject.sendAndWait((Object)"Hello", 60L, TimeUnit.SECONDS);
            this.testSubject.sendAndWait((Object)"Hello", 60L, TimeUnit.SECONDS);
            Assertions.fail((String)"Expected interrupted exception");
        }
        catch (CommandExecutionException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof InterruptedException));
        }
        Assertions.assertTrue((boolean)Thread.interrupted(), (String)"Interrupt flag should be set on thread");
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
    }

    @Test
    void sendAndWaitWithTimeoutNullOnTimeout() {
        try {
            Assertions.assertNull((Object)this.testSubject.sendAndWait((Object)"Hello", 10L, TimeUnit.MILLISECONDS));
            Assertions.fail((String)"Expected interrupted exception");
        }
        catch (CommandExecutionException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
        }
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
    }

    @Test
    void correlationDataIsAttachedToCommandAsObject() {
        DefaultUnitOfWork unitOfWork = DefaultUnitOfWork.startAndGet(null);
        unitOfWork.registerCorrelationDataProvider(message -> Collections.singletonMap("correlationId", "test"));
        this.testSubject.send((Object)"Hello");
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.argThat(x -> "test".equals(x.getMetaData().get((Object)"correlationId"))), (CommandCallback)Mockito.isA(CommandCallback.class));
        CurrentUnitOfWork.clear((UnitOfWork)unitOfWork);
    }

    @Test
    void correlationDataIsAttachedToCommandAsMessage() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("correlationId", "test");
        data.put("header", "someValue");
        DefaultUnitOfWork unitOfWork = DefaultUnitOfWork.startAndGet(null);
        unitOfWork.registerCorrelationDataProvider(message -> data);
        this.testSubject.send((Object)new GenericCommandMessage((Object)"Hello", Collections.singletonMap("header", "value")));
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.argThat(x -> "test".equals(x.getMetaData().get((Object)"correlationId")) && "value".equals(x.getMetaData().get((Object)"header"))), (CommandCallback)Mockito.isA(CommandCallback.class));
        CurrentUnitOfWork.clear((UnitOfWork)unitOfWork);
    }

    @Test
    void payloadExtractionProblemsReportedInException() throws ExecutionException, InterruptedException {
        ((CommandBus)Mockito.doAnswer(i -> {
            CommandCallback callback = (CommandCallback)i.getArgument(1);
            callback.onResult((CommandMessage)i.getArgument(0), (CommandResultMessage)new GenericCommandResultMessage<String>("result"){
                private static final long serialVersionUID = -5443344481326465863L;

                public String getPayload() {
                    throw new MockException("Faking serialization problem");
                }
            });
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.any(), (CommandCallback)Mockito.any());
        CompletableFuture actual = this.testSubject.send((Object)"command");
        Assertions.assertTrue((boolean)actual.isDone());
        Assertions.assertTrue((boolean)actual.isCompletedExceptionally());
        Assertions.assertEquals((Object)"Faking serialization problem", ((CompletableFuture)actual.exceptionally(Throwable::getMessage)).get());
    }

    @Test
    void sendAndWaitAttachesMetaData() {
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Object)"returnValue"));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        String expectedPayload = "command";
        MetaData expectedMetaData = MetaData.with((String)"key", (Object)"value");
        this.testSubject.sendAndWait((Object)expectedPayload, expectedMetaData);
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(CommandMessage.class);
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)messageCaptor.capture(), (CommandCallback)Mockito.isA(CommandCallback.class));
        CommandMessage result = (CommandMessage)messageCaptor.getValue();
        Assertions.assertEquals((Object)expectedPayload, (Object)result.getPayload());
        Assertions.assertEquals((Object)expectedMetaData, (Object)result.getMetaData());
    }

    @Test
    void sendAndWaitWithTimeoutAttachesMetaData() {
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Object)"returnValue"));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        String expectedPayload = "command";
        MetaData expectedMetaData = MetaData.with((String)"key", (Object)"value");
        this.testSubject.sendAndWait((Object)expectedPayload, expectedMetaData, 10L, TimeUnit.MILLISECONDS);
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(CommandMessage.class);
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)messageCaptor.capture(), (CommandCallback)Mockito.isA(CommandCallback.class));
        CommandMessage result = (CommandMessage)messageCaptor.getValue();
        Assertions.assertEquals((Object)expectedPayload, (Object)result.getPayload());
        Assertions.assertEquals((Object)expectedMetaData, (Object)result.getMetaData());
    }

    @Test
    void sendAttachesMetaData() {
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Object)"returnValue"));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        String expectedPayload = "command";
        MetaData expectedMetaData = MetaData.with((String)"key", (Object)"value");
        this.testSubject.send((Object)expectedPayload, expectedMetaData);
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(CommandMessage.class);
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)messageCaptor.capture(), (CommandCallback)Mockito.isA(CommandCallback.class));
        CommandMessage result = (CommandMessage)messageCaptor.getValue();
        Assertions.assertEquals((Object)expectedPayload, (Object)result.getPayload());
        Assertions.assertEquals((Object)expectedMetaData, (Object)result.getMetaData());
    }

    @Test
    void commandCallbackIsCustomized() {
        AtomicBoolean customizedCallbackIsCalled = new AtomicBoolean();
        this.testSubject = DefaultCommandGateway.builder().commandBus(this.mockCommandBus).retryScheduler(this.mockRetryScheduler).dispatchInterceptors(new MessageDispatchInterceptor[]{this.mockCommandMessageTransformer}).commandCallback((commandMessage, commandResultMessage) -> customizedCallbackIsCalled.set(true)).build();
        ((CommandBus)Mockito.doAnswer(invocation -> {
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Object)"returnValue"));
            return null;
        }).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        String expectedPayload = "command";
        this.testSubject.send((Object)expectedPayload, MetaData.emptyInstance());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(CommandMessage.class);
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)messageCaptor.capture(), (CommandCallback)Mockito.isA(CommandCallback.class));
        CommandMessage result = (CommandMessage)messageCaptor.getValue();
        Assertions.assertEquals((Object)expectedPayload, (Object)result.getPayload());
        Assertions.assertTrue((boolean)customizedCallbackIsCalled.get());
    }

    private static class RescheduleCommand
    implements Answer<Boolean> {
        private RescheduleCommand() {
        }

        public Boolean answer(InvocationOnMock invocation) {
            ((Runnable)invocation.getArguments()[3]).run();
            return true;
        }
    }
}

