/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import org.axonframework.common.IdentifierValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IdentifierValidatorTest {
    private final IdentifierValidator validator = IdentifierValidator.getInstance();

    IdentifierValidatorTest() {
    }

    @Test
    void boxedPrimitivesAreValidIdentifiers() {
        Assertions.assertTrue((boolean)this.validator.isValidIdentifier(Long.class));
        Assertions.assertTrue((boolean)this.validator.isValidIdentifier(Integer.class));
        Assertions.assertTrue((boolean)this.validator.isValidIdentifier(Double.class));
        Assertions.assertTrue((boolean)this.validator.isValidIdentifier(Short.class));
    }

    @Test
    void stringIsValidIdentifier() {
        Assertions.assertTrue((boolean)this.validator.isValidIdentifier(CharSequence.class));
    }

    @Test
    void typeWithoutToStringIsNotAccepted() {
        Assertions.assertFalse((boolean)this.validator.isValidIdentifier(CustomType.class));
    }

    @Test
    void typeWithOverriddenToString() {
        Assertions.assertTrue((boolean)this.validator.isValidIdentifier(CustomType2.class));
    }

    private static class CustomType2 {
        private CustomType2() {
        }

        public String toString() {
            return "ok";
        }
    }

    private static class CustomType {
        private CustomType() {
        }
    }
}

