/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.ResultSet;
import org.axonframework.common.jdbc.JdbcUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class JdbcUtilsTest {
    JdbcUtilsTest() {
    }

    @Test
    void nextAndExtract_EmptyResultSet() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)false);
        Assertions.assertNull((Object)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class));
    }

    @Test
    void nextAndExtract_NullValue() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when(resultSet.getObject(ArgumentMatchers.eq((int)1), (Class)ArgumentMatchers.eq(Long.class))).thenReturn(null);
        Assertions.assertNull((Object)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class));
    }

    @Test
    void nextAndExtract_NonNullValue() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when(resultSet.getObject(ArgumentMatchers.eq((int)1), (Class)ArgumentMatchers.eq(Long.class))).thenReturn((Object)10L);
        Assertions.assertEquals((Long)10L, (Long)((Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class)));
    }

    @Test
    void nextAndExtract_NonNullValue_WasNull() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when(resultSet.getObject(ArgumentMatchers.eq((int)1), (Class)ArgumentMatchers.eq(Long.class))).thenReturn((Object)0L);
        Mockito.when((Object)resultSet.wasNull()).thenReturn((Object)true);
        Assertions.assertNull((Object)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class));
    }
}

