/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.legacyjpa;

import java.sql.SQLException;
import java.time.Clock;
import java.time.Instant;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.legacyjpa.EntityManagerProvider;
import org.axonframework.common.legacyjpa.SimpleEntityManagerProvider;
import org.axonframework.common.transaction.NoOpTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.deadletter.legacyjpa.JpaDeadLetter;
import org.axonframework.eventhandling.deadletter.legacyjpa.JpaSequencedDeadLetterQueue;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueueTest;
import org.axonframework.messaging.deadletter.WrongDeadLetterTypeException;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class JpaSequencedDeadLetterQueueTest
extends SequencedDeadLetterQueueTest<EventMessage<?>> {
    private static final int MAX_SEQUENCES_AND_SEQUENCE_SIZE = 64;
    private final TransactionManager transactionManager = (TransactionManager)Mockito.spy((Object)new NoOpTransactionManager());
    private final EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"dlq");
    private final EntityManager entityManager = this.emf.createEntityManager();
    private EntityTransaction transaction;

    JpaSequencedDeadLetterQueueTest() {
    }

    @BeforeEach
    public void setUpJpa() throws SQLException {
        this.transaction = this.entityManager.getTransaction();
        this.transaction.begin();
    }

    @AfterEach
    public void rollback() {
        this.transaction.rollback();
    }

    @Override
    protected void setClock(Clock clock) {
        GenericDeadLetter.clock = clock;
    }

    @Override
    protected long maxSequences() {
        return 64L;
    }

    @Override
    protected long maxSequenceSize() {
        return 64L;
    }

    @Override
    public DeadLetter<EventMessage<?>> generateInitialLetter() {
        return new GenericDeadLetter((Object)"sequenceIdentifier", JpaSequencedDeadLetterQueueTest.generateEvent(), JpaSequencedDeadLetterQueueTest.generateThrowable());
    }

    @Override
    protected DeadLetter<EventMessage<?>> generateFollowUpLetter() {
        return new GenericDeadLetter((Object)"sequenceIdentifier", JpaSequencedDeadLetterQueueTest.generateEvent());
    }

    @Override
    protected DeadLetter<EventMessage<?>> mapToQueueImplementation(DeadLetter<EventMessage<?>> deadLetter) {
        if (deadLetter instanceof org.axonframework.eventhandling.deadletter.jpa.JpaDeadLetter) {
            return deadLetter;
        }
        if (deadLetter instanceof GenericDeadLetter) {
            return new JpaDeadLetter(IdentifierFactory.getInstance().generateIdentifier(), Long.valueOf(0L), ((GenericDeadLetter)deadLetter).getSequenceIdentifier().toString(), deadLetter.enqueuedAt(), deadLetter.lastTouched(), (Cause)deadLetter.cause().orElse(null), deadLetter.diagnostics(), (EventMessage)deadLetter.message());
        }
        throw new IllegalArgumentException("Can not map dead letter of type " + deadLetter.getClass().getName());
    }

    @Override
    protected DeadLetter<EventMessage<?>> generateRequeuedLetter(DeadLetter<EventMessage<?>> original, Instant lastTouched, Throwable requeueCause, MetaData diagnostics) {
        this.setAndGetTime(lastTouched);
        return original.withCause(requeueCause).withDiagnostics(diagnostics).markTouched();
    }

    @Override
    protected void assertLetter(DeadLetter<? extends EventMessage<?>> expected, DeadLetter<? extends EventMessage<?>> actual) {
        Assertions.assertEquals((Object)((EventMessage)expected.message()).getPayload(), (Object)((EventMessage)actual.message()).getPayload());
        Assertions.assertEquals((Object)((EventMessage)expected.message()).getPayloadType(), (Object)((EventMessage)actual.message()).getPayloadType());
        Assertions.assertEquals((Object)((EventMessage)expected.message()).getMetaData(), (Object)((EventMessage)actual.message()).getMetaData());
        Assertions.assertEquals((Object)((EventMessage)expected.message()).getIdentifier(), (Object)((EventMessage)actual.message()).getIdentifier());
        Assertions.assertEquals((Object)expected.cause(), (Object)actual.cause());
        Assertions.assertEquals((Object)expected.enqueuedAt(), (Object)actual.enqueuedAt());
        Assertions.assertEquals((Object)expected.lastTouched(), (Object)actual.lastTouched());
        Assertions.assertEquals((Object)expected.diagnostics(), (Object)actual.diagnostics());
    }

    @Override
    public SequencedDeadLetterQueue<EventMessage<?>> buildTestSubject() {
        SimpleEntityManagerProvider entityManagerProvider = new SimpleEntityManagerProvider(this.entityManager);
        return JpaSequencedDeadLetterQueue.builder().transactionManager(this.transactionManager).entityManagerProvider((EntityManagerProvider)entityManagerProvider).maxSequences(64).maxSequenceSize(64).processingGroup("my_processing_group").eventSerializer(TestSerializer.JACKSON.getSerializer()).genericSerializer(TestSerializer.XSTREAM.getSerializer()).build();
    }

    @Test
    void buildWithNegativeMaxQueuesThrowsAxonConfigurationException() {
        JpaSequencedDeadLetterQueue.Builder builderTestSubject = JpaSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.maxSequences(-1));
    }

    @Test
    void buildWithZeroMaxQueuesThrowsAxonConfigurationException() {
        JpaSequencedDeadLetterQueue.Builder builderTestSubject = JpaSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.maxSequences(0));
    }

    @Test
    void buildWithNegativeMaxQueueSizeThrowsAxonConfigurationException() {
        JpaSequencedDeadLetterQueue.Builder builderTestSubject = JpaSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.maxSequenceSize(-1));
    }

    @Test
    void buildWithZeroMaxQueueSizeThrowsAxonConfigurationException() {
        JpaSequencedDeadLetterQueue.Builder builderTestSubject = JpaSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.maxSequenceSize(0));
    }

    @Test
    void canNotSetNegativeQueryPageSize() {
        JpaSequencedDeadLetterQueue.Builder builder = JpaSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.queryPageSize(-1));
    }

    @Test
    void canNotSetZeroQueryPageSize() {
        JpaSequencedDeadLetterQueue.Builder builder = JpaSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.queryPageSize(0));
    }

    @Test
    void cannotRequeueGenericDeadLetter() {
        SequencedDeadLetterQueue<EventMessage<?>> queue = this.buildTestSubject();
        DeadLetter<EventMessage<?>> letter = this.generateInitialLetter();
        Assertions.assertThrows(WrongDeadLetterTypeException.class, () -> queue.requeue(letter, d -> d));
    }

    @Test
    void cannotEvictGenericDeadLetter() {
        SequencedDeadLetterQueue<EventMessage<?>> queue = this.buildTestSubject();
        DeadLetter<EventMessage<?>> letter = this.generateInitialLetter();
        Assertions.assertThrows(WrongDeadLetterTypeException.class, () -> queue.evict(letter));
    }

    @Test
    void canNotSetProcessingGroupToEmpty() {
        JpaSequencedDeadLetterQueue.Builder builder = JpaSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.processingGroup(""));
    }

    @Test
    void canNotSetProcessingGroupToNull() {
        JpaSequencedDeadLetterQueue.Builder builder = JpaSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.processingGroup(""));
    }

    @Test
    void canNotBuildWithoutProcessingGroup() {
        JpaSequencedDeadLetterQueue.Builder builder = JpaSequencedDeadLetterQueue.builder().transactionManager(this.transactionManager).entityManagerProvider(() -> this.entityManager).serializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JpaSequencedDeadLetterQueue.Builder)builder).build());
    }

    @Test
    void canNotBuildWithoutTransactionManager() {
        JpaSequencedDeadLetterQueue.Builder builder = JpaSequencedDeadLetterQueue.builder().processingGroup("my_processing_Group").entityManagerProvider(() -> this.entityManager).serializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JpaSequencedDeadLetterQueue.Builder)builder).build());
    }

    @Test
    void canNotBuildWithoutEntityManagerProvider() {
        JpaSequencedDeadLetterQueue.Builder builder = JpaSequencedDeadLetterQueue.builder().processingGroup("my_processing_Group").transactionManager(this.transactionManager).serializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JpaSequencedDeadLetterQueue.Builder)builder).build());
    }

    @Test
    void canNotAddNullConverterWhileBuilding() {
        JpaSequencedDeadLetterQueue.Builder builderTestSubject = JpaSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.addConverter(null));
    }
}

