/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.ReplayStatus;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.TrackingToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReplayParameterResolverFactoryTest {
    private SomeHandler handler;
    private AnnotationEventHandlerAdapter testSubject;
    private ReplayToken replayToken;
    private GlobalSequenceTrackingToken regularToken;

    ReplayParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.handler = new SomeHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)this.handler);
        this.regularToken = new GlobalSequenceTrackingToken(1L);
        this.replayToken = new ReplayToken((TrackingToken)this.regularToken);
    }

    @Test
    void invokeWithReplayTokens() throws Exception {
        GenericTrackedEventMessage replayEvent = new GenericTrackedEventMessage((TrackingToken)this.replayToken, GenericEventMessage.asEventMessage((Object)1L));
        GenericTrackedEventMessage liveEvent = new GenericTrackedEventMessage((TrackingToken)this.regularToken, GenericEventMessage.asEventMessage((Object)2L));
        Assertions.assertTrue((boolean)this.testSubject.canHandle((EventMessage)replayEvent));
        Assertions.assertTrue((boolean)this.testSubject.canHandle((EventMessage)liveEvent));
        this.testSubject.handle((EventMessage)replayEvent);
        this.testSubject.handle((EventMessage)liveEvent);
        Assertions.assertEquals(Arrays.asList(1L, 2L), (Object)this.handler.receivedLongs);
        Assertions.assertEquals(Collections.singletonList(1L), (Object)this.handler.receivedInReplay);
    }

    private static class SomeHandler {
        private List<Long> receivedLongs = new ArrayList<Long>();
        private List<Long> receivedInReplay = new ArrayList<Long>();

        private SomeHandler() {
        }

        @EventHandler
        public void handle(Long event, TrackingToken token, ReplayStatus replayStatus) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedLongs.add(event);
            if (replayStatus.isReplay()) {
                this.receivedInReplay.add(event);
            }
        }
    }
}

